/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.database;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.ActiveRecordType;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.database.RailsTableDefinition;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RailsSchemaCallable
implements PsiCallable {
    public static final Map<String, String> PRIMARY_KEY_TYPES = Map.of("serial", "integer", "uuid", "string");
    private final Map<String, RailsTableDefinition> myTableDefinitions;

    public RailsSchemaCallable() {
        this(Collections.emptyMap());
    }

    public RailsSchemaCallable(@NotNull Map<String, RailsTableDefinition> tableDefinitions) {
        if (tableDefinitions == null) {
            RailsSchemaCallable.$$$reportNull$$$0(0);
        }
        this.myTableDefinitions = new HashMap<String, RailsTableDefinition>();
        this.myTableDefinitions.putAll(tableDefinitions);
    }

    @NotNull
    public Map<String, RailsTableDefinition> getTableDefinitions() {
        Map<String, RailsTableDefinition> map = Collections.unmodifiableMap(this.myTableDefinitions);
        if (map == null) {
            RailsSchemaCallable.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Override
    public void processCall(@NotNull RCallArguments arguments) {
        String command;
        if (arguments == null) {
            RailsSchemaCallable.$$$reportNull$$$0(2);
        }
        switch (command = arguments.getCommand()) {
            case "add_column": {
                this.parseColumnCall(new MyColumnCallParser(arguments));
                break;
            }
            case "change_column": {
                this.parseChangeColumnCall(new MyColumnCallParser(arguments));
                break;
            }
            case "change_table": {
                this.parseChangeTableCall(arguments);
                break;
            }
            case "create_table": {
                this.parseCreateTableCall(arguments);
                break;
            }
            case "remove_column": 
            case "remove_columns": {
                this.parseRemoveColumnCall(new MyColumnCallParser(arguments));
                break;
            }
            case "rename_column": {
                this.parseRenameColumnCall(new MyColumnCallParser(arguments));
                break;
            }
            case "rename_table": {
                this.parseRenameTableCall(arguments);
                break;
            }
            case "transaction": {
                arguments.interpretBlock(new PsiCallable[0]);
            }
        }
    }

    @Nullable
    private MigrationField findField(@NotNull String tableName, @NotNull String fieldName) {
        if (tableName == null) {
            RailsSchemaCallable.$$$reportNull$$$0(3);
        }
        if (fieldName == null) {
            RailsSchemaCallable.$$$reportNull$$$0(4);
        }
        return (MigrationField)ObjectUtils.doIfNotNull((Object)this.myTableDefinitions.get(tableName), tableDefinition -> tableDefinition.findFieldByName(fieldName));
    }

    private void createTable(@NotNull String tableName, @NotNull RCallArguments arguments) {
        if (tableName == null) {
            RailsSchemaCallable.$$$reportNull$$$0(5);
        }
        if (arguments == null) {
            RailsSchemaCallable.$$$reportNull$$$0(6);
        }
        RailsTableDefinition definition = new RailsTableDefinition((PsiElement)arguments.getArguments().get(0));
        String idValue = (String)ObjectUtils.coalesce((Object)arguments.getOptionValue("id"), (Object)"serial");
        if (!idValue.equals("false")) {
            String primaryKeyName = arguments.getOptionValue("primary_key", "id");
            String primaryKeyType = PRIMARY_KEY_TYPES.getOrDefault(idValue, "integer");
            if (primaryKeyName != null) {
                PsiElement argumentCall = RailsSchemaCallable.getStubOrPsiElement(arguments);
                MigrationField tableMigrationField = new MigrationField(primaryKeyName, primaryKeyType, argumentCall);
                definition.addField(tableMigrationField);
            }
        }
        this.myTableDefinitions.put(tableName, definition);
    }

    private void parseChangeColumnCall(@NotNull MyColumnCallParser parser) {
        if (parser == null) {
            RailsSchemaCallable.$$$reportNull$$$0(7);
        }
        String tableName = parser.getTableName();
        String columnName = parser.nextArgument();
        String dataType = parser.nextArgument();
        if (tableName == null || columnName == null) {
            return;
        }
        MigrationField field = this.findField(tableName, columnName);
        if (field == null) {
            return;
        }
        PsiElement changeColumnCall = parser.getCall();
        field.setDataType(dataType);
        field.addDeclaration(changeColumnCall);
    }

    private void parseChangeTableCall(@NotNull RCallArguments arguments) {
        String tableName;
        if (arguments == null) {
            RailsSchemaCallable.$$$reportNull$$$0(8);
        }
        if ((tableName = arguments.evaluateArgument(0)) != null) {
            arguments.interpretBlock(new MyChangeTableCallable(tableName));
        }
    }

    private void parseColumnCall(@NotNull MyColumnCallParser parser) {
        RailsTableDefinition tableDefinition;
        if (parser == null) {
            RailsSchemaCallable.$$$reportNull$$$0(9);
        }
        if ((tableDefinition = this.myTableDefinitions.get(parser.getTableName())) != null) {
            String fieldName = parser.nextArgument();
            if (fieldName == null) {
                return;
            }
            PsiElement columnCall = parser.getCall();
            MigrationField columnMigrationField = new MigrationField(fieldName, parser.getDataType(), columnCall);
            tableDefinition.addField(columnMigrationField);
        }
    }

    private void parseCreateTableCall(@NotNull RCallArguments arguments) {
        String tableName;
        if (arguments == null) {
            RailsSchemaCallable.$$$reportNull$$$0(10);
        }
        if ((tableName = arguments.evaluateArgument(0)) == null) {
            return;
        }
        if (!this.myTableDefinitions.containsKey(tableName)) {
            this.createTable(tableName, arguments);
        }
        arguments.interpretBlock(new MyCreateTableCallable(tableName));
    }

    private void parseRemoveColumnCall(@NotNull MyColumnCallParser parser) {
        RailsTableDefinition tableDefinition;
        List fields;
        if (parser == null) {
            RailsSchemaCallable.$$$reportNull$$$0(11);
        }
        if ((fields = (List)ObjectUtils.doIfNotNull((Object)(tableDefinition = this.myTableDefinitions.get(parser.getTableName())), RailsTableDefinition::getFields)) == null) {
            return;
        }
        String name = parser.nextArgument();
        while (name != null) {
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                if (!Objects.equals(((MigrationField)it.next()).getName(), name)) continue;
                it.remove();
                break;
            }
            name = parser.nextArgument();
        }
    }

    private void parseRenameColumnCall(@NotNull MyColumnCallParser parser) {
        if (parser == null) {
            RailsSchemaCallable.$$$reportNull$$$0(12);
        }
        String tableName = parser.getTableName();
        String oldName = parser.nextArgument();
        String newName = parser.nextArgument();
        if (tableName == null || oldName == null || newName == null) {
            return;
        }
        MigrationField field = this.findField(tableName, oldName);
        if (field == null) {
            return;
        }
        PsiElement changeColumnCall = parser.getCall();
        field.setName(newName);
        field.addDeclaration(changeColumnCall);
    }

    private void parseRenameTableCall(@NotNull RCallArguments arguments) {
        if (arguments == null) {
            RailsSchemaCallable.$$$reportNull$$$0(13);
        }
        String oldTableName = arguments.evaluateArgument(0);
        String newTableName = arguments.evaluateArgument(1);
        if (oldTableName == null || newTableName == null) {
            return;
        }
        RailsTableDefinition definition = this.myTableDefinitions.get(oldTableName);
        if (definition == null) {
            return;
        }
        this.myTableDefinitions.remove(oldTableName);
        this.myTableDefinitions.put(newTableName, definition);
    }

    private void processTableColumnCall(@NotNull String tableName, @NotNull String command, @NotNull RCallArguments arguments) {
        RailsTableDefinition tableDefinitionAndFields;
        if (tableName == null) {
            RailsSchemaCallable.$$$reportNull$$$0(14);
        }
        if (command == null) {
            RailsSchemaCallable.$$$reportNull$$$0(15);
        }
        if (arguments == null) {
            RailsSchemaCallable.$$$reportNull$$$0(16);
        }
        if (command.equals("belongs_to") || command.equals("references")) {
            PsiElement argument;
            for (int i = 0; i < arguments.getArguments().size() && ((argument = (PsiElement)arguments.getArguments().get(i)) instanceof RSymbol || argument instanceof RBaseString); ++i) {
                RailsTableDefinition tableDefinitionAndFields2;
                String refName = arguments.evaluateArgument(i);
                if (refName == null || (tableDefinitionAndFields2 = this.myTableDefinitions.get(tableName)) == null) continue;
                PsiElement argumentCall = RailsSchemaCallable.getStubOrPsiElement(arguments);
                String idFieldName = refName + "_id";
                MigrationField idMigrationField = new MigrationField(idFieldName, "integer", argumentCall);
                tableDefinitionAndFields2.addField(idMigrationField);
                if (arguments.getOptionValue("polymorphic") == null) continue;
                String typeFieldName = refName + "_type";
                MigrationField typeMigrationField = new MigrationField(typeFieldName, "string", argumentCall);
                tableDefinitionAndFields2.addField(typeMigrationField);
            }
        } else if (command.equals("column")) {
            this.parseColumnCall(new MyColumnCallParser(arguments, tableName));
        } else if (ActiveRecordType.COLUMN_TYPES.contains(command)) {
            this.parseColumnCall(new MyColumnCallParser(arguments, tableName, command));
        } else if (command.equals("timestamps") && (tableDefinitionAndFields = this.myTableDefinitions.get(tableName)) != null) {
            PsiElement callElement = RailsSchemaCallable.getStubOrPsiElement(arguments);
            MigrationField createdAtMigrationField = new MigrationField("created_at", "timestamp", callElement);
            tableDefinitionAndFields.addField(createdAtMigrationField);
            MigrationField updatedAtField = new MigrationField("updated_at", "timestamp", callElement);
            tableDefinitionAndFields.addField(updatedAtField);
        }
    }

    @NotNull
    private static PsiElement getStubOrPsiElement(@NotNull RCallArguments callArguments) {
        PsiElement callPsiElement;
        RCall stubParentCall;
        if (callArguments == null) {
            RailsSchemaCallable.$$$reportNull$$$0(17);
        }
        if ((stubParentCall = (RCall)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)(callPsiElement = callArguments.getCallElement()), RCall.class)) != null) {
            RCall rCall = stubParentCall;
            if (rCall == null) {
                RailsSchemaCallable.$$$reportNull$$$0(18);
            }
            return rCall;
        }
        PsiElement psiElement = callPsiElement;
        if (psiElement == null) {
            RailsSchemaCallable.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableDefinitions";
                break;
            }
            case 1: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/RailsSchemaCallable";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/RailsSchemaCallable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableDefinitions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOrPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 18: 
            case 19: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processCall";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseChangeColumnCall";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseChangeTableCall";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseColumnCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseCreateTableCall";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseRemoveColumnCall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseRenameColumnCall";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseRenameTableCall";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processTableColumnCall";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 18, 19 -> new IllegalStateException(string);
        };
    }

    private static final class MyColumnCallParser {
        private final RCallArguments myArguments;
        @Nullable
        private final String myTableName;
        @Nullable
        private final String myDataType;
        private int myIndex;

        private MyColumnCallParser(@NotNull RCallArguments arguments) {
            if (arguments == null) {
                MyColumnCallParser.$$$reportNull$$$0(0);
            }
            this(arguments, null, null);
        }

        private MyColumnCallParser(@NotNull RCallArguments arguments, @Nullable String tableName) {
            if (arguments == null) {
                MyColumnCallParser.$$$reportNull$$$0(1);
            }
            this(arguments, tableName, null);
        }

        private MyColumnCallParser(@NotNull RCallArguments arguments, @Nullable String tableName, @Nullable String dataType) {
            if (arguments == null) {
                MyColumnCallParser.$$$reportNull$$$0(2);
            }
            this.myArguments = arguments;
            this.myTableName = tableName;
            this.myDataType = dataType;
        }

        @NotNull
        public PsiElement getCall() {
            PsiElement psiElement = RailsSchemaCallable.getStubOrPsiElement(this.myArguments);
            if (psiElement == null) {
                MyColumnCallParser.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        @Nullable
        private String getDataType() {
            return this.myDataType != null ? this.myDataType : this.nextArgument();
        }

        @Nullable
        private String getTableName() {
            return this.myTableName != null ? this.myTableName : this.nextArgument();
        }

        @Nullable
        private String nextArgument() {
            return this.myArguments.evaluateArgument(this.myIndex++);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/RailsSchemaCallable$MyColumnCallParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/RailsSchemaCallable$MyColumnCallParser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private final class MyChangeTableCallable
    implements PsiCallable {
        private final String myTableName;

        private MyChangeTableCallable(String tableName) {
            if (tableName == null) {
                MyChangeTableCallable.$$$reportNull$$$0(0);
            }
            this.myTableName = tableName;
        }

        @Override
        public void processCall(@NotNull RCallArguments arguments) {
            String command;
            if (arguments == null) {
                MyChangeTableCallable.$$$reportNull$$$0(1);
            }
            switch (command = arguments.getCommand()) {
                case "change": {
                    RailsSchemaCallable.this.parseChangeColumnCall(new MyColumnCallParser(arguments, this.myTableName));
                    break;
                }
                case "remove": {
                    RailsSchemaCallable.this.parseRemoveColumnCall(new MyColumnCallParser(arguments, this.myTableName));
                    break;
                }
                case "rename": {
                    RailsSchemaCallable.this.parseRenameColumnCall(new MyColumnCallParser(arguments, this.myTableName));
                    break;
                }
                default: {
                    RailsSchemaCallable.this.processTableColumnCall(this.myTableName, command, arguments);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/RailsSchemaCallable$MyChangeTableCallable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processCall";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyCreateTableCallable
    implements PsiCallable {
        private final String myTableName;

        private MyCreateTableCallable(String tableName) {
            if (tableName == null) {
                MyCreateTableCallable.$$$reportNull$$$0(0);
            }
            this.myTableName = tableName;
        }

        @Override
        public void processCall(@NotNull RCallArguments arguments) {
            if (arguments == null) {
                MyCreateTableCallable.$$$reportNull$$$0(1);
            }
            RailsSchemaCallable.this.processTableColumnCall(this.myTableName, arguments.getCommand(), arguments);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/RailsSchemaCallable$MyCreateTableCallable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processCall";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

