/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.database;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.database.RailsSchemaCallable;
import org.jetbrains.plugins.ruby.rails.database.RailsSchemaParser;
import org.jetbrains.plugins.ruby.rails.database.RailsTableDefinition;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.ruby.RubyPsiManager;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public final class MigrationParser
implements Disposable {
    public static final String CREATE_TABLE = "create_table";
    private static final Logger LOG = Logger.getInstance(MigrationParser.class);
    private final Module myModule;
    private final List<VirtualFile> myMigrationsDirectories = new CopyOnWriteArrayList<VirtualFile>();
    private VirtualFile mySchemaFile;
    private boolean myInitialized;
    public static final Pattern MIGRATION_FILE_NAME_WITHOUT_EXT = Pattern.compile("\\d+_\\w+");
    private final Alarm myReparseAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    @Topic.ProjectLevel
    public static final Topic<MigrationListener> MIGRATIONS_CHANGED_TOPIC = new Topic(MigrationListener.class, Topic.BroadcastDirection.NONE);
    private Map<String, RailsTableDefinition> myTableToDefinitionAndFieldsMap;

    public static boolean matchesToMigrationFileNameTemplate(@NotNull VirtualFile file) {
        if (file == null) {
            MigrationParser.$$$reportNull$$$0(0);
        }
        return MIGRATION_FILE_NAME_WITHOUT_EXT.matcher(file.getNameWithoutExtension()).matches();
    }

    public static MigrationParser getInstance(Module module) {
        return (MigrationParser)module.getService(MigrationParser.class);
    }

    public MigrationParser(Module module) {
        this.myModule = module;
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MigrationParser.this.myMigrationsDirectories.isEmpty()) {
                    return null;
                }
                final List relevantEvents = ContainerUtil.filter(events, it -> it instanceof VFileCopyEvent || it instanceof VFileCreateEvent || it instanceof VFileMoveEvent);
                if (relevantEvents.isEmpty()) {
                    return null;
                }
                return new AsyncFileListener.ChangeApplier(){

                    public void afterVfsChange() {
                        VirtualFile file = null;
                        for (VFileEvent event : relevantEvents) {
                            if (event instanceof VFileCopyEvent) {
                                VFileCopyEvent copyEvent = (VFileCopyEvent)event;
                                file = copyEvent.findCreatedFile();
                            } else if (event instanceof VFileCreateEvent) {
                                VFileCreateEvent createEvent = (VFileCreateEvent)event;
                                file = createEvent.getFile();
                            } else if (event instanceof VFileMoveEvent) {
                                VFileMoveEvent moveEvent = (VFileMoveEvent)event;
                                file = moveEvent.getNewParent();
                            }
                            if (file == null || !VfsUtilCore.isUnderFiles((VirtualFile)file, MigrationParser.this.myMigrationsDirectories)) continue;
                            MigrationParser.this.rescheduleReparse();
                            break;
                        }
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/ruby/rails/database/MigrationParser$1", "prepareChange"));
            }
        }, (Disposable)this);
        this.parseAllMigrations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupForNextTest() {
        this.myInitialized = false;
        this.myMigrationsDirectories.clear();
        this.mySchemaFile = null;
        MigrationParser migrationParser = this;
        synchronized (migrationParser) {
            this.myTableToDefinitionAndFieldsMap = null;
        }
    }

    public void dispose() {
        this.myMigrationsDirectories.clear();
        this.mySchemaFile = null;
    }

    public void parseAllMigrations() {
        List<PsiDirectory> dbRoots = this.findDbRoots();
        if (dbRoots.isEmpty()) {
            return;
        }
        for (PsiDirectory root : dbRoots) {
            this.addChangeListener((PsiElement)root);
        }
        this.myInitialized = true;
        this.reparseMigrations();
    }

    private void addChangeListener(PsiElement psiElement) {
        RubyPsiManager.getInstance(this.myModule.getProject()).addChangeWatcher(psiElement, parentPsiElement -> {
            boolean rescheduleReparse = false;
            if (parentPsiElement instanceof PsiDirectory) {
                rescheduleReparse = true;
            } else {
                PsiFile psiFile = parentPsiElement.getContainingFile();
                String fileName = psiFile.getName();
                if (psiFile instanceof RFile && RubyVirtualFileScanner.isRubyFile(fileName)) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if ("schema.rb".equals(fileName) || "structure.sql".equals(fileName) || virtualFile != null && MigrationParser.matchesToMigrationFileNameTemplate(virtualFile)) {
                        rescheduleReparse = true;
                    }
                }
            }
            if (rescheduleReparse) {
                this.rescheduleReparse();
            }
        });
    }

    private void rescheduleReparse() {
        if (this.myReparseAlarm.isDisposed()) {
            return;
        }
        this.myReparseAlarm.cancelAllRequests();
        Runnable reparseOperation = () -> {
            this.reparseMigrations();
            ((MigrationListener)this.myModule.getProject().getMessageBus().syncPublisher(MIGRATIONS_CHANGED_TOPIC)).migrationsChanged(this.myModule);
        };
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myReparseAlarm.addRequest(reparseOperation, 500);
        } else {
            reparseOperation.run();
        }
    }

    private void reparseMigrations() {
        if (this.mySchemaFile == null || !this.mySchemaFile.isValid()) {
            this.mySchemaFile = this.findSchemaFile();
        }
        Project project = this.myModule.getProject();
        ReadAction.nonBlocking(() -> {
            String schemaVersion;
            if (this.myModule.isDisposed()) {
                return;
            }
            if (this.myMigrationsDirectories.isEmpty() || ContainerUtil.exists(this.myMigrationsDirectories, it -> !it.isValid())) {
                this.myMigrationsDirectories.clear();
                this.myMigrationsDirectories.addAll(this.findMigrationDirectories());
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiFile schemaFile = this.mySchemaFile != null ? psiManager.findFile(this.mySchemaFile) : null;
            List migrationsDirectories = ContainerUtil.mapNotNull(this.myMigrationsDirectories, arg_0 -> ((PsiManager)psiManager).findDirectory(arg_0));
            if (schemaFile != null) {
                if (!this.migrationFileIsReadyforParsing(schemaFile)) {
                    return;
                }
                schemaVersion = RailsSchemaParser.tryParseSchemaVersion(schemaFile);
            } else {
                schemaVersion = null;
            }
            ArrayList<RFile> migrations = new ArrayList<RFile>();
            if (!migrationsDirectories.isEmpty()) {
                for (PsiDirectory migrationsDirectory : migrationsDirectories) {
                    for (RFile file : ContainerUtil.filterIsInstance(List.of(migrationsDirectory.getChildren()), RFile.class)) {
                        String migrationVersion;
                        ProgressManager.checkCanceled();
                        VirtualFile vfile = file.getVirtualFile();
                        assert (vfile != null);
                        if (!MigrationParser.matchesToMigrationFileNameTemplate(vfile) || (migrationVersion = MigrationParser.getMigrationVersion(vfile)) == null || schemaFile != null && (schemaVersion == null || VersionComparatorUtil.compare((String)schemaVersion, (String)migrationVersion) >= 0)) continue;
                        if (this.migrationFileIsReadyforParsing((PsiFile)file)) {
                            migrations.add(file);
                            continue;
                        }
                        return;
                    }
                }
            }
            long timeStart = System.currentTimeMillis();
            MigrationParser migrationParser = this;
            synchronized (migrationParser) {
                this.myTableToDefinitionAndFieldsMap = new HashMap<String, RailsTableDefinition>();
                migrations.sort((o1, o2) -> VersionComparatorUtil.compare((String)o1.getName(), (String)o2.getName()));
                if (schemaFile != null) {
                    this.myTableToDefinitionAndFieldsMap.putAll(RailsSchemaParser.tryParseSchema(schemaFile));
                }
                for (RFile migration : migrations) {
                    ProgressManager.checkCanceled();
                    this.parseMigration(migration);
                }
            }
            long msec = System.currentTimeMillis() - timeStart;
            LOG.debug("Reparsed " + migrations.size() + " migration files" + (String)(schemaVersion != null ? " and schema.rb (vers." + schemaVersion + ")" : "") + " in " + msec + " ms");
        }).inSmartMode(project).executeSynchronously();
    }

    @Nullable
    public static String getMigrationVersion(VirtualFile migrationFile) {
        String migrationVersion;
        String fileName = migrationFile.getName();
        int pos = fileName.indexOf(95);
        if (pos > 0 && TextUtil.isInteger((String)(migrationVersion = fileName.substring(0, pos)))) {
            return migrationVersion;
        }
        return null;
    }

    private boolean migrationFileIsReadyforParsing(PsiFile file) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        Document document = psiDocumentManager.getCachedDocument(file);
        if (document != null && psiDocumentManager.isUncommited(document)) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    psiDocumentManager.commitDocument(document);
                    this.rescheduleReparse();
                });
            }
            return false;
        }
        return true;
    }

    private void parseMigration(RFile file) {
        List elementList = file.getStructureElements();
        for (RPsiStructureElement element : elementList) {
            if (!(element instanceof RClass)) continue;
            this.parseMigrationClass((RClass)element);
        }
    }

    private void parseMigrationClass(RClass rClass) {
        List elementList = rClass.getStructureElements();
        RMethod upMethod = null;
        RMethod changeMethod = null;
        for (RPsiStructureElement element : elementList) {
            if (!(element instanceof RMethod)) continue;
            RMethod method = (RMethod)element;
            if ("up".equals(method.getName())) {
                upMethod = method;
                continue;
            }
            if (!"change".equals(method.getName())) continue;
            changeMethod = method;
        }
        if (upMethod != null) {
            this.parseMigrationMethod(upMethod);
        } else if (changeMethod != null) {
            this.parseMigrationMethod(changeMethod);
        }
    }

    private void parseMigrationMethod(RMethod method) {
        RailsSchemaCallable callable = new RailsSchemaCallable(this.myTableToDefinitionAndFieldsMap);
        new RubyPsiInterpreter(true).interpret((PsiElement)method, callable);
        this.myTableToDefinitionAndFieldsMap = new HashMap<String, RailsTableDefinition>(callable.getTableDefinitions());
    }

    @Nullable
    public Collection<MigrationField> getFieldsByTableName(String tableName) {
        return MigrationParser.getFieldsFromMap(tableName, this.ensureTableMapLoaded());
    }

    @Nullable
    public PsiElement getTableDef(@NotNull String tableName) {
        if (tableName == null) {
            MigrationParser.$$$reportNull$$$0(1);
        }
        return MigrationParser.getTableDefFromMap(tableName, this.ensureTableMapLoaded());
    }

    @Nullable
    private static Collection<MigrationField> getFieldsFromMap(String tableName, Map<String, RailsTableDefinition> map) {
        if (map == null) {
            return null;
        }
        RailsTableDefinition tableDefinitionAndFields = map.get(tableName);
        if (tableDefinitionAndFields == null) {
            return null;
        }
        return new ArrayList<MigrationField>(tableDefinitionAndFields.getFields());
    }

    @Nullable
    private static PsiElement getTableDefFromMap(String tableName, Map<String, RailsTableDefinition> map) {
        if (map == null) {
            return null;
        }
        RailsTableDefinition tableDefinitionAndFields = map.get(tableName);
        return tableDefinitionAndFields != null ? tableDefinitionAndFields.getDeclaration() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, RailsTableDefinition> ensureTableMapLoaded() {
        boolean performUpdate;
        MigrationParser migrationParser = this;
        synchronized (migrationParser) {
            performUpdate = this.myTableToDefinitionAndFieldsMap == null;
        }
        if (performUpdate) {
            if (this.myInitialized) {
                this.reparseMigrations();
            } else {
                this.parseAllMigrations();
            }
        }
        migrationParser = this;
        synchronized (migrationParser) {
            return this.myTableToDefinitionAndFieldsMap;
        }
    }

    public Map<String, RailsTableDefinition> getTable2FieldsMap() {
        return this.ensureTableMapLoaded();
    }

    public String @NotNull [] getAllTables() {
        Map<String, RailsTableDefinition> fieldsMap = this.ensureTableMapLoaded();
        if (fieldsMap == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                MigrationParser.$$$reportNull$$$0(2);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        Set<String> tables = fieldsMap.keySet();
        String[] stringArray = ArrayUtilRt.toStringArray(tables);
        if (stringArray == null) {
            MigrationParser.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    public boolean containsTable(@Nullable String tableName) {
        if (tableName == null) {
            return false;
        }
        Map<String, RailsTableDefinition> fieldsMap = this.ensureTableMapLoaded();
        return fieldsMap != null && fieldsMap.containsKey(tableName);
    }

    public Map<String, MigrationField> getFieldMap(String tableName) {
        HashMap<String, MigrationField> result = new HashMap<String, MigrationField>();
        if (tableName != null) {
            List<MigrationField> list;
            RailsTableDefinition tableDefinitionAndFields = this.ensureTableMapLoaded().get(tableName);
            List<MigrationField> list2 = list = tableDefinitionAndFields != null ? tableDefinitionAndFields.getFields() : null;
            if (list != null) {
                for (MigrationField field : list) {
                    result.put(field.getName(), field);
                }
            }
        }
        return result;
    }

    @NotNull
    private List<VirtualFile> findMigrationDirectories() {
        List list = ContainerUtil.filter(RailsPaths.getInstance(this.myModule).findFiles("db/migrate"), VirtualFile::isDirectory);
        if (list == null) {
            MigrationParser.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private VirtualFile findSchemaFile() {
        StandardRailsPaths paths = RailsFacetUtil.getRailsAppStaticPaths(this.myModule);
        if (paths == null) {
            return null;
        }
        VirtualFile schemaFile = (VirtualFile)ContainerUtil.getFirstItem(RailsPaths.getInstance(this.myModule).findFiles("db", "schema.rb"));
        if (schemaFile != null) {
            return schemaFile;
        }
        VirtualFile structureFile = (VirtualFile)ContainerUtil.getFirstItem(RailsPaths.getInstance(this.myModule).findFiles("db", "structure.sql"));
        if (structureFile != null) {
            return structureFile;
        }
        return null;
    }

    @NotNull
    private List<PsiDirectory> findDbRoots() {
        PsiManager manager = PsiManager.getInstance((Project)this.myModule.getProject());
        List list = ContainerUtil.mapNotNull(RailsPaths.getInstance(this.myModule).findFiles("db"), arg_0 -> ((PsiManager)manager).findDirectory(arg_0));
        if (list == null) {
            MigrationParser.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/MigrationParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/MigrationParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findMigrationDirectories";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findDbRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchesToMigrationFileNameTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTableDef";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static interface MigrationListener {
        public void migrationsChanged(Module var1);
    }
}

