/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsModelFieldsProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.indexes.RailsAttributeMethodFqnIndex;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.MinitestGenerator;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RSpecTestGenerator;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsActiveRecordAttributeSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsClassModuleSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.TestUnitGenerator;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.ResolveAncestor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;

public class RailsModelSymbol
extends RailsClassModuleSymbol
implements RSpecTestGenerator,
TestUnitGenerator,
MinitestGenerator {
    public static final String MODEL_NAME = "model";
    private static final String RSPEC_MODEL = "rspec:model";
    private static final String TEST_UNIT_MODEL = "test_unit:model";
    private static final String MINITEST_MODEL = "model";
    public static final String ACTIVE_STORAGE_MODULE = "ActiveStorage::Attached::Macros";
    private static final String ACTION_TEXT_ATTRIBUTE = "ActionText::Attribute";
    public static final FQN ACTIVE_RECORD_BASE_FQN = FQN.of((String)"ActiveRecord::Base");

    public RailsModelSymbol(@NotNull RailsApp app, @NotNull RClass rClass) {
        if (app == null) {
            RailsModelSymbol.$$$reportNull$$$0(0);
        }
        if (rClass == null) {
            RailsModelSymbol.$$$reportNull$$$0(1);
        }
        super(app, (RContainer)rClass);
    }

    @Override
    protected boolean processNamedRoutes(Processor<Symbol> processor) {
        return true;
    }

    @NotNull
    public RClass getPsiElement() {
        RClass rClass = (RClass)Objects.requireNonNull(super.getPsiElement());
        if (rClass == null) {
            RailsModelSymbol.$$$reportNull$$$0(2);
        }
        return rClass;
    }

    @Override
    @NotNull
    public String getRSpecGeneratorName() {
        return RSPEC_MODEL;
    }

    @Override
    @NotNull
    public String getTestUnitGeneratorName() {
        return TEST_UNIT_MODEL;
    }

    @Override
    @Nullable
    public String getShortName(@NotNull PsiFile file) {
        RailsModel model;
        if (file == null) {
            RailsModelSymbol.$$$reportNull$$$0(3);
        }
        return (model = RailsModel.fromFile(file)) == null ? null : RubyClassResolveUtil.getQualifiedName(model.getRClass());
    }

    @Override
    @NotNull
    public String getMinitestGeneratorName() {
        return "model";
    }

    @Override
    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        if (!super.processChildren(processor, invocationPoint)) {
            return false;
        }
        return this.processAttributeSymbols(invocationPoint, (Processor<? super Symbol>)processor);
    }

    @Override
    @NotNull
    public Collection<Symbol> getImplicitIncludes() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        if (!this.myApp.isVendorGemFile(this.getPsiElement().getContainingFile())) {
            RailsModelSymbol.includeRailsModule(this.getProject(), result);
            this.includeActiveStorageModule(result);
            this.includeActionTextAttribute(result);
        }
        ArrayList<Symbol> arrayList = result;
        if (arrayList == null) {
            RailsModelSymbol.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<Symbol> getImplicitExtends() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        RailsModelSymbol.includeRailsModule(this.getProject(), result);
        this.includeActiveStorageModule(result);
        ArrayList<Symbol> arrayList = result;
        if (arrayList == null) {
            RailsModelSymbol.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public List<RPossibleCall> getAttributeMethods(@Nullable PsiElement invocationPoint) {
        GlobalSearchScope searchScope = this.getPsiElement().getResolveScope();
        List<ResolveAncestor> ancestors = SymbolHierarchy.getAncestorsCaching((Symbol)this, invocationPoint);
        Set ancestorFqns = ContainerUtil.map2Set(ancestors, it -> it.getSymbol().getFQNWithNesting());
        ArrayList<RPossibleCall> attributeMethodCalls = new ArrayList<RPossibleCall>();
        for (String key : RailsAttributeMethodFqnIndex.getInstance().getAllKeys(this.myProject)) {
            if (!ancestorFqns.contains(FQN.of((String)key))) continue;
            attributeMethodCalls.addAll(RailsAttributeMethodFqnIndex.getInstance().getElements(this.myProject, (SearchScope)searchScope, key));
        }
        ArrayList<RPossibleCall> arrayList = attributeMethodCalls;
        if (arrayList == null) {
            RailsModelSymbol.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private void includeActiveStorageModule(@NotNull ArrayList<Symbol> result) {
        Symbol activeStorageModule;
        if (result == null) {
            RailsModelSymbol.$$$reportNull$$$0(7);
        }
        if ((activeStorageModule = SymbolUtil.findConstantByFQN(this.getProject(), Type.MODULE, FQN.Builder.fromString((String)ACTIVE_STORAGE_MODULE), null)) != null) {
            result.add(activeStorageModule);
        }
    }

    private void includeActionTextAttribute(@NotNull List<Symbol> result) {
        Symbol actionTextAttribute;
        if (result == null) {
            RailsModelSymbol.$$$reportNull$$$0(8);
        }
        if ((actionTextAttribute = SymbolUtil.findConstantByFQN(this.getProject(), Type.MODULE, FQN.Builder.fromString((String)ACTION_TEXT_ATTRIBUTE), null)) != null) {
            result.add(actionTextAttribute);
        }
    }

    private boolean processAttributeSymbols(@Nullable PsiElement invocationPoint, @NotNull Processor<? super Symbol> processor) {
        if (processor == null) {
            RailsModelSymbol.$$$reportNull$$$0(9);
        }
        List<RPossibleCall> attributeMethods = this.getAttributeMethods(invocationPoint);
        Module module = this.getModule();
        if (module == null) {
            return true;
        }
        for (MigrationField migrationField : ActiveRecordModel.determineFieldsInternal(module, this.getPsiElement())) {
            for (Symbol symbol : RailsActiveRecordAttributeSymbol.createAttributeSymbolsOf(this.myProject, (Symbol)this, migrationField, attributeMethods)) {
                if (processor.process((Object)symbol)) continue;
                return false;
            }
        }
        for (RailsModelFieldsProvider railsModelFieldsProvider : RailsModelFieldsProvider.EP_NAME.getExtensionList()) {
            for (Symbol symbol : railsModelFieldsProvider.getFieldsSymbols((Symbol)this, invocationPoint)) {
                if (processor.process((Object)symbol)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static Symbol createModelSymbol(@Nullable RClass clazz) {
        if (clazz != null && ActiveRecordModel.isActiveRecordClass(clazz)) {
            return (Symbol)ObjectUtils.doIfNotNull((Object)RailsApp.fromPsiElement((PsiElement)clazz), app -> new RailsModelSymbol((RailsApp)app, clazz));
        }
        return null;
    }

    @Nullable
    public static Symbol createModelSymbol(@Nullable Symbol symbol) {
        if (symbol instanceof RailsModelSymbol) {
            return symbol;
        }
        if (symbol instanceof ClassModuleSymbol) {
            return RailsModelSymbol.createModelSymbol((RClass)ObjectUtils.tryCast((Object)symbol.getPsiElement(), RClass.class));
        }
        return null;
    }

    @NotNull
    public static List<? extends Symbol> getModels(@NotNull Project project, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RailsModelSymbol.$$$reportNull$$$0(10);
        }
        ArrayList models = new ArrayList();
        RailsModelSymbol.processModels(project, invocationPoint, (Processor<? super Symbol>)((Processor)models::add));
        List list = Collections.unmodifiableList(models);
        if (list == null) {
            RailsModelSymbol.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static void processModels(@NotNull Project project, @Nullable PsiElement invocationPoint, @NotNull Processor<? super Symbol> processor) {
        Symbol activeRecordBaseSymbol;
        if (project == null) {
            RailsModelSymbol.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            RailsModelSymbol.$$$reportNull$$$0(13);
        }
        if ((activeRecordBaseSymbol = SymbolUtil.findConstantByFQN(project, ACTIVE_RECORD_BASE_FQN, invocationPoint)) == null) {
            return;
        }
        for (Symbol symbol : RubyOverrideImplementUtil.getOverridingSymbols(activeRecordBaseSymbol)) {
            if (RailsModelSymbol.isAbstractClass(symbol) || processor.process((Object)symbol)) continue;
            return;
        }
    }

    private static boolean isAbstractClass(@NotNull Symbol symbol) {
        if (symbol == null) {
            RailsModelSymbol.$$$reportNull$$$0(14);
        }
        return FQN.same((FQN)symbol.getFQNWithNesting(), (String)"ApplicationRecord");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/RailsModelSymbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/RailsModelSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitIncludes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitExtends";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "includeActiveStorageModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "includeActionTextAttribute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAttributeSymbols";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModels";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processModels";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 11 -> new IllegalStateException(string);
        };
    }
}

