/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsRouteHelperSymbol;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.routes.RailsRoute;
import org.jetbrains.plugins.ruby.rails.routes.RoutesParser;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbolWithMixins;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public abstract class RailsClassModuleSymbol
extends ClassModuleSymbolWithMixins {
    protected final RailsApp myApp;

    public RailsClassModuleSymbol(RailsApp app, RContainer container) {
        super(container, null);
        this.myApp = app;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        return Objects.equals(this.myApp, ((RailsClassModuleSymbol)((Object)o)).myApp);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.myApp);
    }

    @Override
    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        if (!super.processChildren(processor, invocationPoint)) {
            return false;
        }
        return this.processNamedRoutes((Processor<Symbol>)processor);
    }

    protected boolean processNamedRoutes(Processor<Symbol> processor) {
        return RailsClassModuleSymbol.processNamedRoutes(processor, (Symbol)this, this.myApp);
    }

    public static boolean processNamedRoutes(@NotNull Processor<? super Symbol> processor, @Nullable Symbol classSymbol, @Nullable RailsApp app) {
        if (processor == null) {
            RailsClassModuleSymbol.$$$reportNull$$$0(0);
        }
        if (app != null && app.getRoutesFiles().isEmpty()) {
            return true;
        }
        assert (app != null);
        Project project = app.getProject();
        RoutesParser parser = RoutesParser.getInstance(app.getModule());
        HashMap<String, List> routesByPrefix = new HashMap<String, List>();
        for (List<RailsRoute> list : parser.getRoutes().values()) {
            for (RailsRoute route : list) {
                String prefix = route.getPrefix();
                if (prefix == null) continue;
                routesByPrefix.computeIfAbsent(prefix, __ -> new ArrayList()).add(route);
            }
        }
        for (Map.Entry entry : routesByPrefix.entrySet()) {
            ProgressManager.checkCanceled();
            String prefix = (String)entry.getKey();
            List<RailsRoute> routes = List.copyOf((Collection)entry.getValue());
            RailsRouteHelperSymbol pathSymbol = new RailsRouteHelperSymbol(project, routes, prefix + "_path", classSymbol);
            if (!processor.process((Object)pathSymbol)) {
                return false;
            }
            RailsRouteHelperSymbol urlSymbol = new RailsRouteHelperSymbol(project, routes, prefix + "_url", classSymbol);
            if (processor.process((Object)urlSymbol)) continue;
            return false;
        }
        return true;
    }

    protected static void includeRailsModule(Project project, Collection<? super Symbol> result) {
        result.add((Symbol)SymbolUtil.findConstantByFQN(project, Type.MODULE, "Rails", null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/ruby/rails/codeInsight/symbols/v2/RailsClassModuleSymbol", "processNamedRoutes"));
    }
}

