/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.AssetsGroup;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.LoadPathDescriptor;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.LoadPathDescriptorImpl;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.SprocketAssetsPathProvider;

public final class GemsAssetsPathProvider
implements SprocketAssetsPathProvider {
    @Override
    @NotNull
    public List<? extends LoadPathDescriptor> getLoadPath(@NotNull Module module, @Nullable AssetsGroup type) {
        if (module == null) {
            GemsAssetsPathProvider.$$$reportNull$$$0(0);
        }
        if (type == null) {
            List list = Collections.emptyList();
            if (list == null) {
                GemsAssetsPathProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<LoadPathDescriptor> result = new ArrayList<LoadPathDescriptor>();
        for (GemInfo gem : RubyProjectGemSearchService.Companion.getAllGems(module)) {
            VirtualFile file = gem.getFile();
            if (file == null) continue;
            for (String subdirName : type.getDirectoryNames()) {
                VirtualFile vendorAssets;
                VirtualFile assetsInRoot;
                VirtualFile gemLibFolder;
                VirtualFile libAssets;
                VirtualFile appAssets = file.findFileByRelativePath("app/assets/" + subdirName);
                if (appAssets != null) {
                    result.add(GemsAssetsPathProvider.createLoadPathDescriptor(appAssets, type, gem));
                }
                VirtualFile virtualFile = libAssets = (gemLibFolder = gem.getLibFolder()) != null ? gemLibFolder.findFileByRelativePath("assets/" + subdirName) : null;
                if (libAssets != null) {
                    result.add(GemsAssetsPathProvider.createLoadPathDescriptor(libAssets, type, gem));
                }
                if ((assetsInRoot = file.findFileByRelativePath("assets/" + subdirName)) != null) {
                    result.add(GemsAssetsPathProvider.createLoadPathDescriptor(assetsInRoot, type, gem));
                }
                if ((vendorAssets = file.findFileByRelativePath("vendor/assets/" + subdirName)) == null) continue;
                result.add(GemsAssetsPathProvider.createLoadPathDescriptor(vendorAssets, type, gem));
            }
        }
        List<LoadPathDescriptor> list = !result.isEmpty() ? result : Collections.emptyList();
        if (list == null) {
            GemsAssetsPathProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static LoadPathDescriptor createLoadPathDescriptor(VirtualFile assetsDirectory, AssetsGroup type, GemInfo gem) {
        String presentableName = GemsAssetsPathProvider.getPresentableName(gem);
        return new LoadPathDescriptorImpl(assetsDirectory, type, presentableName, true);
    }

    private static String getPresentableName(@NotNull GemInfo gem) {
        if (gem == null) {
            GemsAssetsPathProvider.$$$reportNull$$$0(3);
        }
        return "[" + gem.getName() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/GemsAssetsPathProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/GemsAssetsPathProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoadPath";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

