/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets;

import com.google.common.base.Splitter;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsComment;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsConstants;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;

public final class SprocketsUtil {
    private static final Set<String> ourSupportedFileTypes = Set.of("css", "sass", "scss", "less", "js", "coffee");

    private SprocketsUtil() {
    }

    public static boolean areAssetsEnabled(@NotNull RailsApp app) {
        if (app == null) {
            SprocketsUtil.$$$reportNull$$$0(0);
        }
        return SprocketsUtil.railsWithAssetsSupport(app.getModule());
    }

    @Nullable
    public static String getAssetType(@Nullable String directive, @NotNull PsiElement element) {
        if (element == null) {
            SprocketsUtil.$$$reportNull$$$0(1);
        }
        if ("depend_on".equals(directive) || "depend_on_asset".equals(directive)) {
            return "javascripts";
        }
        if (SprocketsUtil.isStylesheet(element)) {
            return "stylesheets";
        }
        if (SprocketsUtil.isJavascript(element)) {
            return "javascripts";
        }
        return null;
    }

    public static boolean isStylesheet(@NotNull PsiElement element) {
        Language language;
        String name;
        if (element == null) {
            SprocketsUtil.$$$reportNull$$$0(2);
        }
        return (name = (language = element.getLanguage()).getDisplayName()).equalsIgnoreCase("css") || name.equalsIgnoreCase("scss") || name.equalsIgnoreCase("sass") || name.equalsIgnoreCase("less");
    }

    public static boolean isJavascript(@NotNull PsiElement element) {
        Language language;
        String name;
        if (element == null) {
            SprocketsUtil.$$$reportNull$$$0(3);
        }
        return (name = (language = element.getLanguage()).getDisplayName()).equalsIgnoreCase("javascript") || name.equalsIgnoreCase("coffeescript");
    }

    public static boolean railsWithAssetsSupport(@Nullable Module module) {
        return module != null && RailsUtil.isRailsGemAttached(module);
    }

    public static boolean isStdAssetsRoot(@Nullable Set<VirtualFile> assetsRoots, @NotNull VirtualFile parentFileOrDir, @NotNull VirtualFile childFileOrDir) {
        if (parentFileOrDir == null) {
            SprocketsUtil.$$$reportNull$$$0(4);
        }
        if (childFileOrDir == null) {
            SprocketsUtil.$$$reportNull$$$0(5);
        }
        return assetsRoots != null && (childFileOrDir.isDirectory() && "assets".equals(childFileOrDir.getName()) && Comparing.equal((Object)parentFileOrDir, (Object)childFileOrDir.getParent()) || assetsRoots.contains(childFileOrDir));
    }

    public static boolean isSprocketsSupportedFile(@NotNull PsiFile file) {
        if (file == null) {
            SprocketsUtil.$$$reportNull$$$0(6);
        }
        List<String> viewExtensions = ViewsConventions.getViewExtensions(file.getName());
        for (String ext : viewExtensions) {
            if (!ourSupportedFileTypes.contains(ext)) continue;
            return true;
        }
        return false;
    }

    public static void processSprocketComments(@NotNull PsiComment comment, @NotNull Processor<? super SprocketsComment> processor) {
        if (comment == null) {
            SprocketsUtil.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            SprocketsUtil.$$$reportNull$$$0(8);
        }
        int offset = 0;
        for (String line : Splitter.on((char)'\n').split((CharSequence)comment.getText())) {
            Matcher matcher;
            if (!line.isEmpty() && (matcher = SprocketsConstants.SPROCKET_COMMENT.matcher(line)).matches()) {
                processor.process((Object)SprocketsComment.fromMatcher(comment, offset, matcher));
            }
            offset += line.length() + 1;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFileOrDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childFileOrDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areAssetsEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssetType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isStylesheet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavascript";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isStdAssetsRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSprocketsSupportedFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processSprocketComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

