/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.AssetsGroup;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketAssetsLoadPathManager;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsComment;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsConstants;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsDirectiveContextProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsReference;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsReferenceProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths.LoadPathDescriptor;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;

public class SprocketsReferenceSet
extends FileReferenceSet {
    @NotNull
    private static final Condition<PsiElement> BOWER_PACKAGE_ACCEPTOR = candidate -> !(candidate instanceof PsiDirectory) || ((PsiDirectory)candidate).findFile("bower.json") != null;
    @NotNull
    private final PsiFile myRefContainingFile;
    @NotNull
    private final AssetsGroup myAssetGroup;
    private final boolean myIsAcceptsDirectories;
    private final boolean myMultiResolveAllowed;
    private final boolean myIsExtendedAssetsRoots;
    @NotNull
    private final Condition<? super PsiElement> myCandidateAcceptor;
    @NotNull
    private final Condition<PsiFileSystemItem> COMPLETION_FILTER;

    public SprocketsReferenceSet(@NotNull PsiElement element, @NotNull String text, int startInElement, @NotNull AssetsGroup assetsGroup, boolean isAcceptsDirectories, @NotNull Condition<? super PsiElement> candidateAcceptor, boolean isExtendedAssetsRoots, boolean allowMultiResolve, @Nullable SprocketsReferenceProvider provider) {
        if (element == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(0);
        }
        if (text == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(1);
        }
        if (assetsGroup == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(2);
        }
        if (candidateAcceptor == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(3);
        }
        super(text, element, startInElement, (PsiReferenceProvider)provider, true);
        this.COMPLETION_FILTER = new Condition<PsiFileSystemItem>(){

            public boolean value(PsiFileSystemItem item) {
                if (item instanceof PsiDirectory && (SprocketsConstants.isMatchesAssetsGroup(item.getName()) || SprocketsConstants.isInAssetsGroup(item))) {
                    return false;
                }
                if (SprocketsReferenceSet.this.myIsAcceptsDirectories && item instanceof PsiFile) {
                    return false;
                }
                if (item instanceof PsiDirectory) {
                    return true;
                }
                if (SprocketsReferenceSet.this.myRefContainingFile == item) {
                    return false;
                }
                for (String extension : ViewsConventions.getViewExtensions(item.getName())) {
                    if (!SprocketsReferenceSet.this.myAssetGroup.isExtensionSupported(extension)) continue;
                    return true;
                }
                return false;
            }
        };
        this.myIsAcceptsDirectories = isAcceptsDirectories;
        this.myCandidateAcceptor = candidateAcceptor;
        this.myMultiResolveAllowed = allowMultiResolve;
        this.myIsExtendedAssetsRoots = isExtendedAssetsRoots;
        this.myAssetGroup = assetsGroup;
        this.myRefContainingFile = element.getContainingFile().getOriginalFile();
    }

    @Nullable
    public static SprocketsReferenceSet fromComment(@NotNull SprocketsComment comment, @Nullable SprocketsReferenceProvider provider) {
        if (comment == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(4);
        }
        String directive = comment.getDirective();
        PsiComment element = comment.getElement();
        AssetsGroup group = SprocketsReferenceSet.assetGroup((PsiElement)element, StringUtil.notNullize((String)directive));
        if (group == null) {
            return null;
        }
        return new SprocketsReferenceSet((PsiElement)element, comment.getArguments(), comment.getArgumentsRange().getStartOffset(), group, SprocketsConstants.acceptsDirectories(directive), (Condition<? super PsiElement>)("require".equalsIgnoreCase(directive) ? BOWER_PACKAGE_ACCEPTOR : Conditions.alwaysFalse()), true, false, provider);
    }

    static FileReference getLastReference(String referenceFullPath, SprocketsReferenceSet referenceSet) {
        return new SprocketsReferenceSet(referenceSet.getElement(), referenceFullPath, referenceSet.getStartInElement(), referenceSet.getAssetGroup(), referenceSet.isAcceptsDirectories(), referenceSet.myCandidateAcceptor, referenceSet.myIsExtendedAssetsRoots, true, null).getLastReference();
    }

    @NotNull
    public PsiFile getRefContainingFile() {
        PsiFile psiFile = this.myRefContainingFile;
        if (psiFile == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @NotNull
    public AssetsGroup getAssetGroup() {
        AssetsGroup assetsGroup = this.myAssetGroup;
        if (assetsGroup == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(6);
        }
        return assetsGroup;
    }

    @NotNull
    public FileReference createFileReference(@NotNull TextRange range, int index, @NotNull String text) {
        if (range == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(7);
        }
        if (text == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(8);
        }
        return new SprocketsReference(this, range, index, text);
    }

    @NotNull
    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        Condition condition = Conditions.and(this.COMPLETION_FILTER, SprocketsReferenceSet.getDirectiveFilter(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myRefContainingFile)));
        if (condition == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(9);
        }
        return condition;
    }

    private boolean isRelative() {
        String path = this.getPathString();
        return ".".equals(path) || path.startsWith("../") || path.startsWith("./");
    }

    public boolean absoluteUrlNeedsStartSlash() {
        return false;
    }

    @NotNull
    public String getRelativePathForFile(@NotNull PsiFileSystemItem fileSystemItem) {
        if (fileSystemItem == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(10);
        }
        String result = "";
        VirtualFile virtualFile = fileSystemItem.getVirtualFile();
        if (virtualFile != null) {
            for (PsiFileSystemItem item : this.getDefaultContexts()) {
                String relativePath;
                VirtualFile context = item.getVirtualFile();
                if (context == null || (relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)context, (char)'/')) == null) continue;
                String string = relativePath;
                if (string == null) {
                    SprocketsReferenceSet.$$$reportNull$$$0(11);
                }
                return string;
            }
        }
        String string = result;
        if (string == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        SprocketAssetsLoadPathManager manager;
        RailsApp railsApp;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myRefContainingFile);
        ArrayList<PsiFileSystemItem> contexts = new ArrayList<PsiFileSystemItem>();
        if (this.myIsExtendedAssetsRoots && module != null) {
            contexts.addAll(SprocketAssetsLoadPathManager.getInstance(module).getExtendedAssetsRoots());
        }
        if (module != null) {
            contexts.addAll(SprocketsReferenceSet.getDirectiveContexts(module));
        }
        contexts.addAll(super.getDefaultContexts());
        if (this.isRelative()) {
            PsiFile file = this.getRefContainingFile();
            PsiDirectory parentDirectory = file.getContainingDirectory();
            if (parentDirectory != null) {
                List list = ContainerUtil.filter(contexts, arg_0 -> SprocketsReferenceSet.lambda$getDefaultContexts$1((PsiFileSystemItem)parentDirectory, arg_0));
                if (list == null) {
                    SprocketsReferenceSet.$$$reportNull$$$0(13);
                }
                return list;
            }
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                SprocketsReferenceSet.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (module != null && (railsApp = RailsApp.fromModule(module)) != null && (manager = SprocketAssetsLoadPathManager.getInstance(railsApp)) != null) {
            List list = ContainerUtil.filter(contexts, item -> {
                LoadPathDescriptor descriptor;
                VirtualFile virtualFile = item.getVirtualFile();
                if (virtualFile != null && (descriptor = manager.getDescriptor(virtualFile)) != null) {
                    String type = descriptor.getType();
                    return type == null || type.equals(this.myAssetGroup.getName()) || type.equals("images");
                }
                return true;
            });
            if (list == null) {
                SprocketsReferenceSet.$$$reportNull$$$0(15);
            }
            return list;
        }
        ArrayList<PsiFileSystemItem> arrayList = contexts;
        if (arrayList == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static Collection<PsiFileSystemItem> getDirectiveContexts(@NotNull Module module) {
        if (module == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(17);
        }
        ArrayList<PsiFileSystemItem> contexts = new ArrayList<PsiFileSystemItem>();
        for (SprocketsDirectiveContextProvider contextProvider : (SprocketsDirectiveContextProvider[])SprocketsDirectiveContextProvider.EP_NAME.getExtensions()) {
            contexts.addAll(contextProvider.getExtraContexts(module));
        }
        return contexts;
    }

    private static Condition<PsiFileSystemItem> getDirectiveFilter(@Nullable Module module) {
        if (module == null) {
            return Conditions.alwaysFalse();
        }
        Condition filter = Conditions.alwaysTrue();
        for (SprocketsDirectiveContextProvider contextProvider : (SprocketsDirectiveContextProvider[])SprocketsDirectiveContextProvider.EP_NAME.getExtensions()) {
            filter = Conditions.and((Condition)filter, contextProvider.getCompletionFilter(module));
        }
        return filter;
    }

    public boolean isEndingSlashNotAllowed() {
        return this.myIsAcceptsDirectories;
    }

    public boolean isAcceptsDirectories() {
        return this.myIsAcceptsDirectories;
    }

    public boolean isMultiResolveAllowed() {
        return this.myMultiResolveAllowed;
    }

    @Nullable
    private static AssetsGroup assetGroup(@NotNull PsiElement element, @NotNull String sprocketDirective) {
        String assetType;
        if (element == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(18);
        }
        if (sprocketDirective == null) {
            SprocketsReferenceSet.$$$reportNull$$$0(19);
        }
        return (assetType = SprocketsUtil.getAssetType(sprocketDirective, element)) != null ? AssetsGroup.fromString(assetType) : null;
    }

    public boolean isAcceptCandidate(@Nullable PsiElement candidate) {
        return this.myCandidateAcceptor.value((Object)candidate);
    }

    private static /* synthetic */ boolean lambda$getDefaultContexts$1(PsiFileSystemItem parentDirectory, PsiFileSystemItem item) {
        return PsiFileSystemItemUtil.getRelativePathFromAncestor((PsiFileSystemItem)item, (PsiFileSystemItem)parentDirectory) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9, 11, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assetsGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateAcceptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketsReferenceSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystemItem";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sprocketDirective";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketsReferenceSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefContainingFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssetGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceCompletionFilter";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePathForFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromComment";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFileReference";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathForFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDirectiveContexts";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "assetGroup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9, 11, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

