/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsComment;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;

public final class SprocketsHighlightingAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SprocketsHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SprocketsHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiComment && SprocketsUtil.isSprocketsSupportedFile(element.getContainingFile())) {
            int commentStartOffset = element.getTextRange().getStartOffset();
            SprocketsUtil.processSprocketComments((PsiComment)element, (Processor<? super SprocketsComment>)((Processor)sprocketsComment -> {
                TextRange argumentsRange;
                TextRange directiveRange = sprocketsComment.getDirectiveRange();
                if (!directiveRange.isEmpty()) {
                    holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(directiveRange.shiftRight(commentStartOffset)).textAttributes(RubyHighlighter.METHOD_NAME).create();
                }
                if (!(argumentsRange = sprocketsComment.getArgumentsRange()).isEmpty()) {
                    holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(argumentsRange.shiftRight(commentStartOffset)).textAttributes(RubyHighlighter.SIMPLE_STRING).create();
                }
                return true;
            }));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketsHighlightingAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

