/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.ObjectUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;

public final class SprocketsConstants {
    public static final String REQUIRE = "require";
    public static final String INCLUDE = "include";
    public static final String REQUIRE_DIRECTORY = "require_directory";
    public static final String REQUIRE_SELF = "require_self";
    public static final String REQUIRE_TREE = "require_tree";
    public static final String DEPEND_ON = "depend_on";
    public static final String DEPEND_ON_ASSET = "depend_on_asset";
    public static final String COMPAT = "compat";
    public static final String STUB = "stub";
    public static final String[] KEYWORDS = new String[]{"stub", "compat", "depend_on", "depend_on_asset", "include", "require", "require_directory", "require_self", "require_tree"};
    public static final Pattern SPROCKET_COMMENT = Pattern.compile("^(\\s*\\*|//|#)\\s*=\\s*((\\w+)(\\s*))(<?\\S*>?)\\s*$");
    public static final int KEYWORD_AND_WHITESPACES_GROUP = 2;
    public static final int KEYWORD_GROUP = 3;
    public static final int WHITESPACES_GROUP = 4;
    public static final int ARG_GROUP = 5;
    public static final String JAVASCRIPTS = "javascripts";
    public static final String STYLESHEETS = "stylesheets";
    public static final String IMAGES = "images";

    static boolean acceptsDirectories(String directive) {
        return !INCLUDE.equals(directive) && !REQUIRE.equals(directive) && !DEPEND_ON.equals(directive) && !STUB.equals(directive) && !DEPEND_ON_ASSET.equals(directive);
    }

    private SprocketsConstants() {
    }

    public static boolean isMatchesAssetsGroup(String name) {
        return STYLESHEETS.equals(name) || JAVASCRIPTS.equals(name) || IMAGES.equals(name);
    }

    public static boolean isInAssetsGroup(@NotNull PsiFileSystemItem item) {
        if (item == null) {
            SprocketsConstants.$$$reportNull$$$0(0);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)item);
        VirtualFile file = (VirtualFile)ObjectUtils.doIfNotNull((Object)item.getParent(), PsiFileSystemItem::getVirtualFile);
        if (module == null || file == null) {
            return false;
        }
        RailsPaths paths = RailsPaths.getInstance(module);
        return paths.findFiles("app/assets").contains(file) || paths.findFiles("lib/assets").contains(file) || paths.findFiles("vendor/assets").contains(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketsConstants", "isInAssetsGroup"));
    }
}

