/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ProcessingContext;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsConstants;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

public final class SprocketsCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final FilterPattern SPROCKETS_COMPLETION_PATTERN = new FilterPattern((ElementFilter)new SprocketsCompletionFilter());

    public SprocketsCompletionContributor() {
        this.addSprocketsKeywordsCompletion();
    }

    private static boolean isSprocketComment(PsiElement context) {
        String[] lines;
        String text = context.getText();
        for (String line : lines = text.split("\n")) {
            if (!SprocketsConstants.SPROCKET_COMMENT.matcher(line).matches()) continue;
            return true;
        }
        return false;
    }

    private void addSprocketsKeywordsCompletion() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().and((ElementPattern)SPROCKETS_COMPLETION_PATTERN), SprocketDirectiveCompletionProvider.INSTANCE);
    }

    private static class SprocketDirectiveCompletionProvider
    extends RubyTrackedCompletionProvider {
        private static final SprocketDirectiveCompletionProvider INSTANCE = new SprocketDirectiveCompletionProvider();

        private SprocketDirectiveCompletionProvider() {
            super((Language)RubyLanguage.INSTANCE);
        }

        @Override
        protected void addCompletionsTracked(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                SprocketDirectiveCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                SprocketDirectiveCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                SprocketDirectiveCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement element = parameters.getPosition();
            String text = element.getText();
            String[] lines = text.split("\n");
            int offset = parameters.getOffset() - element.getTextOffset();
            int i = 0;
            int lineOffset = 0;
            while (lineOffset + lines[i].length() + 1 < offset) {
                lineOffset += lines[i++].length() + 1;
            }
            String line = lines[i];
            assert (line != null);
            int offsetInLine = offset - lineOffset;
            Matcher matcher = SprocketsConstants.SPROCKET_COMMENT.matcher(line);
            if (!matcher.matches()) {
                return;
            }
            int whitespacesAndKeyword = matcher.start(2);
            int whitespacesAfterKeyword = matcher.start(4);
            if (offsetInLine <= whitespacesAfterKeyword || whitespacesAfterKeyword == whitespacesAndKeyword) {
                for (String keyword : SprocketsConstants.KEYWORDS) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)keyword));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketsCompletionContributor$SprocketDirectiveCompletionProvider";
            objectArray[2] = "addCompletionsTracked";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SprocketsCompletionFilter
    implements ElementFilter {
        private SprocketsCompletionFilter() {
        }

        public boolean isAcceptable(Object element, PsiElement context) {
            return SprocketsCompletionContributor.isSprocketComment(context);
        }

        public boolean isClassAcceptable(Class hintClass) {
            return PsiComment.class.isAssignableFrom(hintClass);
        }
    }
}

