/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.DynamicHashKeyProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class ValidatesKeysProvider
implements DynamicHashKeyProvider {
    private static final String VALIDATOR = "Validator";
    private static final String VALIDATES = "validates";

    @Override
    @NotNull
    public List<String> getKeys(RubyCallArgumentContext context) {
        return new ArrayList<String>(ValidatesKeysProvider.collectValidators(context).keySet());
    }

    private static Map<String, RClass> collectValidators(RubyCallArgumentContext context) {
        RCall call = context.getCall();
        if (!VALIDATES.equals(call.getCommand())) {
            return Collections.emptyMap();
        }
        Module module = context.getModule();
        if (module == null) {
            return Collections.emptyMap();
        }
        Project project = context.getProject();
        HashMap<String, RClass> validators = new HashMap<String, RClass>();
        for (VirtualFile lib : RailsPaths.getInstance(module).findFiles("lib")) {
            validators.putAll(ValidatesKeysProvider.collectValidators(project, lib));
        }
        return validators;
    }

    private static Map<String, RClass> collectValidators(Project project, VirtualFile lib) {
        HashMap<String, RClass> result = new HashMap<String, RClass>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PsiManager manager = PsiManager.getInstance((Project)project);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)lib, (Project)project);
        ContentIterator iterator = fileOrDir -> {
            if (fileOrDir.isDirectory()) {
                return true;
            }
            PsiFile psi = manager.findFile(fileOrDir);
            if (psi instanceof RFile) {
                for (RClass clazz : RContainerUtil.getTopLevelClasses((RContainer)psi)) {
                    String name = clazz.getName();
                    if (name == null || !name.endsWith(VALIDATOR)) continue;
                    int i = name.indexOf(VALIDATOR);
                    result.put(NamingConventions.toUnderscoreCase((String)name.substring(0, i), (Module)module), clazz);
                }
            }
            return true;
        };
        fileIndex.iterateContentUnderDirectory(lib, iterator);
        return result;
    }

    @Override
    public boolean hasKey(RubyCallArgumentContext context, String text) {
        return this.getKeys(context).contains(text);
    }

    @Override
    public PsiElement resolveKey(RubyCallArgumentContext context, String text) {
        return (PsiElement)ValidatesKeysProvider.collectValidators(context).get(text);
    }
}

