/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.database.MigrationParser;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;

public class TableNameRefParam
extends ParamDefBase {
    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        Module module;
        if (context == null) {
            TableNameRefParam.$$$reportNull$$$0(0);
        }
        if (elementsConsumer == null) {
            TableNameRefParam.$$$reportNull$$$0(1);
        }
        if (lookupStringFilter == null) {
            TableNameRefParam.$$$reportNull$$$0(2);
        }
        if ((module = context.getModule()) == null) {
            return;
        }
        for (String tableName : MigrationParser.getInstance(module).getAllTables()) {
            if (!lookupStringFilter.test(tableName)) continue;
            elementsConsumer.consume((Object)TableNameRefParam.createLookupItem(context, tableName, LookupItemType.Symbol, AllIcons.Nodes.DataSchema));
        }
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        Module module;
        if (context == null) {
            TableNameRefParam.$$$reportNull$$$0(3);
        }
        if ((module = context.getModule()) == null) {
            return null;
        }
        String name = TableNameRefParam.elementText(context);
        return MigrationParser.getInstance(module).getTableDef(name);
    }

    @Override
    public InspectionResult warningInspection(RubyCallArgumentContext context, RPsiElement element) {
        Module module = context.getModule();
        Object tableExampleName = null;
        if (module != null) {
            Object[] tables = MigrationParser.getInstance(module).getAllTables();
            Arrays.sort(tables);
            tableExampleName = tables.length == 0 ? null : tables[0];
        }
        String egText = tableExampleName == null ? "" : RBundle.message((String)"inspection.paramdef.warning.eg.singular", (Object[])new Object[]{tableExampleName});
        String message = RBundle.message((String)"inspection.paramdef.table_name.warning", (Object[])new Object[]{ParamDef.getTextPresentationForPsiElement(element), egText});
        return InspectionResult.createWarningResult((PsiElement)element, message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/TableNameRefParam";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

