/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.StatusCodeRefParamService;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.RangeInDocumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RIntegerConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class StatusCodeRefParam
extends ParamDefBase {
    private static final Pattern myStringLiteralPattern = Pattern.compile("^\\s*(\\d\\d\\d).*$", 8);

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        if (context == null) {
            StatusCodeRefParam.$$$reportNull$$$0(0);
        }
        if (elementsConsumer == null) {
            StatusCodeRefParam.$$$reportNull$$$0(1);
        }
        if (lookupStringFilter == null) {
            StatusCodeRefParam.$$$reportNull$$$0(2);
        }
        List<StatusCodeRefParamService.StatusDescriptor> descriptors = StatusCodeRefParamService.getInstance(context.getProject()).getAllDescriptors(context.getModule());
        RPsiElement element = context.getArgumentElement();
        boolean isInSymbol = element instanceof RSymbol;
        boolean isInString = element instanceof RStringLiteral;
        for (StatusCodeRefParamService.StatusDescriptor descriptor : descriptors) {
            String code = descriptor.getCode();
            if (!lookupStringFilter.test(code)) continue;
            Icon icon = AllIcons.Nodes.Constant;
            String type = descriptor.getStatus() + " (" + code + ")";
            if (!isInSymbol) {
                if (!isInString) {
                    elementsConsumer.consume((Object)StatusCodeRefParam.createTypedLookupItem(context, code, type, LookupItemType.None, icon));
                } else {
                    elementsConsumer.consume((Object)StatusCodeRefParam.createTypedLookupItem(context, code + " " + descriptor.getStatus(), type, LookupItemType.String, icon));
                }
            }
            String symbol = StatusCodeRefParam.statusToSymbol(descriptor.getStatus());
            if (isInString) continue;
            elementsConsumer.consume((Object)StatusCodeRefParam.createTypedLookupItem(context, symbol, type, LookupItemType.Symbol, icon));
        }
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        Module module;
        if (context == null) {
            StatusCodeRefParam.$$$reportNull$$$0(3);
        }
        if ((module = context.getModule()) == null || module.isDisposed()) {
            return null;
        }
        Project project = module.getProject();
        StatusCodeRefParamService.StatusFileDescriptor fileDescriptor = StatusCodeRefParamService.getInstance(project).getStatusFileDescriptor(module);
        if (fileDescriptor == null) {
            return null;
        }
        RPsiElement element = context.getArgumentElement();
        if (element instanceof RIntegerConstant) {
            String statusCode = element.getText();
            return StatusCodeRefParam.createFakeElement(project, fileDescriptor, fileDescriptor.getDescriptorByCode(statusCode));
        }
        if (element instanceof RStringLiteral) {
            String text = TextUtil.removeQuoting((String)element.getText());
            Matcher m = myStringLiteralPattern.matcher(text);
            if (m.find()) {
                String statusCode = m.group(1);
                return StatusCodeRefParam.createFakeElement(project, fileDescriptor, fileDescriptor.getDescriptorByCode(statusCode));
            }
        } else if (element instanceof RSymbol) {
            String text = ((RSymbol)element).getContent().getText();
            return StatusCodeRefParam.createFakeElement(project, fileDescriptor, fileDescriptor.getDescriptorByStatus(text));
        }
        return null;
    }

    @Nullable
    private static PsiElement createFakeElement(@NotNull Project project, @NotNull StatusCodeRefParamService.StatusFileDescriptor descriptor, @Nullable StatusCodeRefParamService.StatusDescriptor statusDescriptor) {
        if (project == null) {
            StatusCodeRefParam.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            StatusCodeRefParam.$$$reportNull$$$0(5);
        }
        VirtualFile virtualFile = descriptor.getVirtualFile();
        if (statusDescriptor == null || !virtualFile.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        return psiFile == null ? null : new RangeInDocumentFakePsiElement((PsiElement)psiFile, statusDescriptor.getRange());
    }

    public static String statusToSymbol(String status) {
        return NamingConventions.toUnderscoreCase((String)status.replace(" ", ""));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/StatusCodeRefParam";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createFakeElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

