/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import icons.RubyIcons;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.sinatra.SinatraTemplateType;
import org.jetbrains.plugins.ruby.sinatra.SinatraUtil;

public class SinatraViewRefParam
extends ParamDefBase {
    private final SinatraTemplateType myTemplateType;

    public SinatraViewRefParam(SinatraTemplateType templateType) {
        this.myTemplateType = templateType;
    }

    @Override
    public String handleRename(@NotNull RubyCallArgumentContext context, @NotNull String newName) {
        Pattern pattern;
        Matcher matcher;
        if (context == null) {
            SinatraViewRefParam.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            SinatraViewRefParam.$$$reportNull$$$0(1);
        }
        if ((matcher = (pattern = Pattern.compile("(\\w+)(\\.)?(\\w*)")).matcher(newName)).matches()) {
            return matcher.group(1);
        }
        return super.handleRename(context, newName);
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        Module module;
        if (context == null) {
            SinatraViewRefParam.$$$reportNull$$$0(2);
        }
        if (elementsConsumer == null) {
            SinatraViewRefParam.$$$reportNull$$$0(3);
        }
        if (lookupStringFilter == null) {
            SinatraViewRefParam.$$$reportNull$$$0(4);
        }
        if ((module = context.getModule()) == null) {
            return;
        }
        VirtualFile viewsFolder = SinatraUtil.getViewsFolder(module);
        PsiFile file = context.getRFile();
        if (viewsFolder != null) {
            this.processAllViewsVariants(viewsFolder, context, elementsConsumer, lookupStringFilter);
        }
        SinatraViewRefParam.processAllNamedTemplatesVariants(file, context, elementsConsumer, lookupStringFilter);
    }

    private void processAllViewsVariants(@NotNull VirtualFile viewsRoot, final RubyCallArgumentContext context, final @NotNull Consumer<? super LookupElement> elementConsumer, final @NotNull Predicate<String> lookupStringFilter) {
        if (viewsRoot == null) {
            SinatraViewRefParam.$$$reportNull$$$0(5);
        }
        if (elementConsumer == null) {
            SinatraViewRefParam.$$$reportNull$$$0(6);
        }
        if (lookupStringFilter == null) {
            SinatraViewRefParam.$$$reportNull$$$0(7);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)viewsRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile viewsRoot) {
                if (viewsRoot == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (SinatraViewRefParam.isLowLevelDirectory(viewsRoot)) {
                    SinatraViewRefParam.processFiles(context.getProject(), viewsRoot, (Consumer<VirtualFile>)file -> {
                        String variant;
                        String extension = file.getExtension();
                        if (SinatraViewRefParam.this.myTemplateType.getPossibleExtensions().contains(extension) && lookupStringFilter.test(variant = file.getNameWithoutExtension())) {
                            elementConsumer.consume((Object)ParamDefBase.createLookupItem(context, variant, LookupItemType.Symbol, FileTypeManager.getInstance().getFileTypeByFile(file).getIcon()));
                        }
                    });
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewsRoot", "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/SinatraViewRefParam$1", "visitFile"));
            }
        });
    }

    private static void processAllNamedTemplatesVariants(@NotNull PsiFile sinatraFile, RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementConsumer, @NotNull Predicate<String> lookupStringFilter) {
        if (sinatraFile == null) {
            SinatraViewRefParam.$$$reportNull$$$0(8);
        }
        if (elementConsumer == null) {
            SinatraViewRefParam.$$$reportNull$$$0(9);
        }
        if (lookupStringFilter == null) {
            SinatraViewRefParam.$$$reportNull$$$0(10);
        }
        if (sinatraFile instanceof RFile) {
            SinatraUtil.processNamedTemplates((RFile)sinatraFile, (Consumer<? super String>)((Consumer)templateName -> {
                if (lookupStringFilter.test((String)templateName)) {
                    elementConsumer.consume((Object)SinatraViewRefParam.createLookupItem(context, templateName, LookupItemType.Symbol, RubyIcons.Ruby.Nodes.Symbol));
                }
            }));
        }
    }

    private static boolean isLowLevelDirectory(@NotNull VirtualFile file) {
        VirtualFile[] children;
        if (file == null) {
            SinatraViewRefParam.$$$reportNull$$$0(11);
        }
        for (VirtualFile child : children = file.getChildren()) {
            if (!child.isDirectory()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            SinatraViewRefParam.$$$reportNull$$$0(12);
        }
        String text = SinatraViewRefParam.elementText(context);
        Module module = context.getModule();
        VirtualFile viewsFolder = SinatraUtil.getViewsFolder(module);
        if (viewsFolder != null) {
            List<String> extensions = this.myTemplateType.getPossibleExtensions();
            for (String extension : extensions) {
                PsiFile file = SinatraViewRefParam.findPsiFile(context, viewsFolder.findFileByRelativePath(text + "." + extension));
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewsRoot";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sinatraFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/SinatraViewRefParam";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleRename";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllVariants";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllViewsVariants";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllNamedTemplatesVariants";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isLowLevelDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

