/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.RailsControllerRefParam;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.rails.routes.RoutesParser;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

final class RailsRoutesControllerRefParam
extends RailsControllerRefParam {
    RailsRoutesControllerRefParam(LookupItemType ... lookupItemTypes) {
        if (lookupItemTypes == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(0);
        }
        super(lookupItemTypes);
    }

    @Override
    @NotNull
    public TextRange getRange(@NotNull RubyCallArgumentContext context) {
        RPsiElement element;
        String text;
        if (context == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(1);
        }
        if ((text = (element = context.getArgumentElement()).getText()).contains("#")) {
            int start = element.getFirstChild() != null ? element.getFirstChild().getTextLength() : 0;
            TextRange textRange = TextRange.create((int)start, (int)text.indexOf("#"));
            if (textRange == null) {
                RailsRoutesControllerRefParam.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = super.getRange(context);
        if (textRange == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Override
    @NotNull
    public String handleRename(@NotNull RubyCallArgumentContext context, @NotNull String newName) {
        if (context == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(5);
        }
        String oldName = StringUtil.notNullize((String)RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)context.getArgumentElement()));
        int index = oldName.indexOf("#");
        String string = ControllersConventions.getControllerNameByClassName(newName, context.getModule()) + (index >= 0 ? oldName.substring(index) : "");
        if (string == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getControllerName(@NotNull RubyCallArgumentContext context) {
        Module module;
        if (context == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(7);
        }
        if ((module = context.getModule()) == null) {
            return super.getControllerName(context);
        }
        return Optional.ofNullable(RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)context.getArgumentElement())).map(text -> (String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)text, (String)"#"), (Object)text)).map(name -> RailsRoutesControllerRefParam.isSingular(context) ? InflectorService.getInstance(module).pluralize((String)name) : name).map(name -> ControllersConventions.getControllerClassName(name, module)).orElse(null);
    }

    @Override
    @Nullable
    protected String getLookupElementName(@NotNull VirtualFile file, @NotNull RubyCallArgumentContext context) {
        if (file == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(8);
        }
        if (context == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(9);
        }
        String originalName = super.getLookupElementName(file, context);
        Module module = context.getModule();
        if (module == null) {
            return originalName;
        }
        return RailsRoutesControllerRefParam.isSingular(context) ? InflectorService.getInstance(module).singularize(originalName) : originalName;
    }

    @Override
    @NotNull
    protected FQN getNamespaceFqn(@NotNull RubyCallArgumentContext context) {
        Module module;
        if (context == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(10);
        }
        if ((module = context.getModule()) == null) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                RailsRoutesControllerRefParam.$$$reportNull$$$0(11);
            }
            return fQN;
        }
        RCall call = (RCall)CompletionUtil.getOriginalOrSelf((PsiElement)context.getCall());
        RailsApp app = RailsApp.fromModule(module);
        if (app == null || !app.getRoutesFiles().contains(PsiUtilCore.getVirtualFile((PsiElement)call))) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                RailsRoutesControllerRefParam.$$$reportNull$$$0(12);
            }
            return fQN;
        }
        FQN fQN = RoutesParser.getInstance(module).getNamespaceFqn((PsiElement)ObjectUtils.coalesce((Object)RBlockCallNavigator.getByCall((RPsiElement)call), (Object)call));
        if (fQN == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(13);
        }
        return fQN;
    }

    private static boolean isSingular(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RailsRoutesControllerRefParam.$$$reportNull$$$0(14);
        }
        return context.getCall().getCommand().equals("resource");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupItemTypes";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/RailsRoutesControllerRefParam";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/RailsRoutesControllerRefParam";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "handleRename";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRange";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getControllerName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElementName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFqn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSingular";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

