/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

class RailsControllerRefParam
extends ParamDefBase {
    private final EnumSet<LookupItemType> myLookupItemTypes;

    RailsControllerRefParam(LookupItemType ... lookupItemTypes) {
        if (lookupItemTypes == null) {
            RailsControllerRefParam.$$$reportNull$$$0(0);
        }
        this.myLookupItemTypes = EnumSet.copyOf(Arrays.asList(lookupItemTypes));
    }

    @Override
    @Nullable
    public String handleRename(@NotNull RubyCallArgumentContext context, @NotNull String newName) {
        String oldName;
        int index;
        if (context == null) {
            RailsControllerRefParam.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            RailsControllerRefParam.$$$reportNull$$$0(2);
        }
        return ((index = (oldName = StringUtil.notNullize((String)RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)context.getArgumentElement()))).indexOf("/")) >= 0 ? oldName.substring(0, index + 1) : "") + ControllersConventions.getControllerNameByClassName(newName, context.getModule());
    }

    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RailsControllerRefParam.$$$reportNull$$$0(3);
        }
        RPsiElement element = context.getArgumentElement();
        if (this.multiResolve(context).isEmpty()) {
            if (RubyPsiUtil.isSimpleStringOrSymbol((PsiElement)element)) {
                String message = RBundle.message((String)"inspection.paramdef.controller.warning", (Object[])new Object[]{ParamDef.getTextPresentationForPsiElement(element)});
                InspectionResult inspectionResult = InspectionResult.createWarningResult((PsiElement)element, message);
                if (inspectionResult == null) {
                    RailsControllerRefParam.$$$reportNull$$$0(4);
                }
                return inspectionResult;
            }
            InspectionResult inspectionResult = InspectionResult.createProbablyAcceptibleResult((PsiElement)element);
            if (inspectionResult == null) {
                RailsControllerRefParam.$$$reportNull$$$0(5);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)element);
        if (inspectionResult == null) {
            RailsControllerRefParam.$$$reportNull$$$0(6);
        }
        return inspectionResult;
    }

    @Override
    @NotNull
    public List<? extends PsiElement> multiResolve(@NotNull RubyCallArgumentContext context) {
        Module module;
        if (context == null) {
            RailsControllerRefParam.$$$reportNull$$$0(7);
        }
        if ((module = context.getModule()) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsControllerRefParam.$$$reportNull$$$0(8);
            }
            return list;
        }
        String name = this.getControllerName(context);
        if (StringUtil.isEmpty((String)name)) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsControllerRefParam.$$$reportNull$$$0(9);
            }
            return list;
        }
        FQN controllerFqn = FQN.Builder.concat((FQN)this.getNamespaceFqn(context), (String)name);
        List<RContainer> list = RubyFQNUtil.findContainersByFQN(context.getProject(), Type.CLASS.asSet(), controllerFqn, (PsiElement)context.getArgumentElement());
        if (list == null) {
            RailsControllerRefParam.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        Module module;
        if (context == null) {
            RailsControllerRefParam.$$$reportNull$$$0(11);
        }
        if (elementsConsumer == null) {
            RailsControllerRefParam.$$$reportNull$$$0(12);
        }
        if (lookupStringFilter == null) {
            RailsControllerRefParam.$$$reportNull$$$0(13);
        }
        if ((module = context.getModule()) == null) {
            return;
        }
        String namespace = NamingConventions.toUnderscoreCase((String)this.getNamespaceFqn(context).getFullPath(), (Module)context.getModule());
        for (VirtualFile controllersRoot : RailsControllerRefParam.controllerRoots(context)) {
            VirtualFile relativeRoot = controllersRoot.findFileByRelativePath(namespace);
            if (relativeRoot == null) continue;
            RailsControllerRefParam.processFiles(context.getProject(), relativeRoot, (Consumer<VirtualFile>)((Consumer)file -> {
                RailsController controller = RailsController.fromFile(module, file);
                if (controller == null || controller.isApplicationController()) {
                    return;
                }
                String name = this.getLookupElementName((VirtualFile)file, context);
                if (StringUtil.isEmpty((String)name)) {
                    return;
                }
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file.getParent(), (VirtualFile)relativeRoot);
                if (this.myLookupItemTypes.contains((Object)LookupItemType.Symbol) && StringUtil.isEmpty((String)relativePath) && lookupStringFilter.test(name)) {
                    elementsConsumer.consume((Object)RailsControllerRefParam.createLookupItem(context, name, LookupItemType.Symbol, AllIcons.Nodes.Controller));
                } else if (this.myLookupItemTypes.contains((Object)LookupItemType.String)) {
                    String title;
                    String string = title = StringUtil.isNotEmpty((String)relativePath) ? relativePath + "/" + name : name;
                    if (lookupStringFilter.test(title)) {
                        elementsConsumer.consume((Object)RailsControllerRefParam.createLookupItem(context, title, LookupItemType.String, AllIcons.Nodes.Controller));
                    }
                }
            }));
        }
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RailsControllerRefParam.$$$reportNull$$$0(14);
        }
        return (PsiElement)ContainerUtil.getOnlyItem(this.multiResolve(context));
    }

    @Nullable
    protected String getControllerName(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RailsControllerRefParam.$$$reportNull$$$0(15);
        }
        return ControllersConventions.getControllerClassName(RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)context.getArgumentElement()), context.getModule());
    }

    @Nullable
    protected String getLookupElementName(@NotNull VirtualFile file, @NotNull RubyCallArgumentContext context) {
        if (file == null) {
            RailsControllerRefParam.$$$reportNull$$$0(16);
        }
        if (context == null) {
            RailsControllerRefParam.$$$reportNull$$$0(17);
        }
        return ControllersConventions.getControllerName(file);
    }

    @NotNull
    protected FQN getNamespaceFqn(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            RailsControllerRefParam.$$$reportNull$$$0(18);
        }
        FQN fQN = FQN.INVALID;
        if (fQN == null) {
            RailsControllerRefParam.$$$reportNull$$$0(19);
        }
        return fQN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 9, 10, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupItemTypes";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/RailsControllerRefParam";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/RailsControllerRefParam";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getControllerName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElementName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFqn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 9, 10, 19 -> new IllegalStateException(string);
        };
    }
}

