/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class ModelRefParam
extends ParamDefBase {
    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        if (context == null) {
            ModelRefParam.$$$reportNull$$$0(0);
        }
        if (elementsConsumer == null) {
            ModelRefParam.$$$reportNull$$$0(1);
        }
        if (lookupStringFilter == null) {
            ModelRefParam.$$$reportNull$$$0(2);
        }
        for (VirtualFile root : ModelRefParam.modelRoots(context)) {
            ModelRefParam.processFiles(context.getProject(), root, (Consumer<VirtualFile>)((Consumer)file -> {
                LookupElement item = this.createItem(context, root, (VirtualFile)file, lookupStringFilter);
                if (item != null) {
                    elementsConsumer.consume((Object)item);
                }
            }));
        }
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        Module mod;
        if (context == null) {
            ModelRefParam.$$$reportNull$$$0(3);
        }
        if ((mod = context.getModule()) == null || !InflectorService.getInstance(mod).isInflectorAvailable()) {
            return null;
        }
        String modelName = InflectorService.getInstance(mod).singularize(ModelRefParam.elementText(context));
        return ModelRefParam.findModel(context, modelName);
    }

    @Override
    public InspectionResult warningInspection(RubyCallArgumentContext context, RPsiElement element) {
        String message = RBundle.message((String)"inspection.paramdef.model.warning", (Object[])new Object[]{ParamDef.getTextPresentationForPsiElement(element)});
        return InspectionResult.createWarningResult((PsiElement)element, message);
    }

    @Nullable
    protected static RClass findModel(@NotNull RubyCallArgumentContext context, @Nullable String classOrModelName) {
        Module module;
        if (context == null) {
            ModelRefParam.$$$reportNull$$$0(4);
        }
        if ((module = context.getModule()) == null) {
            return null;
        }
        FQN modelFqn = FQN.of((String)NamingConventions.toCamelCase((String)classOrModelName, (Module)module));
        return AssociationsUtil.findModel(modelFqn, module, (PsiElement)context.getCall());
    }

    protected String getItemName(RubyCallArgumentContext context, String extension) {
        return StringUtil.pluralize((String)extension);
    }

    @Nullable
    protected LookupElement createItem(@NotNull RubyCallArgumentContext context, @NotNull VirtualFile root, @NotNull VirtualFile file, @NotNull Predicate<String> lookupStringFilter) {
        if (context == null) {
            ModelRefParam.$$$reportNull$$$0(5);
        }
        if (root == null) {
            ModelRefParam.$$$reportNull$$$0(6);
        }
        if (file == null) {
            ModelRefParam.$$$reportNull$$$0(7);
        }
        if (lookupStringFilter == null) {
            ModelRefParam.$$$reportNull$$$0(8);
        }
        String modelName = this.getItemName(context, file.getNameWithoutExtension());
        return !Comparing.equal((Object)file, (Object)context.getCall().getContainingFile().getVirtualFile()) && lookupStringFilter.test(modelName) ? ModelRefParam.createLookupItem(context, modelName, LookupItemType.Symbol, RailsIcons.RAILS_MODEL_ICON) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/ModelRefParam";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findModel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

