/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsTypeProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsActiveRecordAttributeSymbol;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.database.MigrationParser;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;

public class MigrationFieldRefParam
extends ParamDefBase {
    protected ParamDependency<PsiElement> modelClassRefDependency;
    protected ParamDependency<PsiElement> tableNameDependency;

    public MigrationFieldRefParam(@Nullable ParamDependency<PsiElement> modelClassRefDependency, @Nullable ParamDependency<PsiElement> tableNameDependency) {
        this.modelClassRefDependency = modelClassRefDependency;
        this.tableNameDependency = tableNameDependency;
    }

    public MigrationFieldRefParam(ParamDependency<PsiElement> modelClassRefDependency) {
        this(modelClassRefDependency, null);
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        Collection<MigrationField> fields;
        if (context == null) {
            MigrationFieldRefParam.$$$reportNull$$$0(0);
        }
        if (elementsConsumer == null) {
            MigrationFieldRefParam.$$$reportNull$$$0(1);
        }
        if (lookupStringFilter == null) {
            MigrationFieldRefParam.$$$reportNull$$$0(2);
        }
        if ((fields = this.getFields(context)) == null) {
            return;
        }
        for (MigrationField field : fields) {
            String name = field.getName();
            if (name == null || name.equals("id") || !lookupStringFilter.test(name)) continue;
            elementsConsumer.consume((Object)MigrationFieldRefParam.createTypedLookupItem(context, name, field.getDataType(), LookupItemType.Symbol, RailsIcons.RAILS_MODEL_ATTRIBUTE_ICON));
        }
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            MigrationFieldRefParam.$$$reportNull$$$0(3);
        }
        String name = MigrationFieldRefParam.elementText(context);
        Collection<MigrationField> fields = this.getFields(context);
        if (fields == null) {
            return null;
        }
        for (MigrationField field : fields) {
            PsiElement declaration;
            if (!name.equals(field.getName()) || (declaration = RailsActiveRecordAttributeSymbol.getAttributeReaderDeclaration(field)) == null) continue;
            return declaration;
        }
        return null;
    }

    @Override
    public InspectionResult warningInspection(RubyCallArgumentContext context, RPsiElement element) {
        String message;
        String tableName = this.determineTableName(context);
        if (tableName == null) {
            message = RBundle.message((String)"inspection.paramdef.migration.warning.undefined.db", (Object[])new Object[]{this.getTargetClassName(context), ParamDef.getTextPresentationForPsiElement(element)});
        } else {
            Collection<MigrationField> fieldsCollection = this.getFields(context);
            Object egText = "";
            if (fieldsCollection != null && !fieldsCollection.isEmpty()) {
                Iterator<MigrationField> iterator = fieldsCollection.iterator();
                ArrayList<String> someFields = new ArrayList<String>();
                for (int count = 0; count < 3 && iterator.hasNext(); ++count) {
                    String nextField = iterator.next().getName();
                    if (nextField == null || "id".equals(StringUtil.toLowerCase((String)nextField))) continue;
                    someFields.add(nextField);
                }
                String variantsText = null;
                if (!someFields.isEmpty()) {
                    String s0 = (String)someFields.get(0);
                    if (s0 != null) {
                        variantsText = ":" + s0;
                        if (someFields.size() != 1 && someFields.get(1) != null) {
                            variantsText = variantsText + " or :" + (String)someFields.get(1);
                        }
                    }
                    if (variantsText != null) {
                        egText = " " + RBundle.message((String)"inspection.paramdef.warning.eg.singular", (Object[])new Object[]{variantsText});
                    }
                }
            }
            message = RBundle.message((String)"inspection.paramdef.migration.warning", (Object[])new Object[]{tableName, ParamDef.getTextPresentationForPsiElement(element), egText});
        }
        return InspectionResult.createWarningResult((PsiElement)element, message);
    }

    @Override
    protected boolean inspectionEnabledFor(RubyCallArgumentContext context) {
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        MigrationParser parser = MigrationParser.getInstance(module);
        String name = this.determineTableName(context);
        if (this.tableNameDependency != null && !parser.containsTable(name)) {
            return false;
        }
        if (this.modelClassRefDependency != null && !parser.containsTable(name)) {
            return false;
        }
        return super.inspectionEnabledFor(context);
    }

    @Nullable
    protected Collection<MigrationField> getFields(RubyCallArgumentContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        String tableName = this.determineTableName(context);
        return tableName != null ? MigrationParser.getInstance(module).getFieldsByTableName(tableName) : null;
    }

    @Nullable
    protected String determineTableName(RubyCallArgumentContext context) {
        if (this.tableNameDependency != null) {
            Module module = context.getModule();
            if (module == null) {
                return null;
            }
            PsiElement tableNameElement = this.tableNameDependency.getValue(context);
            return tableNameElement != null ? RubyPsiUtilCore.getElementText((PsiElement)tableNameElement) : null;
        }
        String modelClassName = this.getTargetClassName(context);
        ActiveRecordModel activeRecordModel = ActiveRecordModel.fromModelName(context.getModule(), modelClassName);
        return activeRecordModel != null ? activeRecordModel.getTableName() : null;
    }

    @Nullable
    protected String getTargetClassName(RubyCallArgumentContext context) {
        if (this.modelClassRefDependency != null) {
            PsiElement value = this.modelClassRefDependency.getValue(context);
            return value instanceof RPsiElement ? ((RPsiElement)value).getName() : null;
        }
        Symbol symbol = RailsTypeProvider.getModelContextSymbol((RExpression)context.getCall());
        return symbol == null ? null : symbol.getFQNWithNesting().getFullPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/MigrationFieldRefParam";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

