/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import icons.RubyIcons;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AliasSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.CreateRubyMethodFix;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class MethodRefParam
extends ParamDefBase {
    protected Visibility minAccess;
    protected LookupItemType itemType;
    protected ParamDependency containerDependency;
    protected String topParent;

    public MethodRefParam(String topParent, Visibility minAccess, LookupItemType itemType) {
        this(topParent, minAccess, itemType, null);
    }

    public MethodRefParam(String topParent, Visibility minAccess, LookupItemType itemType, @Nullable ParamDependency containerDependency) {
        this.minAccess = minAccess;
        this.itemType = itemType;
        this.containerDependency = containerDependency;
        this.topParent = topParent;
    }

    public MethodRefParam(String topParent, Visibility minAccess) {
        this(topParent, minAccess, LookupItemType.String);
    }

    @Override
    public InspectionResult warningInspection(RubyCallArgumentContext context, RPsiElement element) {
        String message = this.warningInspectionMessage(element);
        return this.buildResultWithFix(context, message, element);
    }

    protected InspectionResult buildResultWithFix(RubyCallArgumentContext context, @InspectionMessage String message, RPsiElement element) {
        RContainer container = this.getTargetContainer(context);
        String methodName = MethodRefParam.elementText(context);
        CreateRubyMethodFix fix = null;
        if (container != null && TextUtil.isAnyID((String)methodName)) {
            Project project = context.getProject();
            fix = new CreateRubyMethodFix(project, null, container, methodName, ContextImpl.INSTANCE, this.minAccess == null ? Visibility.PROTECTED : this.minAccess);
        }
        return InspectionResult.createWarningResultWithFix((PsiElement)element, message, fix);
    }

    @InspectionMessage
    protected String warningInspectionMessage(RPsiElement element) {
        Object message = RBundle.message((String)"inspection.paramdef.method.warning", (Object[])new Object[]{this.topParent == null ? "" : " " + RBundle.message((String)"inspection.paramdef.method.warning.up.to.part", (Object[])new Object[]{this.topParent}), ParamDef.getTextPresentationForPsiElement(element)});
        if (this.minAccess != Visibility.PRIVATE) {
            message = (String)message + " " + RBundle.message((String)"inspection.paramdef.access.warning", (Object[])new Object[]{this.minAccess.toString()});
        }
        return message;
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        RContainer container;
        if (context == null) {
            MethodRefParam.$$$reportNull$$$0(0);
        }
        if (elementsConsumer == null) {
            MethodRefParam.$$$reportNull$$$0(1);
        }
        if (lookupStringFilter == null) {
            MethodRefParam.$$$reportNull$$$0(2);
        }
        if ((container = this.getTargetContainer(context)) != null) {
            this.processVariantsFromClass(context, container, elementsConsumer, lookupStringFilter);
        }
    }

    @Override
    @Nullable
    public final PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        Symbol symbol;
        if (context == null) {
            MethodRefParam.$$$reportNull$$$0(3);
        }
        return (symbol = this.resolveReferenceToSymbol(context)) == null ? null : symbol.getPsiElement();
    }

    @Override
    protected PsiElement resolveReferenceForInspectionHook(@NotNull RubyCallArgumentContext context) {
        Symbol methodSymbol;
        if (context == null) {
            MethodRefParam.$$$reportNull$$$0(4);
        }
        return (methodSymbol = this.resolveReferenceToSymbol(context)) != null && this.isValidMethod(methodSymbol) ? methodSymbol.getPsiElement() : null;
    }

    @Nullable
    protected Symbol resolveReferenceInContainer(@NotNull String name, @Nullable RContainer container) {
        Symbol symbol;
        if (name == null) {
            MethodRefParam.$$$reportNull$$$0(5);
        }
        if ((symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container)) == null) {
            return null;
        }
        Symbol method = SymbolUtil.findMethod(symbol, name, Types.METHODS_LIKE, (PsiElement)container);
        return this.isValidMethod(method) ? method : null;
    }

    protected boolean processVariantsFromClass(RubyCallArgumentContext context, RContainer container, @NotNull Consumer<? super LookupElement> elementConsumer, @NotNull Predicate<String> lookupStringFilter) {
        Symbol symbol;
        if (elementConsumer == null) {
            MethodRefParam.$$$reportNull$$$0(6);
        }
        if (lookupStringFilter == null) {
            MethodRefParam.$$$reportNull$$$0(7);
        }
        if ((symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container)) == null) {
            return false;
        }
        this.processMethodsWithInherited(symbol, context.getArgumentElement(), (Consumer<? super PsiElement>)((Consumer)method -> {
            LookupElement item;
            PsiNamedElement namedElement;
            if (method instanceof PsiNamedElement && lookupStringFilter.test((namedElement = (PsiNamedElement)method).getName()) && (item = MethodRefParam.createLookupItem(context, namedElement.getName(), this.itemType, MethodRefParam.getIcon(method))) != null) {
                elementConsumer.consume((Object)item);
            }
        }));
        return true;
    }

    protected void processMethodsWithInherited(Symbol symbol, RPsiElement element, @NotNull Consumer<? super PsiElement> elementConsumer) {
        if (elementConsumer == null) {
            MethodRefParam.$$$reportNull$$$0(8);
        }
        HashSet overriddenMethods = new HashSet();
        while (symbol instanceof ClassModuleSymbol && symbol.getPsiElement() instanceof RContainer) {
            if (FQN.same((FQN)symbol.getFQNWithNesting(), (String)this.topParent)) {
                return;
            }
            Symbol.processSymbolsByFilter((Symbol)symbol, (Symbol.Filter)Symbol.Filter.byType((Type)Type.INSTANCE_METHOD), (PsiElement)element, method -> {
                if (this.isValidMethod((Symbol)method) && overriddenMethods.add(method.getName())) {
                    elementConsumer.consume((Object)method.getPsiElement());
                }
            });
            Symbol.processSymbolsByFilter((Symbol)symbol, (Symbol.Filter)Symbol.Filter.byType((Type)Type.ALIAS), (PsiElement)element, alias -> {
                Symbol aliased = SymbolUtil.getMethodSymbolByAlias(alias);
                if (this.isValidMethod(aliased) && overriddenMethods.add(alias.getName())) {
                    elementConsumer.consume((Object)alias.getPsiElement());
                }
            });
            symbol = ((ClassModuleSymbol)symbol).getSuperClassSymbol((PsiElement)element);
        }
    }

    public boolean isValidMethod(@Nullable Symbol methodLikeSymbol) {
        if (methodLikeSymbol != null && Types.ATTR_METHODS.contains(methodLikeSymbol.getType())) {
            return true;
        }
        Symbol method = methodLikeSymbol;
        if (methodLikeSymbol instanceof AliasSymbol) {
            method = SymbolUtil.getMethodSymbolByAlias(methodLikeSymbol);
        }
        if (method == null) {
            return false;
        }
        PsiElement declaration = method.getPsiElement();
        if (!(declaration instanceof RMethod)) {
            return false;
        }
        Visibility visibility = ((RMethod)declaration).getVisibility();
        return this.minAccess != Visibility.PUBLIC || visibility == Visibility.PUBLIC;
    }

    @Nullable
    protected RContainer getTargetContainer(RubyCallArgumentContext context) {
        Object dependencyValue;
        if (this.containerDependency != null && (dependencyValue = this.containerDependency.getValue(context)) instanceof RContainer) {
            return (RContainer)dependencyValue;
        }
        PsiNamedElement targetContainer = this.findTargetClass(context);
        return targetContainer instanceof RContainer ? (RContainer)targetContainer : null;
    }

    @Nullable
    protected PsiNamedElement findTargetClass(RubyCallArgumentContext context) {
        RCall contextElement = context.getCall();
        return (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)contextElement, (Class[])new Class[]{RClass.class, RModule.class});
    }

    protected static Icon getIcon(PsiElement method) {
        if (!(method instanceof RMethod)) {
            return method.getIcon(0);
        }
        RailsAction railsAction = RailsAction.fromMethod((RMethod)method);
        return railsAction != null ? RubyIcons.Rails.ActionMethod : AllIcons.Nodes.Method;
    }

    @Nullable
    protected Symbol resolveReferenceToSymbol(@NotNull RubyCallArgumentContext context) {
        RContainer container;
        RPsiElement element;
        String name;
        if (context == null) {
            MethodRefParam.$$$reportNull$$$0(9);
        }
        if ((name = MethodRefParam.getActionName((PsiElement)(element = context.getArgumentElement()))) == null) {
            name = MethodRefParam.elementText(context);
        }
        return (container = this.getTargetContainer(context)) == null ? null : this.resolveReferenceInContainer(name, container);
    }

    @Nullable
    private static String getActionName(@NotNull PsiElement element) {
        String text;
        if (element == null) {
            MethodRefParam.$$$reportNull$$$0(10);
        }
        boolean splitCharRequired = true;
        PsiElement parent = element.getParent();
        if (parent instanceof RAssoc && ((RAssoc)parent).getKeyText().equals("action")) {
            splitCharRequired = false;
        }
        if ((text = RubyPsiUtilCore.getElementText((PsiElement)element)) != null && text.contains("#")) {
            text = text.substring(text.indexOf("#") + 1);
        } else if (splitCharRequired) {
            return null;
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/MethodRefParam";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReferenceForInspectionHook";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReferenceInContainer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processVariantsFromClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processMethodsWithInherited";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReferenceToSymbol";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

