/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsMailbox;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class MailboxRefParam
extends ParamDefBase {
    @NotNull
    public List<PsiElement> multiResolve(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            MailboxRefParam.$$$reportNull$$$0(0);
        }
        RPsiElement invocationPoint = context.getArgumentElement();
        FQN name = FQN.of((String)(NamingConventions.toCamelCase((String)MailboxRefParam.elementText(context), (Module)context.getModule()) + "Mailbox"));
        Symbol symbol = SymbolUtil.findConstantByFQN(context.getProject(), Type.CLASS, name, (PsiElement)invocationPoint);
        if (symbol != null && MailboxRefParam.isMailbox(symbol, (PsiElement)invocationPoint)) {
            return new ArrayList<PsiElement>(symbol.getAllDeclarations((PsiElement)invocationPoint));
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            MailboxRefParam.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        Symbol actionMailboxBaseSymbol;
        if (context == null) {
            MailboxRefParam.$$$reportNull$$$0(2);
        }
        if (elementsConsumer == null) {
            MailboxRefParam.$$$reportNull$$$0(3);
        }
        if (lookupStringFilter == null) {
            MailboxRefParam.$$$reportNull$$$0(4);
        }
        if ((actionMailboxBaseSymbol = SymbolUtil.findConstantByFQN(context.getProject(), FQN.of((String)"ActionMailbox::Base"), (PsiElement)context.getArgumentElement())) == null) {
            return;
        }
        Collection<? extends Symbol> children = RubyOverrideImplementUtil.getOverridingSymbols(actionMailboxBaseSymbol);
        for (Symbol symbol : children) {
            String lookupString;
            if (MailboxRefParam.isApplicationMailbox(symbol) || symbol.getFQNWithNesting() == FQN.INVALID) continue;
            String className = symbol.getFQNWithNesting().getFullPath();
            StringBuilder sb = new StringBuilder(NamingConventions.toUnderscoreCase((String)StringUtil.trimEnd((String)className, (String)"Mailbox"), (Module)context.getModule()));
            if (symbol.getFQNWithNesting().asList().size() > 1) {
                sb.insert(0, "'").append("'");
            }
            if (!lookupStringFilter.test(lookupString = sb.toString())) continue;
            elementsConsumer.consume((Object)MailboxRefParam.createLookupItem(context, lookupString, LookupItemType.Symbol, RubyIcons.Ruby.Nodes.Symbol));
        }
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            MailboxRefParam.$$$reportNull$$$0(5);
        }
        return (PsiElement)ContainerUtil.getOnlyItem(this.multiResolve(context));
    }

    private static boolean isMailbox(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            MailboxRefParam.$$$reportNull$$$0(6);
        }
        return SymbolHierarchy.isInheritor(symbol, RailsMailbox.ACTION_MAILBOX_BASE_FQN, invocationPoint) && !MailboxRefParam.isApplicationMailbox(symbol);
    }

    private static boolean isApplicationMailbox(@NotNull Symbol symbol) {
        if (symbol == null) {
            MailboxRefParam.$$$reportNull$$$0(7);
        }
        return symbol.getFQNWithNesting().equals(RailsMailbox.APPLICATION_MAILBOX_FQN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/MailboxRefParam";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/MailboxRefParam";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMailbox";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isApplicationMailbox";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

