/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.MigrationFieldRefParam;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.database.MigrationParser;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

public class JoinFieldRefParam
extends MigrationFieldRefParam {
    public JoinFieldRefParam(@Nullable ParamDependency<PsiElement> modelClassRefDependency) {
        super(modelClassRefDependency);
    }

    @Override
    protected Collection<MigrationField> getFields(RubyCallArgumentContext context) {
        PsiElement depValue = (PsiElement)this.modelClassRefDependency.getValue(context);
        if (!(depValue instanceof RPsiElement)) {
            return new ArrayList<MigrationField>();
        }
        RClass parent = (RClass)PsiTreeUtil.getParentOfType((PsiElement)context.getCall(), RClass.class);
        if (parent == null) {
            return new ArrayList<MigrationField>();
        }
        String selfName = parent.getName();
        String depName = ((RPsiElement)depValue).getName();
        Module module = context.getModule();
        InflectorService inflector = InflectorService.getInstance(module);
        if (inflector.isInflectorAvailable()) {
            selfName = inflector.tableize(selfName);
            depName = inflector.tableize(depName);
        }
        if (depName == null || selfName == null) {
            return new ArrayList<MigrationField>();
        }
        MigrationParser parser = MigrationParser.getInstance(module);
        String tableName = selfName.compareTo(depName) < 0 ? selfName + "_" + depName : depName + "_" + selfName;
        return parser.getFieldsByTableName(tableName);
    }
}

