/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class HelperRefParam
extends ParamDefBase {
    private static final List<Pair<String, String>> CONSTANT_VALUES = new ArrayList<Pair<String, String>>();
    private final boolean includeOnlyRealFiles;

    public HelperRefParam(boolean includeOnlyRealFiles) {
        this.includeOnlyRealFiles = includeOnlyRealFiles;
        CONSTANT_VALUES.add((Pair<String, String>)Pair.create((Object)"all", (Object)"symbol"));
    }

    @Override
    public void processAllVariants(@NotNull RubyCallArgumentContext context, @NotNull Consumer<? super LookupElement> elementsConsumer, @NotNull Predicate<String> lookupStringFilter) {
        Module module;
        if (context == null) {
            HelperRefParam.$$$reportNull$$$0(0);
        }
        if (elementsConsumer == null) {
            HelperRefParam.$$$reportNull$$$0(1);
        }
        if (lookupStringFilter == null) {
            HelperRefParam.$$$reportNull$$$0(2);
        }
        List<VirtualFile> helperRoots = (module = context.getModule()) != null ? RailsPaths.getInstance(module).findFiles("app/helpers") : Collections.emptyList();
        for (VirtualFile helperRoot : helperRoots) {
            String helperRootPath = helperRoot.getPath() + "/";
            HelperRefParam.processFiles(context.getProject(), helperRoot, (Consumer<VirtualFile>)((Consumer)file -> {
                Object variant;
                String relativeName = file.getPath().replaceAll(helperRootPath, "");
                String separator = "_helper.rb";
                Object object = variant = relativeName.endsWith("_helper.rb") ? relativeName.substring(0, relativeName.length() - "_helper.rb".length()) : relativeName;
                if (((String)variant).contains("/")) {
                    variant = "'" + (String)variant + "'";
                }
                if (lookupStringFilter.test((String)variant)) {
                    elementsConsumer.consume((Object)HelperRefParam.createLookupItem(context, (String)variant, LookupItemType.Symbol, RubyIcons.Rails.ProjectView.HelpersFolder));
                }
            }));
        }
        this.addOtherHelpers(context, elementsConsumer);
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        Module module;
        if (context == null) {
            HelperRefParam.$$$reportNull$$$0(3);
        }
        if ((module = context.getModule()) == null) {
            return null;
        }
        for (VirtualFile root : RailsPaths.getInstance(module).findFiles("app/helpers")) {
            PsiFile file = HelperRefParam.findPsiFileUnder(context, root, HelperRefParam.elementText(context) + "_helper.rb");
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            HelperRefParam.$$$reportNull$$$0(4);
        }
        RPsiElement elementAtLevel = context.getArgumentElement();
        if (this.resolveReference(context) != null) {
            InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)elementAtLevel);
            if (inspectionResult == null) {
                HelperRefParam.$$$reportNull$$$0(5);
            }
            return inspectionResult;
        }
        if (HelperRefParam.processConstantValues(context, (NotNullFunction<? super Pair<String, String>, Boolean>)((NotNullFunction)pair -> {
            String name = elementAtLevel.getName();
            String first = (String)pair.getFirst();
            return name != null && first != null && first.equals(name);
        }))) {
            InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)elementAtLevel);
            if (inspectionResult == null) {
                HelperRefParam.$$$reportNull$$$0(6);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = this.warningInspection(context, elementAtLevel);
        if (inspectionResult == null) {
            HelperRefParam.$$$reportNull$$$0(7);
        }
        return inspectionResult;
    }

    @Override
    public InspectionResult warningInspection(RubyCallArgumentContext context, RPsiElement element) {
        String message = RBundle.message((String)"inspection.paramdef.helper.warning", (Object[])new Object[]{ParamDef.getTextPresentationForPsiElement(element)});
        return InspectionResult.createWarningResult((PsiElement)element, message);
    }

    private void addOtherHelpers(RubyCallArgumentContext context, Consumer<? super LookupElement> elementConsumer) {
        Project project = context.getProject();
        if (!this.includeOnlyRealFiles) {
            HelperRefParam.processConstantValues(context, (NotNullFunction<? super Pair<String, String>, Boolean>)((NotNullFunction)pair -> {
                String type = (String)pair.getSecond();
                if ("symbol".equals(type)) {
                    elementConsumer.consume((Object)HelperRefParam.createLookupItem(context, (String)pair.getFirst(), LookupItemType.Symbol, RubyIcons.Rails.ProjectView.HelpersFolder));
                } else if ("string".equals(type)) {
                    elementConsumer.consume((Object)HelperRefParam.createLookupItem(context, (String)pair.getFirst(), LookupItemType.String, RubyIcons.Rails.ProjectView.HelpersFolder));
                }
                return false;
            }));
        }
        RailsApp railsApp = HelperRefParam.railsApp(context);
        if (context.getArgumentElement() instanceof RSymbol || railsApp == null) {
            return;
        }
        HashMap filesChecked = new HashMap();
        for (VirtualFile libsRoot : railsApp.getPaths().findFiles("lib")) {
            String libRootPath = libsRoot.getPath() + "/";
            HelperRefParam.processFiles(project, libsRoot, (Consumer<VirtualFile>)((Consumer)file -> HelperRefParam.handleFile(context, libsRoot, libRootPath, file, elementConsumer, filesChecked)));
        }
        List plugins = ContainerUtil.sorted((Collection)ContainerUtil.flatMap(railsApp.getPaths().findFiles("vendor", "plugins"), it -> List.of(it.getChildren())), (Comparator)new VirtualFileUtil.VirtualFilesComparator());
        for (VirtualFile plugin : plugins) {
            VirtualFile pluginLib = plugin.findChild("lib");
            String pluginLibPath = pluginLib != null ? pluginLib.getPath() + "/" : null;
            HelperRefParam.processFiles(project, pluginLib, (Consumer<VirtualFile>)((Consumer)file -> HelperRefParam.handleFile(context, pluginLib, pluginLibPath, file, elementConsumer, filesChecked)));
        }
    }

    protected static boolean processConstantValues(RubyCallArgumentContext context, NotNullFunction<? super Pair<String, String>, Boolean> function) {
        RPsiElement contextValue = context.getArgumentElement();
        if (contextValue instanceof RConstant || contextValue instanceof RSymbol) {
            for (Pair<String, String> pair : CONSTANT_VALUES) {
                if (!"symbol".equals(pair.getSecond()) || !((Boolean)function.fun(pair)).booleanValue()) continue;
                return true;
            }
        }
        if (contextValue instanceof RStringLiteral) {
            for (Pair<String, String> pair : CONSTANT_VALUES) {
                if (!"string".equals(pair.getSecond()) || !((Boolean)function.fun(pair)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static void handleFile(RubyCallArgumentContext context, VirtualFile root, String rootPath, VirtualFile file, Consumer<? super LookupElement> elementConsumer, HashMap<String, Object> filesChecked) {
        ProgressManager.checkCanceled();
        if (root == null) {
            return;
        }
        String relativePath = file.getPath().replaceAll(rootPath, "");
        if (filesChecked.get(relativePath) != null) {
            return;
        }
        String separator = ".rb";
        String variant = NamingConventions.toCamelCase((String)(relativePath.endsWith(".rb") ? relativePath.substring(0, relativePath.length() - ".rb".length()) : relativePath), (Module)context.getModule());
        if (HelperRefParam.containsModule(HelperRefParam.railsApp(context), file, relativePath, variant, filesChecked)) {
            elementConsumer.consume((Object)HelperRefParam.createLookupItem(context, variant, LookupItemType.None, RubyIcons.Rails.ProjectView.HelpersFolder));
        }
    }

    private static boolean containsModule(RailsApp app, VirtualFile file, String path, String variant, HashMap<String, Object> fileChecked) {
        if (file == null) {
            return false;
        }
        fileChecked.put(path, path);
        PsiFile rFile = PsiManager.getInstance((Project)app.getModule().getProject()).findFile(file);
        if (!(rFile instanceof RFile)) {
            return false;
        }
        List<String> modules = RContainerUtil.getAllModulesNames((RContainer)((RFile)rFile));
        for (String moduleName : modules) {
            if (!moduleName.equals(variant)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/HelperRefParam";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/HelperRefParam";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAllVariants";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

