/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.RailsActionsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.MethodRefParam;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsLayoutOrView;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class ControllerMethodRefParam
extends MethodRefParam {
    private final boolean myWarning;

    public ControllerMethodRefParam(Visibility minAccess, boolean showRailsActionsWarning) {
        super("ActionController::Base", minAccess, LookupItemType.Symbol);
        this.myWarning = showRailsActionsWarning;
    }

    @Override
    @Nullable
    protected PsiNamedElement findTargetClass(RubyCallArgumentContext context) {
        Module module = context.getModule();
        if (module != null) {
            RCall contextElement = context.getCall();
            PsiFile file = contextElement.getContainingFile();
            RailsView view = RailsView.fromFile(file);
            RClass controllerClass = ControllerMethodRefParam.getClass(view);
            if (controllerClass != null) {
                return controllerClass;
            }
            RailsLayout layout = RailsLayout.fromFile(file);
            controllerClass = ControllerMethodRefParam.getClass(layout);
            if (controllerClass != null) {
                return controllerClass;
            }
            controllerClass = ControllerMethodRefParam.getControllerClassFromFormForCall(module, contextElement);
            if (controllerClass != null) {
                return controllerClass;
            }
        }
        return super.findTargetClass(context);
    }

    @Nullable
    protected static RClass getClass(RailsLayoutOrView view) {
        if (view == null) {
            return null;
        }
        RailsController controller = view.getController();
        if (controller == null) {
            return null;
        }
        PsiFile file = controller.getPsiFile();
        return RContainerUtil.getFirstClassInFile(file);
    }

    @Override
    protected String warningInspectionMessage(RPsiElement element) {
        return this.myWarning ? RBundle.message((String)"inspection.paramdef.controller_action.warning", (Object[])new Object[]{ParamDef.getTextPresentationForPsiElement(element)}) : super.warningInspectionMessage(element);
    }

    @Nullable
    private static RClass getControllerClassFromFormForCall(@NotNull Module module, @NotNull RCall contextElement) {
        RailsController railsController;
        String controllerClassName;
        if (module == null) {
            ControllerMethodRefParam.$$$reportNull$$$0(0);
        }
        if (contextElement == null) {
            ControllerMethodRefParam.$$$reportNull$$$0(1);
        }
        if (RailsActionsUtil.isFormForCall(contextElement) && (controllerClassName = RailsActionsUtil.getControllerFromFormForCall(contextElement)) != null && (railsController = RailsController.fromName(module, controllerClassName)) != null) {
            return railsController.getRClass();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "contextElement";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/ControllerMethodRefParam";
        objectArray[2] = "getControllerClassFromFormForCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

