/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ModelRefParam;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefImplUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class AssociationRefParam
extends ModelRefParam {
    @Override
    public String handleRename(@NotNull RubyCallArgumentContext context, @NotNull String newName) {
        if (context == null) {
            AssociationRefParam.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            AssociationRefParam.$$$reportNull$$$0(1);
        }
        if (AssociationsUtil.isSingularAssociation(context.getCall())) {
            return NamingConventions.toUnderscoreCase((String)newName, (Module)context.getModule());
        }
        InflectorService inflector = (InflectorService)ObjectUtils.doIfNotNull((Object)context.getModule(), InflectorService::getInstance);
        return inflector != null ? inflector.underscore(inflector.pluralize(newName)) : null;
    }

    @NotNull
    public List<PsiElement> multiResolve(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            AssociationRefParam.$$$reportNull$$$0(2);
        }
        return new ArrayList<RClass>(AssociationsUtil.resolveToModels(context.getCall()));
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            AssociationRefParam.$$$reportNull$$$0(3);
        }
        return (PsiElement)ContainerUtil.getOnlyItem(this.multiResolve(context));
    }

    @Override
    public InspectionResult warningInspection(RubyCallArgumentContext context, RPsiElement element) {
        String message = RBundle.message((String)"inspection.paramdef.association.warning", (Object[])new Object[]{ParamDef.getTextPresentationForPsiElement(element)});
        return InspectionResult.createWarningResult((PsiElement)element, message);
    }

    @Override
    @Nullable
    protected PsiElement resolveReferenceForInspectionHook(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            AssociationRefParam.$$$reportNull$$$0(4);
        }
        return (PsiElement)ContainerUtil.getFirstItem(this.multiResolve(context));
    }

    @Override
    protected String getItemName(RubyCallArgumentContext context, String extension) {
        return AssociationsUtil.isSingularAssociation(context.getCall()) ? extension : StringUtil.pluralize((String)extension);
    }

    @Override
    @Nullable
    protected LookupElement createItem(@NotNull RubyCallArgumentContext context, @NotNull VirtualFile root, @NotNull VirtualFile file, @NotNull Predicate<String> lookupStringFilter) {
        String modelName;
        if (context == null) {
            AssociationRefParam.$$$reportNull$$$0(5);
        }
        if (root == null) {
            AssociationRefParam.$$$reportNull$$$0(6);
        }
        if (file == null) {
            AssociationRefParam.$$$reportNull$$$0(7);
        }
        if (lookupStringFilter == null) {
            AssociationRefParam.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)(modelName = this.getItemName(context, file.getNameWithoutExtension())))) {
            return null;
        }
        if (!Comparing.equal((Object)file, (Object)RubyPsiUtil.getVirtualFileFromElement((PsiElement)context.getCall()))) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
            if (relativePath == null) {
                return null;
            }
            String fileName = FileUtilRt.getNameWithoutExtension((String)relativePath);
            String className = NamingConventions.toCamelCase((String)fileName, (Module)context.getModule());
            if (className.contains("::")) {
                modelName = this.getItemName(context, fileName.replaceAll("/", "_"));
            }
            if (lookupStringFilter.test(modelName)) {
                AssociationInsertHandler insertionHandler = new AssociationInsertHandler(context.getCall(), className);
                return ParamDefImplUtil.createLookupElement(modelName, LookupItemType.Symbol, context.getArgumentElement(), RailsIcons.RAILS_MODEL_ICON, insertionHandler, null);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/AssociationRefParam";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleRename";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "multiResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReferenceForInspectionHook";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AssociationInsertHandler
    implements InsertHandler<LookupElement> {
        private final RCall myCall;
        private final String myClassName;

        private AssociationInsertHandler(@NotNull RCall call, @NotNull String className) {
            if (call == null) {
                AssociationInsertHandler.$$$reportNull$$$0(0);
            }
            if (className == null) {
                AssociationInsertHandler.$$$reportNull$$$0(1);
            }
            this.myCall = call;
            this.myClassName = className;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                AssociationInsertHandler.$$$reportNull$$$0(2);
            }
            if (item == null) {
                AssociationInsertHandler.$$$reportNull$$$0(3);
            }
            Editor editor = context.getEditor();
            int tailOffset = context.getTailOffset();
            if (this.myClassName.contains("::") && AssociationsUtil.resolveToModels(this.myCall).isEmpty()) {
                String insert = ", :class_name => '" + this.myClassName + "'";
                editor.getDocument().insertString(tailOffset, (CharSequence)insert);
                editor.getCaretModel().moveToOffset(tailOffset + insert.length());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/paramDefs/AssociationRefParam$AssociationInsertHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInsert";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

