/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.PsiElementNavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;
import org.jetbrains.plugins.ruby.rails.RailsViewFileTypesProvider;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsNavigateFromProvider;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsMailerTemplate;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubySingleNamedTargetLineMarkerTooltipSupplier;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubySingleTargetGutterIconNavigationHandler;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public final class RailsViewActionLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            RailsViewActionLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            RailsViewActionLineMarkerProvider.$$$reportNull$$$0(1);
        }
        for (PsiElement element : ContainerUtil.filter(elements, it -> it instanceof LeafPsiElement)) {
            PsiFile file = TemplateLanguageUtil.getBaseFile((PsiFile)element.getContainingFile());
            if (!RailsViewActionLineMarkerProvider.isViewFile(file) || !element.equals(PsiTreeUtil.getDeepestFirst((PsiElement)file))) continue;
            ContainerUtil.addIfNotNull(result, RailsViewActionLineMarkerProvider.getLineMarker(file, element));
        }
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            RailsViewActionLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = RubyIcons.Rails.ActionMethod_12x12;
        if (icon == null) {
            RailsViewActionLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @Nullable
    public String getName() {
        return RBundle.message((String)"rails.lineMarker.gutter.view.action");
    }

    @Nullable
    private static LineMarkerInfo<?> getLineMarker(@NotNull PsiFile file, @NotNull PsiElement element) {
        Pair<NavigationTarget, Icon> targetAndIcon;
        if (file == null) {
            RailsViewActionLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            RailsViewActionLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if ((targetAndIcon = RailsViewActionLineMarkerProvider.getNavigationTargetAndIcon(file, element)) == null) {
            return null;
        }
        RubySingleTargetGutterIconNavigationHandler navigationHandler = new RubySingleTargetGutterIconNavigationHandler((NavigationTarget)targetAndIcon.getFirst());
        MyTooltipSupplier tooltipSupplier = new MyTooltipSupplier((NavigationTarget)targetAndIcon.getFirst());
        return new LineMarkerInfo(element, element.getTextRange(), (Icon)targetAndIcon.getSecond(), arg_0 -> RailsViewActionLineMarkerProvider.lambda$getLineMarker$1((Supplier)tooltipSupplier, arg_0), (GutterIconNavigationHandler)navigationHandler, GutterIconRenderer.Alignment.RIGHT, (Supplier)tooltipSupplier);
    }

    @NotNull
    private static Pair<NavigationTarget, Icon> getMethodNavigationTargetAndIcon(@NotNull RMethod method) {
        if (method == null) {
            RailsViewActionLineMarkerProvider.$$$reportNull$$$0(6);
        }
        TargetPresentation presentation = TargetPresentation.builder((String)Objects.requireNonNull(method.getName())).icon(method.getIcon(0)).containerText((String)ObjectUtils.doIfNotNull((Object)method.getParentContainer(), it -> it.getFQNWithNesting().getFullPath())).presentation();
        PsiElementNavigationTarget<RMethod> target = new PsiElementNavigationTarget<RMethod>(method, presentation);
        target.setLinkTextAttributes(RubyHighlighter.IDENTIFIER);
        return new Pair(target, (Object)RubyIcons.Rails.ActionMethod_12x12);
    }

    @Nullable
    private static Pair<NavigationTarget, Icon> getNavigationTargetAndIcon(@NotNull PsiFile file, @NotNull PsiElement element) {
        RailsMailerTemplate mailerView;
        if (file == null) {
            RailsViewActionLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (element == null) {
            RailsViewActionLineMarkerProvider.$$$reportNull$$$0(8);
        }
        if ((mailerView = RailsMailerTemplate.fromFile(file)) != null && mailerView.getMethod() != null) {
            return RailsViewActionLineMarkerProvider.getMethodNavigationTargetAndIcon(mailerView.getMethod());
        }
        for (RailsNavigateFromProvider navigateFromProvider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            RailsAction action = navigateFromProvider.viewOwnerActionBy(element);
            if (action != null && action.getViewOwner().getPsiFile() != file) {
                return RailsViewActionLineMarkerProvider.getMethodNavigationTargetAndIcon(action.getMethod());
            }
            RailsViewOwner owner = navigateFromProvider.viewOwnerBy(element);
            if (owner == null || owner.getPsiFile() == file) continue;
            RClass clazz = owner.getRClass();
            PsiElementNavigationTarget<RClass> target = new PsiElementNavigationTarget<RClass>(clazz, TargetPresentationUtil.createTargetPresentation((NavigatablePsiElement)clazz));
            target.setLinkTextAttributes(RubyHighlighter.CONSTANT);
            Icon icon = owner instanceof RailsMailer ? RubyIcons.Rails.Mailer_14x14 : RubyIcons.Rails.Controller_14x14;
            return new Pair(target, (Object)icon);
        }
        return null;
    }

    private static boolean isViewFile(@NotNull PsiFile file) {
        if (file == null) {
            RailsViewActionLineMarkerProvider.$$$reportNull$$$0(9);
        }
        Language language = file.getLanguage();
        return ContainerUtil.exists((Iterable)RailsViewFileTypesProvider.EP_NAME.getExtensionList(), provider -> provider.getViewLanguages().contains(language));
    }

    private static /* synthetic */ String lambda$getLineMarker$1(Supplier tooltipSupplier, PsiElement __) {
        return (String)tooltipSupplier.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsViewActionLineMarkerProvider";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsViewActionLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNavigationTargetAndIcon";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargetAndIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isViewFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyTooltipSupplier
    extends RubySingleNamedTargetLineMarkerTooltipSupplier {
        private MyTooltipSupplier(@NotNull NavigationTarget target) {
            if (target == null) {
                MyTooltipSupplier.$$$reportNull$$$0(0);
            }
            super(target);
        }

        @Override
        @Nls
        @NotNull
        protected String getOneTooltip() {
            String string = RBundle.message((String)"rails.lineMarker.gutter.view.action.tooltip.one");
            if (string == null) {
                MyTooltipSupplier.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsViewActionLineMarkerProvider$MyTooltipSupplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsViewActionLineMarkerProvider$MyTooltipSupplier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOneTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

