/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.PsiFileSystemItemNavigationTarget;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsMailerMethod;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwnerAction;
import org.jetbrains.plugins.ruby.rails.templates.RailsCreateViewFileDialog;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyGutterIconNavigationHandler;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyLineMarkerProviderDescriptor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyNamedTargetLineMarkerTooltipSupplier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.templates.RubyCreateFileFromTemplateDialog;

public final class RailsControllerViewLineMarkerProvider
extends RubyLineMarkerProviderDescriptor {
    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            RailsControllerViewLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            RailsControllerViewLineMarkerProvider.$$$reportNull$$$0(1);
        }
        for (PsiElement element : ContainerUtil.filter(elements, it -> it instanceof LeafPsiElement && this.canHoldRubyLineMarker((PsiElement)it))) {
            RContainer container = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RClass.class, RMethod.class});
            if (container instanceof RClass) {
                RClass clazz = (RClass)container;
                ContainerUtil.addIfNotNull(result, RailsControllerViewLineMarkerProvider.getClassLineMarker(clazz, element));
                continue;
            }
            if (!(container instanceof RMethod)) continue;
            RMethod method = (RMethod)container;
            ContainerUtil.addIfNotNull(result, RailsControllerViewLineMarkerProvider.getMethodLineMarker(method, element));
        }
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            RailsControllerViewLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Nullable
    public String getName() {
        return RBundle.message((String)"rails.lineMarker.gutter.controller.view");
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = RubyIcons.Rails.AnyType_12x12;
        if (icon == null) {
            RailsControllerViewLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @Nullable
    private static LineMarkerInfo<?> getClassLineMarker(@NotNull RClass clazz, @NotNull PsiElement element) {
        RailsViewOwner viewOwner;
        if (clazz == null) {
            RailsControllerViewLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            RailsControllerViewLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if ((viewOwner = (RailsViewOwner)ObjectUtils.coalesce((Object)RailsController.fromClass(clazz), (Object)RailsMailer.fromClass(clazz))) == null) {
            return null;
        }
        List targets = viewOwner.getViewsFolders().stream().mapMulti((it, consumer) -> {
            NavigationTarget target = (NavigationTarget)ObjectUtils.doIfNotNull((Object)clazz.getManager().findDirectory(it), PsiFileSystemItemNavigationTarget::new);
            if (target != null) {
                consumer.accept(target);
            }
        }).toList();
        if (targets.isEmpty()) {
            return null;
        }
        MyClassNavigationHandler navigationHandler = new MyClassNavigationHandler(targets);
        MyClassTooltipSupplier tooltipSupplier = new MyClassTooltipSupplier(targets);
        return new LineMarkerInfo(element, element.getTextRange(), RubyIcons.Rails.Folder_14x14, arg_0 -> RailsControllerViewLineMarkerProvider.lambda$getClassLineMarker$2((Supplier)tooltipSupplier, arg_0), (GutterIconNavigationHandler)navigationHandler, GutterIconRenderer.Alignment.RIGHT, (Supplier)tooltipSupplier);
    }

    @Nullable
    private static LineMarkerInfo<?> getCreateViewLineMarker(@NotNull RMethod method, @NotNull PsiElement element) {
        if (method == null) {
            RailsControllerViewLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RailsControllerViewLineMarkerProvider.$$$reportNull$$$0(7);
        }
        Project project = method.getProject();
        RailsApp app = RailsApp.fromPsiElement((PsiElement)method);
        if (app == null) {
            return null;
        }
        VirtualFile root = app.getRailsApplicationRoot();
        if (root == null) {
            return null;
        }
        final Ref contentHandledRef = new Ref((Object)false);
        method.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRCall(@NotNull RCall call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RubyPsiUtil.isCallWithCommand((PsiElement)call, "head", "render", "redirect_back", "redirect_to")) {
                    contentHandledRef.set((Object)true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider$1", "visitRCall"));
            }
        });
        if (((Boolean)contentHandledRef.get()).booleanValue()) {
            return null;
        }
        RailsViewOwnerAction action = (RailsViewOwnerAction)ObjectUtils.coalesce((Object)RailsAction.fromMethod(method), (Object)RailsMailerMethod.fromMethod(method));
        if (action == null) {
            return null;
        }
        String prefix = (String)ContainerUtil.getFirstItem(action.getViewOwner().getViewsFolderUrls());
        if (prefix == null) {
            return null;
        }
        String filename = "%s/%s".formatted(FileUtil.getRelativePath((String)root.getUrl(), (String)prefix, (char)'/'), action.getName());
        RubyCreateFileFromTemplateDialog.Builder builder2 = RailsCreateViewFileDialog.builder(project, filename);
        String selectedTemplate = PropertiesComponent.getInstance((Project)project).getValue("RailsCreateViewFileDialog.DEFAULT_TEMPLATE");
        GutterIconNavigationHandler navigationHandler = (event, psi) -> {
            CreateFileFromTemplateDialog.FileCreator<? extends PsiFile> creator = RailsCreateViewFileDialog.fileCreator(project, root);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String template = Objects.requireNonNull(selectedTemplate);
                creator.createFile(RailsCreateViewFileDialog.inputSuggester(filename).getSuggestion(template), template);
                return;
            }
            builder2.show(selectedTemplate, creator, __ -> {});
        };
        Supplier<String> tooltipSupplier = () -> RBundle.message((String)"rails.lineMarker.gutter.controller.view.action.create.tooltip");
        return new LineMarkerInfo(element, element.getTextRange(), RubyIcons.Rails.AddAny_12x12, __ -> (String)tooltipSupplier.get(), navigationHandler, GutterIconRenderer.Alignment.RIGHT, tooltipSupplier);
    }

    @Nullable
    private static LineMarkerInfo<?> getMethodLineMarker(@NotNull RMethod method, @NotNull PsiElement element) {
        RailsMailerMethod mailerMethod;
        if (method == null) {
            RailsControllerViewLineMarkerProvider.$$$reportNull$$$0(8);
        }
        if (element == null) {
            RailsControllerViewLineMarkerProvider.$$$reportNull$$$0(9);
        }
        ArrayList<RailsFileItem> views = new ArrayList<RailsFileItem>();
        RailsAction action = RailsAction.fromMethod(method);
        if (action != null) {
            views.addAll(action.getViews());
        }
        if ((mailerMethod = RailsMailerMethod.fromMethod(method)) != null) {
            views.addAll(mailerMethod.getTemplates());
        }
        if ((action == null || action.getViewOwner().isApplicationController()) && mailerMethod == null) {
            return null;
        }
        List<PsiFileSystemItemNavigationTarget> targets = views.stream().flatMap(it -> Stream.ofNullable(it.getPsiFile())).map(PsiFileSystemItemNavigationTarget::new).toList();
        if (targets.isEmpty()) {
            return RailsControllerViewLineMarkerProvider.getCreateViewLineMarker(method, element);
        }
        MyMethodNavigationHandler navigationHandler = new MyMethodNavigationHandler(targets);
        MyMethodTooltipSupplier tooltipSupplier = new MyMethodTooltipSupplier(targets);
        return new LineMarkerInfo(element, element.getTextRange(), RubyIcons.Rails.AnyType_12x12, arg_0 -> RailsControllerViewLineMarkerProvider.lambda$getMethodLineMarker$8((Supplier)tooltipSupplier, arg_0), (GutterIconNavigationHandler)navigationHandler, GutterIconRenderer.Alignment.RIGHT, (Supplier)tooltipSupplier);
    }

    private static /* synthetic */ String lambda$getMethodLineMarker$8(Supplier tooltipSupplier, PsiElement __) {
        return (String)tooltipSupplier.get();
    }

    private static /* synthetic */ String lambda$getClassLineMarker$2(Supplier tooltipSupplier, PsiElement __) {
        return (String)tooltipSupplier.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClassLineMarker";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCreateViewLineMarker";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMethodLineMarker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyClassNavigationHandler
    extends RubyGutterIconNavigationHandler {
        private MyClassNavigationHandler(@NotNull List<? extends NavigationTarget> targets) {
            if (targets == null) {
                MyClassNavigationHandler.$$$reportNull$$$0(0);
            }
            super(targets);
        }

        @Override
        @Nls
        @NotNull
        protected String getPopupTitle() {
            String string = RBundle.message((String)"rails.lineMarker.gutter.controller.view.title");
            if (string == null) {
                MyClassNavigationHandler.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider$MyClassNavigationHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider$MyClassNavigationHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopupTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyClassTooltipSupplier
    extends RubyNamedTargetLineMarkerTooltipSupplier {
        private MyClassTooltipSupplier(@NotNull List<? extends NavigationTarget> targets) {
            if (targets == null) {
                MyClassTooltipSupplier.$$$reportNull$$$0(0);
            }
            super(targets);
        }

        @Override
        @Nls
        @NotNull
        protected String getFewTooltip() {
            String string = RBundle.message((String)"rails.lineMarker.gutter.controller.view.tooltip.few");
            if (string == null) {
                MyClassTooltipSupplier.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        protected String getManyTooltip() {
            String string = RBundle.message((String)"rails.lineMarker.gutter.controller.view.tooltip.many");
            if (string == null) {
                MyClassTooltipSupplier.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        protected String getOneTooltip() {
            String string = RBundle.message((String)"rails.lineMarker.gutter.controller.view.tooltip.one");
            if (string == null) {
                MyClassTooltipSupplier.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider$MyClassTooltipSupplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider$MyClassTooltipSupplier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFewTooltip";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getManyTooltip";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOneTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyMethodNavigationHandler
    extends RubyGutterIconNavigationHandler {
        private MyMethodNavigationHandler(@NotNull List<? extends NavigationTarget> targets) {
            if (targets == null) {
                MyMethodNavigationHandler.$$$reportNull$$$0(0);
            }
            super(targets);
        }

        @Override
        @Nls
        @NotNull
        protected String getPopupTitle() {
            String string = RBundle.message((String)"rails.lineMarker.gutter.controller.view.action.title");
            if (string == null) {
                MyMethodNavigationHandler.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider$MyMethodNavigationHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider$MyMethodNavigationHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopupTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyMethodTooltipSupplier
    extends RubyNamedTargetLineMarkerTooltipSupplier {
        private MyMethodTooltipSupplier(@NotNull List<? extends NavigationTarget> targets) {
            if (targets == null) {
                MyMethodTooltipSupplier.$$$reportNull$$$0(0);
            }
            super(targets);
        }

        @Override
        @Nls
        @NotNull
        protected String getFewTooltip() {
            String string = RBundle.message((String)"rails.lineMarker.gutter.controller.view.action.tooltip.few");
            if (string == null) {
                MyMethodTooltipSupplier.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        protected String getManyTooltip() {
            String string = RBundle.message((String)"rails.lineMarker.gutter.controller.view.action.tooltip.many");
            if (string == null) {
                MyMethodTooltipSupplier.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        protected String getOneTooltip() {
            String string = RBundle.message((String)"rails.lineMarker.gutter.controller.view.action.tooltip.one");
            if (string == null) {
                MyMethodTooltipSupplier.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider$MyMethodTooltipSupplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsControllerViewLineMarkerProvider$MyMethodTooltipSupplier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFewTooltip";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getManyTooltip";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOneTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

