/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.callTypes;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeBase;

public abstract class RailsStoreCallType
extends RubyCallTypeBase<CallData> {
    public RailsStoreCallType(@NonNls String id) {
        super(id);
    }

    public boolean isCompatible(@NotNull RPossibleCall rPossibleCall) {
        if (rPossibleCall == null) {
            RailsStoreCallType.$$$reportNull$$$0(0);
        }
        return rPossibleCall.getReceiver() instanceof RClass && RubyPsiUtil.isSimpleStringOrSymbol((PsiElement)ContainerUtil.getFirstItem((List)rPossibleCall.getArguments()));
    }

    @NotNull
    public CallData getCallData(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsStoreCallType.$$$reportNull$$$0(1);
        }
        String column = Objects.requireNonNull(RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)ContainerUtil.getFirstItem((List)call.getArguments())));
        String prefix = Optional.ofNullable(RubyInterpretUtil.evaluateOptionValue(call, "prefix")).map(value -> (value.equals("true") ? column : value) + "_").orElse("");
        String suffix = Optional.ofNullable(RubyInterpretUtil.evaluateOptionValue(call, "suffix")).map(value -> "_" + (value.equals("true") ? column : value)).orElse("");
        List keys = (List)ObjectUtils.coalesce(RubyInterpretUtil.evaluateOptionValues(call, "accessors"), Collections.emptyList());
        return new CallData(column, keys, prefix, suffix);
    }

    @NotNull
    public abstract PsiElement getAccessorPsiElement(@NotNull RCall var1, @NotNull String var2);

    @NotNull
    public String getColumnName(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsStoreCallType.$$$reportNull$$$0(2);
        }
        String string = ((CallData)call.getData((RubyCallType[])new RubyCallType[]{this})).myColumn;
        if (string == null) {
            RailsStoreCallType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public List<String> getKeys(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsStoreCallType.$$$reportNull$$$0(4);
        }
        List<String> list = ((CallData)call.getData((RubyCallType[])new RubyCallType[]{this})).myKeys;
        if (list == null) {
            RailsStoreCallType.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public String getAccessorName(@NotNull RPossibleCall call, @NotNull String key) {
        if (call == null) {
            RailsStoreCallType.$$$reportNull$$$0(6);
        }
        if (key == null) {
            RailsStoreCallType.$$$reportNull$$$0(7);
        }
        CallData data = (CallData)call.getData(new RubyCallType[]{this});
        return RailsStoreCallType.getAccessorName(data, key);
    }

    @NotNull
    protected static String getAccessorName(@NotNull CallData data, @NotNull String key) {
        if (data == null) {
            RailsStoreCallType.$$$reportNull$$$0(8);
        }
        if (key == null) {
            RailsStoreCallType.$$$reportNull$$$0(9);
        }
        String string = data.myPrefix + key + data.mySuffix;
        if (string == null) {
            RailsStoreCallType.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isPersistent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPossibleCall";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsStoreCallType";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsStoreCallType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCallData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getColumnName";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKeys";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 10 -> new IllegalStateException(string);
        };
    }

    public static final class CallData {
        @NotNull
        final String myColumn;
        @NotNull
        final List<String> myKeys;
        @NotNull
        final String myPrefix;
        @NotNull
        final String mySuffix;

        CallData(@NotNull String column, @NotNull List<String> keys, @NotNull String prefix, @NotNull String suffix) {
            if (column == null) {
                CallData.$$$reportNull$$$0(0);
            }
            if (keys == null) {
                CallData.$$$reportNull$$$0(1);
            }
            if (prefix == null) {
                CallData.$$$reportNull$$$0(2);
            }
            if (suffix == null) {
                CallData.$$$reportNull$$$0(3);
            }
            this.myColumn = column;
            this.myKeys = List.copyOf(keys);
            this.myPrefix = prefix;
            this.mySuffix = suffix;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallData data = (CallData)o;
            return this.myColumn.equals(data.myColumn) && this.myKeys.equals(data.myKeys) && this.myPrefix.equals(data.myPrefix) && this.mySuffix.equals(data.mySuffix);
        }

        public int hashCode() {
            int result = this.myColumn.hashCode();
            result = 31 * result + this.myKeys.hashCode();
            result = 31 * result + this.myPrefix.hashCode();
            result = 31 * result + this.mySuffix.hashCode();
            return result;
        }

        @NotNull
        public String toString() {
            String string = String.format("MyData{myColumn=%s, myKeys='%s', myPrefix='%s', mySuffix='%s'}", this.myColumn, this.myKeys, this.myPrefix, this.mySuffix);
            if (string == null) {
                CallData.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsStoreCallType$CallData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsStoreCallType$CallData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

