/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.callTypes;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.ClassModuleCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeRegistry;

public final class RailsMigrationCallType
extends ClassModuleCallType {
    public static final RubyCallType<List<FQN>> INSTANCE = new RailsMigrationCallType();
    private static final String ACTIVE_RECORD_MIGRATION = "ActiveRecord::Migration";
    private static final String ACTIVE_RECORD_MIGRATION_COMPATIBILITY = "ActiveRecord::Migration::Compatibility";
    private static final Pattern ARGUMENT_PATTERN = Pattern.compile("^(\\d)\\.(\\d)$");

    private RailsMigrationCallType() {
        super("Migration", "<error>");
    }

    @NotNull
    public String getUniqueName() {
        return "ActiveRecord::Migration[]";
    }

    public boolean isCompatible(@NotNull RPossibleCall possibleCall) {
        if (possibleCall == null) {
            RailsMigrationCallType.$$$reportNull$$$0(0);
        }
        return RubyCallTypeRegistry.hasReceiverWithName((RPossibleCall)possibleCall, (String)"ActiveRecord") && possibleCall instanceof RArrayIndexing && RailsMigrationCallType.getVersion(possibleCall) != null;
    }

    @NotNull
    public List<FQN> getCallData(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsMigrationCallType.$$$reportNull$$$0(1);
        }
        List<FQN> list = Collections.singletonList(FQN.of((String)("ActiveRecord::Migration::Compatibility::" + RailsMigrationCallType.getVersion(call))));
        if (list == null) {
            RailsMigrationCallType.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean canBeArrayIndexing() {
        return true;
    }

    @Nullable
    private static String getVersion(@NotNull RPossibleCall call) {
        if (call == null) {
            RailsMigrationCallType.$$$reportNull$$$0(3);
        }
        if (call.getArguments().size() != 1) {
            return null;
        }
        String argument = ((RPsiElement)call.getArguments().get(0)).getText();
        Matcher matcher = ARGUMENT_PATTERN.matcher(argument);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.replaceAll("V$1_$2");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsMigrationCallType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/RailsMigrationCallType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCallData";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

