/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.callTypes;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.associations.AssociationType;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RTypedSyntheticSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.CallTypeWithStructurePresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypeBase;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtilCore;
import org.jetbrains.plugins.ruby.ruby.presentation.RFieldAttrPresentationUtil;

public class AssociationCallType
extends RubyCallTypeBase<MyData>
implements CallTypeWithStructurePresentation {
    public AssociationCallType(@NotNull String command) {
        if (command == null) {
            AssociationCallType.$$$reportNull$$$0(0);
        }
        super(command);
    }

    @NotNull
    public MyData getCallData(@NotNull RPossibleCall call) {
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(1);
        }
        String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)ContainerUtil.getFirstItem((List)call.getArguments()));
        String as = RubyInterpretUtil.evaluateOptionValue(call, "as");
        String through = RubyInterpretUtil.evaluateOptionValue(call, "through");
        FQN classNameFqn = FQN.ofNullable((String)RubyInterpretUtil.evaluateOptionValue(call, "class_name"));
        String source = RubyInterpretUtil.evaluateOptionValue(call, "source");
        FQN sourceTypeFqn = FQN.ofNullable((String)RubyInterpretUtil.evaluateOptionValue(call, "source_type"));
        boolean polymorphic = "true".equals(RubyInterpretUtil.evaluateOptionValue(call, "polymorphic"));
        return new MyData(name, as, through, classNameFqn, source, sourceTypeFqn, polymorphic);
    }

    @NotNull
    public RPsiElement getStructureViewElement(@NotNull RPossibleCall possibleCall) {
        if (possibleCall == null) {
            AssociationCallType.$$$reportNull$$$0(2);
        }
        RPossibleCall call = possibleCall instanceof RBlockCall ? ((RBlockCall)possibleCall).getCall() : possibleCall;
        String name = ((MyData)call.getData((RubyCallType[])new RubyCallType[]{this})).myName;
        if (call instanceof RCall && name != null) {
            return new MyPsiElement((RCall)call, name, name, (Icon)RFieldAttrPresentationUtil.ATTR_READER_ICON);
        }
        RPossibleCall rPossibleCall = possibleCall;
        if (rPossibleCall == null) {
            AssociationCallType.$$$reportNull$$$0(3);
        }
        return rPossibleCall;
    }

    public boolean isCompatible(@NotNull RPossibleCall call) {
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(4);
        }
        return !call.getArguments().isEmpty();
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean process(@NotNull Processor<? super Symbol> processor, @NotNull Symbol parent, @NotNull RCall call, @Nullable PsiElement invocationPoint) {
        if (processor == null) {
            AssociationCallType.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            AssociationCallType.$$$reportNull$$$0(6);
        }
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(7);
        }
        MyData data = (MyData)call.getData(new RubyCallType[]{this});
        String name = data.myName;
        if (name == null) {
            return true;
        }
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        Icon methodIcon = RContainerPresentationUtilCore.createIconWithAccessSign((Icon)AllIcons.Nodes.Method, (Visibility)Visibility.PUBLIC);
        RType returnType = RailsTypeUtil.createActiveRecordAssociationType(parent, call, invocationPoint);
        symbols.add(AssociationCallType.createSymbol(new MyPsiElement(call, name, name, (Icon)RFieldAttrPresentationUtil.ATTR_READER_ICON), Type.FIELD_READER, parent, returnType));
        symbols.add(AssociationCallType.createSymbol(new MyPsiElement(call, name + "=", name, (Icon)RFieldAttrPresentationUtil.ATTR_WRITER_ICON), Type.FIELD_WRITER, parent, returnType));
        if (this.getAssociationType().isSingular()) {
            if (!data.myPolymorphic) {
                symbols.add(AssociationCallType.createSymbol(new MyPsiElement(call, "build_" + name, name, methodIcon), Type.INSTANCE_METHOD, parent, returnType));
                symbols.add(AssociationCallType.createSymbol(new MyPsiElement(call, "create_" + name, name, methodIcon), Type.INSTANCE_METHOD, parent, returnType));
                symbols.add(AssociationCallType.createSymbol(new MyPsiElement(call, "create_" + name + "!", name, methodIcon), Type.INSTANCE_METHOD, parent, returnType));
            }
            symbols.add(AssociationCallType.createSymbol(new MyPsiElement(call, "reload_" + name, name, methodIcon), Type.INSTANCE_METHOD, parent, returnType));
        } else {
            String singularName = AssociationCallType.getSingularName(name, (PsiElement)call);
            if (singularName != null) {
                RType intArrayType = RTypeFactory.createArrayType(call.getProject(), RTypeFactory.createIntType((PsiElement)call));
                symbols.add(AssociationCallType.createSymbol(new MyPsiElement(call, singularName + "_ids", name, (Icon)RFieldAttrPresentationUtil.ATTR_READER_ICON), Type.FIELD_READER, parent, intArrayType));
                symbols.add(AssociationCallType.createSymbol(new MyPsiElement(call, singularName + "_ids=", name, (Icon)RFieldAttrPresentationUtil.ATTR_WRITER_ICON), Type.FIELD_WRITER, parent, intArrayType));
            }
        }
        for (Symbol symbol : symbols) {
            if (processor.process((Object)symbol)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private AssociationType getAssociationType() {
        AssociationType associationType = AssociationType.get(this.getCommandName());
        if (associationType == null) {
            AssociationCallType.$$$reportNull$$$0(8);
        }
        return associationType;
    }

    @NotNull
    public ItemPresentation getPresentation(final @NotNull RPossibleCall call) {
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(9);
        }
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                String string = (String)ObjectUtils.coalesce((Object)((MyData)call.getData((RubyCallType[])new RubyCallType[]{AssociationCallType.this})).myName, (Object)RBundle.message((String)"ruby.presentation.unknown"));
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getLocationString() {
                String string = TextUtil.wrapInParens((String)RContainerPresentationUtil.getLocation((RPsiElement)call));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AssociationCallType.this.getIcon();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/AssociationCallType$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocationString";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static Symbol createSymbol(@NotNull MyPsiElement declaration, @NotNull Type type, @Nullable Symbol parent, @NotNull RType returnType) {
        if (declaration == null) {
            AssociationCallType.$$$reportNull$$$0(10);
        }
        if (type == null) {
            AssociationCallType.$$$reportNull$$$0(11);
        }
        if (returnType == null) {
            AssociationCallType.$$$reportNull$$$0(12);
        }
        return new RTypedSyntheticSymbol(declaration.getProject(), declaration.getName(), type, parent, returnType, Collections.emptyList(), (PsiElement)declaration);
    }

    @Nullable
    static String getSingularName(@NotNull String name, @Nullable PsiElement context) {
        Module module;
        if (name == null) {
            AssociationCallType.$$$reportNull$$$0(13);
        }
        if ((module = (Module)ObjectUtils.doIfNotNull((Object)context, ModuleUtilCore::findModuleForPsiElement)) != null) {
            InflectorService service = InflectorService.getInstance(module);
            return service != null && service.isInflectorAvailable() ? service.singularize(name) : null;
        }
        return StringUtil.unpluralize((String)name);
    }

    @Nullable
    public static String getName(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(14);
        }
        return (callType = call.getCallType()) instanceof AssociationCallType ? ((MyData)call.getData((RubyCallType[])new RubyCallType[]{(AssociationCallType)callType})).myName : null;
    }

    @Nullable
    public static String getAs(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(15);
        }
        return (callType = call.getCallType()) instanceof AssociationCallType ? ((MyData)call.getData((RubyCallType[])new RubyCallType[]{(AssociationCallType)callType})).myAs : null;
    }

    @Nullable
    public static String getThrough(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(16);
        }
        return (callType = call.getCallType()) instanceof AssociationCallType ? ((MyData)call.getData((RubyCallType[])new RubyCallType[]{(AssociationCallType)callType})).myThrough : null;
    }

    @NotNull
    public static FQN getClassNameFqn(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(17);
        }
        FQN fQN = (callType = call.getCallType()) instanceof AssociationCallType ? ((MyData)call.getData((RubyCallType[])new RubyCallType[]{(AssociationCallType)callType})).myClassNameFqn : FQN.INVALID;
        if (fQN == null) {
            AssociationCallType.$$$reportNull$$$0(18);
        }
        return fQN;
    }

    @Nullable
    public static String getSource(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(19);
        }
        return (callType = call.getCallType()) instanceof AssociationCallType ? ((MyData)call.getData((RubyCallType[])new RubyCallType[]{(AssociationCallType)callType})).mySource : null;
    }

    @NotNull
    public static FQN getSourceTypeFqn(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(20);
        }
        FQN fQN = (callType = call.getCallType()) instanceof AssociationCallType ? ((MyData)call.getData((RubyCallType[])new RubyCallType[]{(AssociationCallType)callType})).mySourceTypeFqn : FQN.INVALID;
        if (fQN == null) {
            AssociationCallType.$$$reportNull$$$0(21);
        }
        return fQN;
    }

    public static boolean isPolymorphic(@NotNull RPossibleCall call) {
        RubyCallType callType;
        if (call == null) {
            AssociationCallType.$$$reportNull$$$0(22);
        }
        return (callType = call.getCallType()) instanceof AssociationCallType && ((MyData)call.getData((RubyCallType[])new RubyCallType[]{(AssociationCallType)callType})).myPolymorphic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 18, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 3: 
            case 8: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/AssociationCallType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/AssociationCallType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureViewElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociationType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNameFqn";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceTypeFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCallData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStructureViewElement";
                break;
            }
            case 3: 
            case 8: 
            case 18: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createSymbol";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSingularName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAs";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getThrough";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClassNameFqn";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSource";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSourceTypeFqn";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPolymorphic";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 18, 21 -> new IllegalStateException(string);
        };
    }

    public static final class MyData {
        @Nullable
        final String myName;
        @Nullable
        final String myAs;
        @Nullable
        final String myThrough;
        @NotNull
        final FQN myClassNameFqn;
        @Nullable
        final String mySource;
        @NotNull
        final FQN mySourceTypeFqn;
        final boolean myPolymorphic;

        MyData(@Nullable String name, @Nullable String as, @Nullable String through, @NotNull FQN classNameFqn, @Nullable String source, @NotNull FQN sourceTypeFqn, boolean polymorphic) {
            if (classNameFqn == null) {
                MyData.$$$reportNull$$$0(0);
            }
            if (sourceTypeFqn == null) {
                MyData.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myAs = as;
            this.myThrough = through;
            this.myClassNameFqn = classNameFqn;
            this.mySource = source;
            this.mySourceTypeFqn = sourceTypeFqn;
            this.myPolymorphic = polymorphic;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MyData data = (MyData)other;
            return this.myPolymorphic == data.myPolymorphic && Objects.equals(this.myName, data.myName) && Objects.equals(this.myAs, data.myAs) && Objects.equals(this.myThrough, data.myThrough) && this.myClassNameFqn.equals(data.myClassNameFqn) && Objects.equals(this.mySource, data.mySource) && this.mySourceTypeFqn.equals(data.mySourceTypeFqn);
        }

        @NotNull
        public String toString() {
            String string = String.format("MyData{myName='%s', myAs='%s', myThrough='%s', myClassNameFqn=%s, mySource='%s', mySourceTypeFqn=%s, myPolymorphic=%s}", this.myName, this.myAs, this.myThrough, this.myClassNameFqn, this.mySource, this.mySourceTypeFqn, this.myPolymorphic);
            if (string == null) {
                MyData.$$$reportNull$$$0(2);
            }
            return string;
        }

        public int hashCode() {
            int result = Objects.hashCode(this.myName);
            result = 31 * result + Objects.hashCode(this.myAs);
            result = 31 * result + Objects.hashCode(this.myThrough);
            result = 31 * result + this.myClassNameFqn.hashCode();
            result = 31 * result + Objects.hashCode(this.mySource);
            result = 31 * result + this.mySourceTypeFqn.hashCode();
            result = 31 * result + Boolean.hashCode(this.myPolymorphic);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classNameFqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceTypeFqn";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/AssociationCallType$MyData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/AssociationCallType$MyData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class MyPsiElement
    extends ArgumentFakePsiElement {
        private final String myNavigationElementName;
        private final Icon myIcon;

        private MyPsiElement(@NotNull RCall call, @NotNull String name, @NotNull String navigationElementName, @NotNull Icon icon) {
            if (call == null) {
                MyPsiElement.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MyPsiElement.$$$reportNull$$$0(1);
            }
            if (navigationElementName == null) {
                MyPsiElement.$$$reportNull$$$0(2);
            }
            if (icon == null) {
                MyPsiElement.$$$reportNull$$$0(3);
            }
            super(call, name);
            this.myNavigationElementName = navigationElementName;
            this.myIcon = icon;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!super.equals(other)) {
                return false;
            }
            MyPsiElement element = (MyPsiElement)((Object)other);
            return this.myNavigationElementName.equals(element.myNavigationElementName) && this.myIcon.equals(element.myIcon);
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                MyPsiElement.$$$reportNull$$$0(4);
            }
            return icon;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getArgumentByName(this.myNavigationElementName);
        }

        @NotNull
        public String getTypeName() {
            String string = RBundle.message((String)"rails.activeRecord.presentation.association.type");
            if (string == null) {
                MyPsiElement.$$$reportNull$$$0(5);
            }
            return string;
        }

        public int hashCode() {
            return (super.hashCode() * 31 + this.myNavigationElementName.hashCode()) * 31 + this.myIcon.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationElementName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/AssociationCallType$MyPsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/callTypes/AssociationCallType$MyPsiElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

