/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.ActiveRecordType;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.StringInquirerType;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.MailerSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsActiveRecordAssociationSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsActiveRecordRelationSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsModelSymbol;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.AttributeAccessorSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.AttributeFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionTypeImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.computable.RSymbolBasedTypeComputable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RSymbolTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyAttrCallTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public final class RailsTypeUtil {
    private RailsTypeUtil() {
    }

    @Nullable
    public static RType createStringInquirerType(@NotNull Symbol symbol) {
        FQN typeName;
        if (symbol == null) {
            RailsTypeUtil.$$$reportNull$$$0(0);
        }
        if (FQN.same((FQN)(typeName = symbol.getFQNWithNesting()), (String)"ActiveSupport::StringInquirer") || FQN.same((FQN)typeName, (String)"ActiveSupport::EnvironmentInquirer")) {
            return new StringInquirerType(symbol);
        }
        return null;
    }

    @Nullable
    public static RType createActiveResourceType(@NotNull Symbol symbol) {
        if (symbol == null) {
            RailsTypeUtil.$$$reportNull$$$0(1);
        }
        if (!(symbol instanceof AttributeAccessorSymbol)) {
            return null;
        }
        AttributeAccessorSymbol attributeSymbol = (AttributeAccessorSymbol)symbol;
        AttributeFakePsiElement element = attributeSymbol.getPsiElement();
        RubyCallType callType = element.getCall().getCallType();
        if (callType != RailsCallTypeProvider.ATTRIBUTE_CALL && callType != RailsCallTypeProvider.STRING_CALL && callType != RailsCallTypeProvider.INTEGER_CALL && callType != RailsCallTypeProvider.FLOAT_CALL) {
            return null;
        }
        return RailsTypeUtil.getActiveResourceSchemaType(element.getProject(), callType, (RPossibleCall)element.getCall());
    }

    @Nullable
    public static RType createActionMailerType(@NotNull Symbol symbol) {
        if (symbol == null) {
            RailsTypeUtil.$$$reportNull$$$0(2);
        }
        if (RailsMailer.isActionMailerClass(symbol)) {
            ClassModuleSymbol clazz = (ClassModuleSymbol)symbol;
            if (clazz instanceof RailsModelSymbol) {
                return new RSymbolTypeImpl((Symbol)clazz);
            }
            RClass container = (RClass)ObjectUtils.tryCast((Object)clazz.getPsiElement(), RClass.class);
            RailsApp app = (RailsApp)ObjectUtils.doIfNotNull((Object)container, RailsApp::fromPsiElement);
            if (app == null) {
                return null;
            }
            return new RSymbolTypeImpl((Symbol)new MailerSymbol(app, container));
        }
        return null;
    }

    @NotNull
    public static RType createActiveRecordRelationType(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            RailsTypeUtil.$$$reportNull$$$0(3);
        }
        Symbol modelSymbol = RailsModelSymbol.createModelSymbol(symbol);
        Symbol relationSymbol = RailsActiveRecordRelationSymbol.createRelationSymbolOf(symbol.getProject(), modelSymbol, invocationPoint);
        if (relationSymbol == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RailsTypeUtil.$$$reportNull$$$0(4);
            }
            return rEmptyType;
        }
        RSymbolTypeImpl relationType = new RSymbolTypeImpl(relationSymbol);
        ActiveRecordType instanceType = ActiveRecordType.createActiveRecordType(modelSymbol);
        if (instanceType == null) {
            RSymbolTypeImpl rSymbolTypeImpl = relationType;
            if (rSymbolTypeImpl == null) {
                RailsTypeUtil.$$$reportNull$$$0(5);
            }
            return rSymbolTypeImpl;
        }
        return new RCollectionTypeImpl((RType)relationType, Collections.singletonList(instanceType));
    }

    @NotNull
    public static RType createActiveRecordAssociationType(@NotNull Symbol symbol, @NotNull RCall associationCall, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            RailsTypeUtil.$$$reportNull$$$0(6);
        }
        if (associationCall == null) {
            RailsTypeUtil.$$$reportNull$$$0(7);
        }
        Symbol associationModelSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)AssociationsUtil.resolveToModel(associationCall));
        ActiveRecordType instanceType = ActiveRecordType.createActiveRecordType(associationModelSymbol);
        if (AssociationsUtil.isSingularAssociation(associationCall)) {
            RType rType = (RType)ObjectUtils.coalesce((Object)((Object)instanceType), (Object)REmptyType.INSTANCE);
            if (rType == null) {
                RailsTypeUtil.$$$reportNull$$$0(8);
            }
            return rType;
        }
        Symbol associationSymbol = RailsActiveRecordAssociationSymbol.createAssociationSymbolOf(symbol.getProject(), AssociationsUtil.getAssociationType(associationCall), associationModelSymbol, invocationPoint);
        if (associationSymbol == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RailsTypeUtil.$$$reportNull$$$0(9);
            }
            return rEmptyType;
        }
        return new RCollectionTypeImpl((RType)new RSymbolTypeImpl(associationSymbol), ContainerUtil.createMaybeSingletonList((Object)((Object)instanceType)));
    }

    @Nullable
    static RType createApplicationType(@NotNull Project project, @Nullable String projectName, @Nullable String typeName) {
        if (project == null) {
            RailsTypeUtil.$$$reportNull$$$0(10);
        }
        if (projectName != null && typeName != null && typeName.equals(projectName + String.valueOf(RubyTokenTypes.tCOLON2) + "Application")) {
            Symbol symbol = SymbolUtil.findConstantByFQN(project, typeName);
            if (symbol == null) {
                return null;
            }
            RSymbolTypeImpl type = new RSymbolTypeImpl(symbol);
            Symbol configurable = SymbolUtil.findConstantByFQN(project, "Rails::Application::Configurable");
            RSymbolTypeImpl configurableType = configurable != null ? new RSymbolTypeImpl(configurable) : null;
            return configurableType != null ? RTypeUtil.intersect((RType)type, (RType)configurableType) : type;
        }
        return null;
    }

    @Nullable
    public static RType getActiveCalculationType(String methodName, RExpression expression, Symbol container) {
        String columnName;
        RCall call = RubyPsiUtil.getCoveringRCall((PsiElement)expression);
        if (call == null) {
            return null;
        }
        List args = call.getArguments();
        boolean isCalculate = "calculate".equals(methodName);
        if (args.isEmpty() || isCalculate && args.size() < 2) {
            return null;
        }
        if (isCalculate) {
            methodName = RubyPsiUtilCore.getElementText((PsiElement)((PsiElement)args.get(0)));
            columnName = RubyPsiUtilCore.getElementText((PsiElement)((PsiElement)args.get(1)));
        } else {
            columnName = RubyPsiUtilCore.getElementText((PsiElement)((PsiElement)args.get(0)));
        }
        Project project = container.getProject();
        if ("count".equals(methodName)) {
            return ActiveRecordType.createTypeByDataType(project, "integer");
        }
        if ("average".equals(methodName)) {
            return RTypeFactory.createTypeByFQN(project, "BigDecimal");
        }
        if (columnName == null) {
            return null;
        }
        Symbol child = Symbol.getSymbolByFilter((Symbol)container, (Predicate)Symbol.Filter.byName((String)columnName).and((Predicate)Symbol.Filter.byType((Type)Type.FIELD_READER)), (PsiElement)expression);
        return child != null ? RTypeFactory.createTypeBySymbol(child) : null;
    }

    static RType getActiveResourceSchemaType(Project project, RubyCallType<?> callType, @NotNull RPossibleCall call) {
        if (call == null) {
            RailsTypeUtil.$$$reportNull$$$0(11);
        }
        if (callType instanceof RubyAttrCallTypeImpl) {
            RubyAttrCallTypeImpl attrCallType = (RubyAttrCallTypeImpl)callType;
            List data = (List)call.getData(new RubyCallType[]{attrCallType});
            if (data.size() > 1) {
                return ActiveRecordType.createTypeByDataType(project, (String)((Pair)data.get(1)).getFirst());
            }
        }
        return ActiveRecordType.createTypeByDataType(project, "string");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsTypeUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associationCall";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsTypeUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActiveRecordRelationType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createActiveRecordAssociationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStringInquirerType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createActiveResourceType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createActionMailerType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createActiveRecordRelationType";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createActiveRecordAssociationType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createApplicationType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActiveResourceSchemaType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static class RailsVersionDependentTypeComputable
    implements RSymbolBasedTypeComputable {
        private final String myRails42Type;

        public RailsVersionDependentTypeComputable(String rails42Type) {
            this.myRails42Type = rails42Type;
        }

        @Override
        @NotNull
        public RType getType(@NotNull Symbol symbol) {
            if (symbol == null) {
                RailsVersionDependentTypeComputable.$$$reportNull$$$0(0);
            }
            RType rType = RTypeFactory.createTypeByFQN(symbol.getProject(), this.myRails42Type);
            if (rType == null) {
                RailsVersionDependentTypeComputable.$$$reportNull$$$0(1);
            }
            return rType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsTypeUtil$RailsVersionDependentTypeComputable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsTypeUtil$RailsVersionDependentTypeComputable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

