/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ControllerSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.HelperSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ImplicitModuleSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ImplicitSymbolHierarchy;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.MailerSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.MigrationSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsClassModuleSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsModelSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ViewSymbol;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsMailer;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.model.RailsPartialView;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.nameConventions.HelpersConventions;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;

public final class RailsSymbolProvider
implements RubySymbolProvider {
    @NonNls
    public static final String HELPER_CALL_ALL_ATTR = "all";
    public static final String ACTION_CONTROLLER_BASE = "ActionController::Base";
    public static final String ACTION_MAILER_BASE = "ActionMailer::Base";
    public static final FQN ACTION_CONTROLLER_BASE_FQN = FQN.of((String)"ActionController::Base");
    public static final FQN ACTION_MAILER_BASE_FQN = FQN.of((String)"ActionMailer::Base");
    public static final String ROUTES_URL_SUFFIX = "_url";
    public static final String ROUTES_PATH_SUFFIX = "_path";

    @Override
    @Nullable
    public Symbol findSymbol(@NotNull Symbol anchor, @NotNull FQN fqn, @NotNull TypeSet types, @Nullable PsiElement invocationPoint) {
        if (anchor == null) {
            RailsSymbolProvider.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            RailsSymbolProvider.$$$reportNull$$$0(1);
        }
        if (types == null) {
            RailsSymbolProvider.$$$reportNull$$$0(2);
        }
        if (!types.contains(Type.MODULE)) {
            return null;
        }
        Module module = anchor.getModule();
        if (module == null) {
            return null;
        }
        RailsApp app = RailsApp.fromModule(module);
        if (app == null) {
            return null;
        }
        if (RubyFQNUtil.findContainerByFQN(module.getProject(), types, fqn, invocationPoint) != null) {
            return null;
        }
        ImplicitSymbolHierarchy hierarchy = app.getImplicitSymbolHierarchy();
        if (hierarchy.hasFqn(fqn)) {
            return new ImplicitModuleSymbol(module, fqn);
        }
        return null;
    }

    @Override
    public ContextImpl getAccessContext(@NotNull PsiElement element) {
        RModule module;
        RPsiElement rPsiElement;
        if (element == null) {
            RailsSymbolProvider.$$$reportNull$$$0(3);
        }
        if ((rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)element)) == null) {
            return null;
        }
        RailsApp app = RailsApp.fromPsiElement(element);
        if (app == null) {
            return null;
        }
        RClass clazz = RubyPsiUtil.getContainingRClass(element);
        if (clazz != null && "Application".equals(clazz.getName()) && (module = RubyPsiUtil.getContainingRModule((PsiElement)clazz)) != null && StringUtil.equals((CharSequence)module.getName(), (CharSequence)app.getProjectName())) {
            return ContextImpl.INSTANCE;
        }
        Symbol scopeContext = SymbolUtil.getScopeContextWithCaching(element);
        if (ContextImpl.getPsiContext(element) == ContextImpl.INSTANCE_PRIVATE && scopeContext instanceof RailsClassModuleSymbol || scopeContext instanceof ViewSymbol) {
            return RailsContext.getInstance();
        }
        RCodeBlock block = (RCodeBlock)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, RCodeBlock.class);
        if (RailsSymbolProvider.isSchemaBlock(block)) {
            return ContextImpl.INSTANCE;
        }
        if (RailsSymbolProvider.isConfigBlock(block, app)) {
            return ContextImpl.INSTANCE;
        }
        if (RailsSymbolProvider.isBeforeOrAfterCreate(clazz, block)) {
            return ContextImpl.INSTANCE;
        }
        RLambda lambda = (RLambda)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, RLambda.class);
        if (RailsSymbolProvider.isBeforeOrAfterCreate(clazz, lambda)) {
            return ContextImpl.INSTANCE;
        }
        if (RailsSymbolProvider.isWithArgument(lambda)) {
            return ContextImpl.INSTANCE;
        }
        return null;
    }

    private static boolean isBeforeOrAfterCreate(@Nullable RClass clazz, @Nullable RCodeBlock block) {
        if (block != null) {
            String name;
            RBlockCall parent = block.getBlockCall();
            String string = name = parent != null ? parent.getCall().getName() : null;
            if (name != null && RailsModel.CALLBACKS.contains(name)) {
                return RailsModel.fromClass(clazz) != null;
            }
        }
        return false;
    }

    private static boolean isBeforeOrAfterCreate(@Nullable RClass clazz, @Nullable RLambda lambda) {
        RCall parentCall;
        String command;
        if (lambda != null && (command = (String)ObjectUtils.doIfNotNull((Object)(parentCall = (RCall)PsiTreeUtil.getParentOfType((PsiElement)lambda, RCall.class)), RCall::getCommand)) != null && RailsModel.CALLBACKS.contains(command)) {
            return RailsModel.fromClass(clazz) != null;
        }
        return false;
    }

    private static boolean isWithArgument(@Nullable RLambda lambda) {
        if (lambda == null) {
            return false;
        }
        RAssoc assoc = (RAssoc)PsiTreeUtil.getParentOfType((PsiElement)lambda, RAssoc.class);
        if (assoc == null || !assoc.getKeyText().equals("with")) {
            return false;
        }
        if (RailsApp.fromPsiElement((PsiElement)lambda) == null) {
            return false;
        }
        RCall parentCall = RCallNavigator.getByRArgument((PsiElement)assoc);
        if (parentCall == null) {
            return false;
        }
        return parentCall.getCommand().equals("rescue_from") || parentCall.getCommand().equals("rate_limit");
    }

    private static boolean isConfigBlock(@Nullable RCodeBlock block, @NotNull RailsApp app) {
        if (app == null) {
            RailsSymbolProvider.$$$reportNull$$$0(4);
        }
        if (block != null) {
            RBlockCall parent = block.getBlockCall();
            for (VirtualFile root : app.getPaths().findFiles("config/environments")) {
                VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)block);
                if (parent == null || virtualFile == null || !Comparing.equal((Object)virtualFile.getParent(), (Object)root)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSchemaBlock(@Nullable RCodeBlock block) {
        RBlockCall blockCall = (RBlockCall)ObjectUtils.tryCast((Object)PsiTreeUtil.getStubOrPsiParent((PsiElement)block), RBlockCall.class);
        return blockCall != null && "schema".equals(blockCall.getCommand());
    }

    @Override
    public Symbol getSymbolScope(@NotNull PsiElement element) {
        boolean isEnvironment;
        RailsApp app;
        if (element == null) {
            RailsSymbolProvider.$$$reportNull$$$0(5);
        }
        if ((app = RailsApp.fromPsiElement(element)) == null) {
            return null;
        }
        RElementWithFQN context = SymbolUtil.getContextContainer(element);
        Symbol railsSymbol = RailsSymbolProvider.getSpecificSymbol(app, context);
        if (railsSymbol != null) {
            return railsSymbol;
        }
        List<VirtualFile> schemaFiles = app.getPaths().findFilesByAnyPath("db", "schema.rb", "queue_schema.rb", "cache_schema.rb", "cable_schema.rb");
        VirtualFile file = RubyPsiUtil.getVirtualFileFromElement(element);
        boolean couldBeModel = file != null && VfsUtilCore.isUnderFiles((VirtualFile)file, app.getPaths().findFiles("app/models"));
        boolean bl = isEnvironment = file != null && file.getParent() != null && app.getPaths().findFiles("config/environments").contains(file.getParent());
        if (!(app.getRoutesFiles().contains(file) || schemaFiles.contains(file) || couldBeModel || isEnvironment)) {
            return null;
        }
        if (file != null && app.getRoutesFiles().getAdditionalRoutesFiles().contains(file)) {
            return SymbolUtil.findConstantByFQN(app.getProject(), Type.CLASS, FQN.of((String)"ActionDispatch::Routing::Mapper"), null);
        }
        RCodeBlock block = (RCodeBlock)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, RCodeBlock.class);
        if (block == null) {
            return null;
        }
        Project project = app.getProject();
        if (app.getRoutesFiles().contains(file)) {
            return SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.of((String)"ActionDispatch::Routing::Mapper"), null);
        }
        if (schemaFiles.contains(file)) {
            return SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.of((String)"ActiveRecord::ConnectionAdapters::AbstractAdapter"), null);
        }
        if (RailsSymbolProvider.isSchemaBlock(block)) {
            return SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.of((String)"ActiveResource::Schema"), null);
        }
        if (RailsSymbolProvider.isConfigBlock(block, app) && app.getProjectName() != null) {
            return SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.of((String)(app.getProjectName() + "::Application")), null);
        }
        return null;
    }

    @Nullable
    private static Symbol getSpecificSymbol(@NotNull RailsApp app, @NotNull RElementWithFQN context) {
        if (app == null) {
            RailsSymbolProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            RailsSymbolProvider.$$$reportNull$$$0(7);
        }
        if (context instanceof RTopLevelContainer && StringUtil.isEmpty((String)context.getName())) {
            PsiFile file = context.getContainingFile();
            RailsView view = RailsView.fromFile(file);
            view = view == null ? RailsLayout.fromFile(file) : view;
            RailsFileItem railsFileItem = view = view == null ? RailsPartialView.fromFile(file) : view;
            if (view != null) {
                return new ViewSymbol(view, (RTopLevelContainer)context);
            }
        }
        if (context instanceof RClass) {
            RClass rClass = (RClass)context;
            if (RailsController.fromClass(rClass, app) != null) {
                return new ControllerSymbol(app, rClass);
            }
            if (!app.isVendorGemFile(rClass.getContainingFile()) && ActiveRecordModel.isActiveRecordClass(rClass)) {
                return new RailsModelSymbol(app, rClass);
            }
            Symbol originalSymbol = SymbolUtil.getSymbolByContainer(context);
            if (originalSymbol != null) {
                if (RailsMailer.isActionMailerClass(originalSymbol)) {
                    return new MailerSymbol(app, rClass);
                }
                if (RailsSymbolProvider.isMigration(originalSymbol)) {
                    return new MigrationSymbol(app, rClass);
                }
            }
        } else if (context instanceof RModule) {
            RModule rModule = (RModule)context;
            if (HelpersConventions.isHelperModule(app.getModule(), rModule)) {
                return new HelperSymbol(app, rModule);
            }
        } else if (context instanceof RFile) {
            RFile file = (RFile)context;
            RailsView view = RailsView.fromFile((PsiFile)file);
            view = view == null ? RailsLayout.fromFile((PsiFile)file) : view;
            RailsFileItem railsFileItem = view = view == null ? RailsPartialView.fromFile((PsiFile)file) : view;
            if (view != null) {
                return new ViewSymbol(view, (RTopLevelContainer)file);
            }
        }
        return null;
    }

    @Override
    public boolean processDynamicSymbols(@NotNull Symbol symbol, @Nullable RPsiElement element, @NotNull FQN fqn, @NotNull SymbolPsiProcessor processor, @Nullable PsiElement invocationPoint) {
        RailsApp app;
        if (symbol == null) {
            RailsSymbolProvider.$$$reportNull$$$0(8);
        }
        if (fqn == null) {
            RailsSymbolProvider.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            RailsSymbolProvider.$$$reportNull$$$0(10);
        }
        if ((app = (RailsApp)ObjectUtils.doIfNotNull((Object)element, RailsApp::fromPsiElement)) != null && RailsSymbolProvider.isTest(symbol)) {
            return RailsClassModuleSymbol.processNamedRoutes((Processor<? super Symbol>)processor, symbol, app);
        }
        return true;
    }

    private static boolean isMigration(@NotNull Symbol symbol) {
        if (symbol == null) {
            RailsSymbolProvider.$$$reportNull$$$0(11);
        }
        return SymbolHierarchy.isInheritor(symbol, FQN.of((String)"ActiveRecord::Migration"), null);
    }

    private static boolean isTest(@NotNull Symbol symbol) {
        if (symbol == null) {
            RailsSymbolProvider.$$$reportNull$$$0(12);
        }
        return SymbolHierarchy.isInheritor(symbol, FQN.of((String)"ActiveController::TestCase"), null) || SymbolHierarchy.isInheritor(symbol, FQN.of((String)"ActiveSupport::TestCase"), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsSymbolProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAccessContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigBlock";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSymbolScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpecificSymbol";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processDynamicSymbols";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isMigration";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isTest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RailsContext
    extends ContextImpl {
        private static RailsContext ourInstance;

        @NotNull
        public static RailsContext getInstance() {
            if (ourInstance == null) {
                ourInstance = new RailsContext();
            }
            RailsContext railsContext = ourInstance;
            if (railsContext == null) {
                RailsContext.$$$reportNull$$$0(0);
            }
            return railsContext;
        }

        private RailsContext() {
            super(Visibility.PRIVATE, Access.INSTANCE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/rails/codeInsight/RailsSymbolProvider$RailsContext", "getInstance"));
        }
    }
}

