/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.erb.psi.impl.ErbCommentImpl;
import org.jetbrains.plugins.ruby.erb.psi.impl.ErbElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.findUsages.RubySearchableFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RailsStrictLocalsUtil {
    @NotNull
    private static final Pattern EMPTY_ARGUMENTS_PATTERN = Pattern.compile("^\\(\\s*\\)$");
    @NotNull
    private static final Pattern LOCALS_PATTERN = Pattern.compile("^\\s+locals:\\s+\\((.*)\\).*");

    private RailsStrictLocalsUtil() {
    }

    @NotNull
    public static Map<String, PsiElement> collectStrictLocalsDeclarations(@Nullable PsiElement strictLocalsComment, @NotNull RFile psiFile) {
        int localsArgumentListStart;
        if (psiFile == null) {
            RailsStrictLocalsUtil.$$$reportNull$$$0(0);
        }
        if (strictLocalsComment == null) {
            Map<String, PsiElement> map = Collections.emptyMap();
            if (map == null) {
                RailsStrictLocalsUtil.$$$reportNull$$$0(1);
            }
            return map;
        }
        String commentText = strictLocalsComment.getText();
        for (localsArgumentListStart = commentText.indexOf(40) + 1; localsArgumentListStart < commentText.lastIndexOf(41) && Character.isSpaceChar(commentText.charAt(localsArgumentListStart)); ++localsArgumentListStart) {
        }
        RCall call = RailsStrictLocalsUtil.createFakeStrictLocalsCall(commentText, (PsiFile)psiFile);
        if (call == null) {
            Map<String, PsiElement> map = Collections.emptyMap();
            if (map == null) {
                RailsStrictLocalsUtil.$$$reportNull$$$0(2);
            }
            return map;
        }
        HashMap<String, PsiElement> declarations = new HashMap<String, PsiElement>();
        for (RPsiElement argument : call.getArguments()) {
            if (!(argument instanceof RAssoc)) continue;
            RAssoc assoc = (RAssoc)argument;
            String name = assoc.getKeyText();
            int offset = localsArgumentListStart + argument.getStartOffsetInParent();
            declarations.put(name, (PsiElement)new MyStrictLocalFakePsiElement(strictLocalsComment, name, offset, psiFile));
        }
        HashMap<String, PsiElement> hashMap = declarations;
        if (hashMap == null) {
            RailsStrictLocalsUtil.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @Nullable
    public static PsiElement getStrictLocalsComment(@NotNull PsiFile psiFile, final @NotNull Class<?> commentClass, final @NotNull Function<PsiElement, String> commentTextExtractor) {
        if (psiFile == null) {
            RailsStrictLocalsUtil.$$$reportNull$$$0(4);
        }
        if (commentClass == null) {
            RailsStrictLocalsUtil.$$$reportNull$$$0(5);
        }
        if (commentTextExtractor == null) {
            RailsStrictLocalsUtil.$$$reportNull$$$0(6);
        }
        final Ref commentRef = new Ref(null);
        PsiRecursiveElementVisitor strictLocalsCommentVisitor = new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!commentRef.isNull()) {
                    return;
                }
                if (commentClass.isInstance(element)) {
                    String commentText = (String)commentTextExtractor.apply(element);
                    if (commentText != null && LOCALS_PATTERN.matcher(commentText).find()) {
                        commentRef.set((Object)element);
                    }
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/rails/codeInsight/RailsStrictLocalsUtil$1", "visitElement"));
            }
        };
        psiFile.accept((PsiElementVisitor)strictLocalsCommentVisitor);
        return (PsiElement)commentRef.get();
    }

    @Nullable
    private static RCall createFakeStrictLocalsCall(@NotNull String strictLocalsCommentText, @NotNull PsiFile containingFile) {
        String localsArguments;
        if (strictLocalsCommentText == null) {
            RailsStrictLocalsUtil.$$$reportNull$$$0(7);
        }
        if (containingFile == null) {
            RailsStrictLocalsUtil.$$$reportNull$$$0(8);
        }
        if (EMPTY_ARGUMENTS_PATTERN.matcher(localsArguments = strictLocalsCommentText.substring(strictLocalsCommentText.indexOf(40), strictLocalsCommentText.lastIndexOf(41) + 1)).find()) {
            return null;
        }
        String localsPseudoCall = "locals" + localsArguments;
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)containingFile);
        if (languageLevel == null) {
            return null;
        }
        RPsiElement parsedLocals = RubyElementFactoryCore.createElementFromText((Project)containingFile.getProject(), (String)localsPseudoCall, (LanguageLevel)languageLevel);
        return (RCall)ObjectUtils.tryCast((Object)parsedLocals, RCall.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsStrictLocalsUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentTextExtractor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strictLocalsCommentText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsStrictLocalsUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectStrictLocalsDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectStrictLocalsDeclarations";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStrictLocalsComment";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFakeStrictLocalsCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class MyStrictLocalFakePsiElement
    extends FakePsiElement
    implements RubySearchableFakePsiElement,
    RPsiElement,
    PsiMetaOwner,
    PsiPresentableMetaData {
        @NotNull
        private final PsiElement myParent;
        @NotNull
        private final String myName;
        private final int myOffsetInParent;
        @NotNull
        private final RFile myContainingFile;

        private MyStrictLocalFakePsiElement(@NotNull PsiElement parent, @NotNull String name, int offsetInParent, @NotNull RFile containingFile) {
            if (parent == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(1);
            }
            if (containingFile == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(2);
            }
            this.myParent = parent;
            this.myName = name;
            this.myOffsetInParent = offsetInParent;
            this.myContainingFile = containingFile;
        }

        @NotNull
        public PsiElement getParent() {
            PsiElement psiElement = this.myParent;
            if (psiElement == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        @NotNull
        public SearchScope getUseScope() {
            return new LocalSearchScope((PsiElement)this.myContainingFile);
        }

        public int getStartOffsetInParent() {
            return this.myOffsetInParent;
        }

        public int getTextOffset() {
            return this.myParent.getTextOffset() + this.getStartOffsetInParent();
        }

        @Nullable
        public TextRange getTextRange() {
            return TextRange.create((int)this.getTextOffset(), (int)(this.getTextOffset() + this.getTextLength()));
        }

        @Nullable
        public String getText() {
            return this.myName;
        }

        public PsiElement getDeclaration() {
            return this;
        }

        @NotNull
        public String getName(@Nullable PsiElement context) {
            String string = this.myName;
            if (string == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void init(PsiElement element) {
        }

        public int getTextLength() {
            return this.myName.length();
        }

        public boolean isReadWriteAccessible() {
            return true;
        }

        @NotNull
        public Language getLanguage() {
            RubyLanguage rubyLanguage = RubyLanguage.INSTANCE;
            if (rubyLanguage == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(6);
            }
            return rubyLanguage;
        }

        @Nullable
        public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(7);
            }
            String originalText = this.myParent.getText();
            String newText = originalText.substring(0, this.myOffsetInParent) + name + originalText.substring(this.myOffsetInParent + this.myName.length());
            PsiElement newComment = PsiTreeUtil.findChildOfType((PsiElement)ErbElementFactory.createErbFile(this.myContainingFile.getProject(), newText), ErbCommentImpl.class);
            if (newComment == null) {
                return null;
            }
            this.myParent.replace(newComment);
            return new MyStrictLocalFakePsiElement(newComment, name, this.myOffsetInParent, this.myContainingFile);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
                return false;
            }
            MyStrictLocalFakePsiElement element = (MyStrictLocalFakePsiElement)((Object)other);
            return this.myParent.equals(element.myParent) && this.myName.equals(element.myName) && this.myOffsetInParent == element.myOffsetInParent;
        }

        public int hashCode() {
            int result = this.myParent.hashCode();
            result = 31 * result + this.myName.hashCode();
            result = 31 * result + this.myOffsetInParent;
            return result;
        }

        @NotNull
        public RContainer getParentContainer() {
            RFile rFile = this.myContainingFile;
            if (rFile == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(8);
            }
            return rFile;
        }

        @NotNull
        public GlobalSearchScope getResolveScope() {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)this.myContainingFile);
            if (globalSearchScope == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(9);
            }
            return globalSearchScope;
        }

        @Nullable
        public LanguageLevel getLanguageLevel() {
            return this.myContainingFile.getLanguageLevel();
        }

        @NotNull
        public PsiMetaData getMetaData() {
            MyStrictLocalFakePsiElement myStrictLocalFakePsiElement = this;
            if (myStrictLocalFakePsiElement == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(10);
            }
            return myStrictLocalFakePsiElement;
        }

        @Nls
        @NotNull
        public String getTypeName() {
            String string = RBundle.message((String)"local.variable");
            if (string == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(11);
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Nodes.Variable;
            if (icon == null) {
                MyStrictLocalFakePsiElement.$$$reportNull$$$0(12);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 8, 9, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsStrictLocalsUtil$MyStrictLocalFakePsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsStrictLocalsUtil$MyStrictLocalFakePsiElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentContainer";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolveScope";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaData";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeName";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }
}

