/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsModelFieldsProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.RailsStoreCallType;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.RailsStoreStoreCallType;
import org.jetbrains.plugins.ruby.rails.codeInsight.indexes.RailsStoreAccessorIndex;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsActiveRecordAttributeSymbol;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsModelSymbol;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RailsStoreAccessorModelFieldsProvider
implements RailsModelFieldsProvider {
    private static final Set<String> ATTRIBUTE_SUFFIXES = Set.of("=", "_changed?", "_change", "_was", "_before_last_save");
    private static final Set<String> ATTRIBUTE_PREFIXES = Set.of("saved_change_to_");

    @Override
    @NotNull
    public List<? extends Symbol> getFieldsSymbols(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            RailsStoreAccessorModelFieldsProvider.$$$reportNull$$$0(0);
        }
        if (!(symbol instanceof RailsModelSymbol)) {
            List list = Collections.emptyList();
            if (list == null) {
                RailsStoreAccessorModelFieldsProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        RailsModelSymbol modelSymbol = (RailsModelSymbol)symbol;
        Project project = symbol.getProject();
        GlobalSearchScope searchScope = symbol.getPsiElement().getResolveScope();
        ArrayList storeCalls = new ArrayList();
        for (String key : RailsStoreAccessorIndex.getInstance().getAllKeys(project)) {
            Collection elements = RailsStoreAccessorIndex.getInstance().getElements(project, (SearchScope)searchScope, key);
            storeCalls.addAll(ContainerUtil.filter((Collection)elements, it -> RailsStoreAccessorModelFieldsProvider.isCallInModel(it, modelSymbol.getPsiElement())));
        }
        ArrayList<? extends Symbol> symbols = new ArrayList<Symbol>();
        for (RPsiElement element : storeCalls) {
            if (!(element instanceof RCall)) continue;
            RCall call = (RCall)element;
            RailsStoreCallType callType = (RailsStoreCallType)call.getCallType();
            List<String> keys = callType.getKeys((RPossibleCall)call);
            for (String key : keys) {
                PsiElement accessorElement = callType.getAccessorPsiElement(call, key);
                String name = callType.getAccessorName((RPossibleCall)call, key);
                List<? extends Symbol> attributeSymbols = RailsActiveRecordAttributeSymbol.createAttributeSymbolsOf(project, (Symbol)modelSymbol, callType.getAccessorName((RPossibleCall)call, key), null, accessorElement, accessorElement, modelSymbol.getAttributeMethods(invocationPoint));
                symbols.addAll(ContainerUtil.filter(attributeSymbols, s -> s.getName() != null && (ContainerUtil.exists(ATTRIBUTE_SUFFIXES, suffix -> s.getName().equals(name + suffix)) || ContainerUtil.exists(ATTRIBUTE_PREFIXES, prefix -> s.getName().startsWith(prefix + name)))));
            }
            if (!((Object)((Object)callType)).equals((Object)RailsStoreStoreCallType.STORE)) continue;
            String column = callType.getColumnName((RPossibleCall)call);
            PsiElement accessorElement = callType.getAccessorPsiElement(call, column);
            symbols.addAll(RailsActiveRecordAttributeSymbol.createAttributeSymbolsOf(project, (Symbol)modelSymbol, column, null, accessorElement, accessorElement, modelSymbol.getAttributeMethods(invocationPoint)));
        }
        ArrayList<? extends Symbol> arrayList = symbols;
        if (arrayList == null) {
            RailsStoreAccessorModelFieldsProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean isCallInModel(@NotNull RCall call, @NotNull RClass modelClass) {
        RClass callModelClass;
        if (call == null) {
            RailsStoreAccessorModelFieldsProvider.$$$reportNull$$$0(3);
        }
        if (modelClass == null) {
            RailsStoreAccessorModelFieldsProvider.$$$reportNull$$$0(4);
        }
        if ((callModelClass = (RClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)call, RClass.class)) == null) {
            return false;
        }
        RClass currentModel = modelClass;
        while (currentModel != null && !callModelClass.getFQNWithNesting().equals(currentModel.getFQNWithNesting())) {
            currentModel = ActiveRecordModel.getParentModel(currentModel);
        }
        return currentModel != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsStoreAccessorModelFieldsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsStoreAccessorModelFieldsProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsSymbols";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCallInModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

