/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.CreateTableForceParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.RailsParamDefUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ValidatesKeysProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefExpressionConvertable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefProviderBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyHashParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;

public final class RailsParamDefProvider
extends ParamDefProviderBase {
    private static final List<String> CONTROLLER_CALLBACKS = List.of("after_action", "append_after_action", "append_around_action", "append_before_action", "around_action", "before_action", "prepend_after_action", "prepend_around_action", "prepend_before_action", "skip_action", "skip_after_action", "skip_before_action");
    private static final List<String> MODEL_CALCULATORS = List.of("average", "calculate", "count", "maximum", "minimum", "pick", "pluck", "sum");
    private static final List<String> MODEL_CALLBACKS = List.of("after_create", "after_destroy", "after_find", "after_initialize", "after_save", "after_update", "after_validation", "after_validation_on_create", "after_validation_on_update", "before_create", "before_destroy", "before_save", "before_update", "before_validation", "before_validation_on_create", "before_validation_on_update");
    private static final List<String> MODEL_VALIDATIONS = List.of("validates_acceptance_of", "validates_associated", "validates_confirmation_of", "validates_exclusion_of", "validates_format_of", "validates_inclusion_of", "validates_length_of", "validates_numericality_of", "validates_presence_of", "validates_size_of", "validates_uniqueness_of");

    @Override
    protected void registerParamDefs() {
        this.registerRailsParamDefs();
        this.registerRails3ParamDefs();
        this.registerRails4ParamDefs();
        this.registerRails5_1Paramdefs();
        this.registerRails6ParamDefs();
        this.registerRails8ParamDefs();
        this.registerActiveRecordConnectionAdaptersDatabaseStatements();
        this.registerActiveRecordConnectionAdaptersQueryCache();
        this.registerActiveRecordFinderMethods();
        this.registerActiveRecordQueryMethods();
        this.registerActiveRecordQuerying();
        this.registerActiveRecordRelation();
        this.registerActiveRecordRelationDeprecatedMethods();
        this.registerArel();
    }

    private void registerRails8ParamDefs() {
        this.register(FQN.of((String)"ActionController::RateLimiting::ClassMethods"), registrar -> {
            registrar.define("rate_limit", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("only"), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.standardControllerAction())).add(ParamDefExpressionUtil.s("except"), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.standardControllerAction())));
            registrar.highlight("rate_limit");
        });
        this.register(FQN.of((String)"ActionController::AllowBrowser::ClassMethods"), registrar -> {
            registrar.define("allow_browser", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("versions"), ParamDefExpressionUtil.either(ParamDefExpressionUtil.s("modern"), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("safari"), null).add(ParamDefExpressionUtil.s("chrome"), null).add(ParamDefExpressionUtil.s("firefox"), null).add(ParamDefExpressionUtil.s("opera"), null).add(ParamDefExpressionUtil.s("ie"), null))).add(ParamDefExpressionUtil.s("only"), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.standardControllerAction())).add(ParamDefExpressionUtil.s("except"), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.standardControllerAction())));
            registrar.highlight("allow_browser");
        });
    }

    private void registerRails6ParamDefs() {
        this.paramDef("ActionMailbox::Callbacks::$$ANON$class_methods$$", "before_processing", ParamDefExpressionUtil.array(ParamDefExpressionUtil.methodRef("ActionMailbox::Base")));
        this.paramDef("ActionMailbox::Callbacks::$$ANON$class_methods$$", "after_processing", ParamDefExpressionUtil.array(ParamDefExpressionUtil.methodRef("ActionMailbox::Base")));
        this.paramDef("ActionMailbox::Callbacks::$$ANON$class_methods$$", "around_processing", ParamDefExpressionUtil.array(ParamDefExpressionUtil.methodRef("ActionMailbox::Base")));
        this.paramDef("ActionMailbox::Routing::$$ANON$class_methods$$", "routing", ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.any(), RailsParamDefUtil.mailboxRef()));
        this.paramDef("ActiveRecord::QueryMethods", "extract_associated", false, RailsParamDefUtil.usedAssociationRef());
        this.paramDef("ActiveRecord::QueryMethods", "reselect", false, ParamDefExpressionUtil.array(ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.string("SQL", "SELECT ", " FROM ${table_name};"))));
        this.paramDef("ActiveRecord::Relation", "touch_all", false, ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("time"), ParamDefExpressionUtil.any()));
        this.paramDef("ActiveRecord::Persistence::ClassMethods", "insert", false, ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("unique_by"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())).add(ParamDefExpressionUtil.s("returning"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())));
        this.paramDef("ActiveRecord::Persistence::ClassMethods", "insert!", false, ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("returning"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())));
        this.paramDef("ActiveRecord::Persistence::ClassMethods", "insert_all", false, ParamDefExpressionUtil.arrayOf(ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("unique_by"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())).add(ParamDefExpressionUtil.s("returning"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())));
        this.paramDef("ActiveRecord::Persistence::ClassMethods", "insert_all!", false, ParamDefExpressionUtil.arrayOf(ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("unique_by"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())).add(ParamDefExpressionUtil.s("returning"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())));
        this.paramDef("ActiveRecord::Persistence::ClassMethods", "upsert", false, ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("unique_by"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())).add(ParamDefExpressionUtil.s("returning"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())));
        this.paramDef("ActiveRecord::Persistence::ClassMethods", "upsert_all", false, ParamDefExpressionUtil.arrayOf(ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("unique_by"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())).add(ParamDefExpressionUtil.s("returning"), ParamDefExpressionUtil.array(RailsParamDefUtil.migrationRef())));
    }

    private void registerRails5_1Paramdefs() {
        this.paramDef("ActionView::Helpers::FormHelper", "form_with", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("url"), ParamDefExpressionUtil.either(null, RailsParamDefUtil.urlForOptionsParamDefHash())).add(ParamDefExpressionUtil.s("method"), null).add(ParamDefExpressionUtil.s("format"), ParamDefExpressionUtil.either(ParamDefExpressionUtil.s("json"), ParamDefExpressionUtil.s("xml"))).add(ParamDefExpressionUtil.s("scope"), null).add(ParamDefExpressionUtil.s("model"), null).add(ParamDefExpressionUtil.s("authenticity_token"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("local"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("skip_enforcing_utf8"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("builder"), null).add(ParamDefExpressionUtil.s("id"), null).add(ParamDefExpressionUtil.s("class"), null).add(ParamDefExpressionUtil.s("data"), null).add(ParamDefExpressionUtil.s("html"), null));
    }

    private void registerRails4ParamDefs() {
        for (String name : CONTROLLER_CALLBACKS) {
            this.defineParamsCopy("AbstractController::Callbacks::ClassMethods::" + name.replace("action", "filter"), "AbstractController::Callbacks::ClassMethods::" + name);
        }
        this.defineParamsCopy("ActionView::Layouts::ClassMethods::layout", "ActionController::Layout::ClassMethods::layout");
        this.defineParamsCopy("ActiveModel::DeprecatedMassAssignmentSecurity::ClassMethods::attr_accessible", "ActiveRecord::Base::attr_accessible");
        this.defineParamsCopy("ActiveRecord::Core::ClassMethods::find", "ActiveRecord::Base::find");
    }

    private void registerRails3ParamDefs() {
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Resources.root"), ParamDefExpressionUtil.maybe(RailsParamDefUtil.routesControllerWithActionRef()), RailsParamDefUtil.routesOptionsHash().add(ParamDefExpressionUtil.s("via"), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.httpVerb(true))));
        this.register(FQN.of((String)"ActionDispatch::Routing::Mapper::Base"), registrar -> {
            registrar.define("match", ParamDefExpressionUtil.seq(ParamDefExpressionUtil.array(ParamDefExpressionUtil.any()), RailsParamDefUtil.routesMatcherOptionsHash().add(ParamDefExpressionUtil.s("via"), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.httpVerb(true)))));
            registrar.highlight("match");
        });
        this.register(FQN.of((String)"ActionDispatch::Routing::Mapper::Resources"), registrar -> {
            registrar.alias("match", FQN.of((String)"ActionDispatch::Routing::Mapper::Base.match"));
            registrar.highlight("match");
        });
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::HttpHelpers.delete"), ParamDefExpressionUtil.array(ParamDefExpressionUtil.any()), RailsParamDefUtil.routesMatcherOptionsHash());
        this.paramDefCopy(FQN.of((String)"ActionDispatch::Routing::Mapper::HttpHelpers.get"), FQN.of((String)"ActionDispatch::Routing::Mapper::HttpHelpers.delete"));
        this.paramDefCopy(FQN.of((String)"ActionDispatch::Routing::Mapper::HttpHelpers.patch"), FQN.of((String)"ActionDispatch::Routing::Mapper::HttpHelpers.delete"));
        this.paramDefCopy(FQN.of((String)"ActionDispatch::Routing::Mapper::HttpHelpers.post"), FQN.of((String)"ActionDispatch::Routing::Mapper::HttpHelpers.delete"));
        this.paramDefCopy(FQN.of((String)"ActionDispatch::Routing::Mapper::HttpHelpers.put"), FQN.of((String)"ActionDispatch::Routing::Mapper::HttpHelpers.delete"));
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Scoping.constraints"), new ParamDefExpressionConvertable[0]);
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Scoping.controller"), RailsParamDefUtil.routesControllerRef(LookupItemType.Symbol, LookupItemType.String));
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Scoping.defaults"), new ParamDefExpressionConvertable[0]);
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Scoping.namespace"), RailsParamDefUtil.routesNamespaceRef(), RailsParamDefUtil.routesScopingOptionsHash());
        this.paramDefCopy(FQN.of((String)"ActionDispatch::Routing::Mapper::Resources.namespace"), FQN.of((String)"ActionDispatch::Routing::Mapper::Scoping.namespace"));
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Scoping.scope"), ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.any()), RailsParamDefUtil.routesScopingOptionsHash());
        this.paramDefCopy(FQN.of((String)"ActionDispatch::Routing::Mapper::Resources.scope"), FQN.of((String)"ActionDispatch::Routing::Mapper::Scoping.scope"));
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Resources.collection"), new ParamDefExpressionConvertable[0]);
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Resources.member"), new ParamDefExpressionConvertable[0]);
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Resources.resource"), ParamDefExpressionUtil.array(RailsParamDefUtil.routesResourceRef()), RailsParamDefUtil.routesScopingOptionsHash());
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Resources.resources"), ParamDefExpressionUtil.array(RailsParamDefUtil.routesResourceRef()), RailsParamDefUtil.routesScopingOptionsHash());
        this.paramDef(FQN.of((String)"ActionDispatch::Routing::Mapper::Resources.shallow"), new ParamDefExpressionConvertable[0]);
        this.defineParamsCopy("ActionDispatch::Routing::UrlFor::url_for", "ActionController::Base::url_for");
        for (String name : CONTROLLER_CALLBACKS) {
            this.paramDef("AbstractController::Callbacks::ClassMethods", name, ParamDefExpressionUtil.array(ParamDefExpressionUtil.instanceMethodRef()), RailsParamDefUtil.beforeFilterHash());
        }
        this.defineParamsCopy("AbstractController::Rendering::render", "ActionController::Base::render");
        this.defineParamsCopy("AbstractController::Rendering::render_to_string", "ActionController::Base::render_to_string");
        this.defineParamsCopy("AbstractController::Helpers::ClassMethods::helper", "ActionController::Helpers::ClassMethods::helper");
        this.defineParamsCopy("AbstractController::Helpers::ClassMethods::helper_method", "ActionController::Helpers::ClassMethods::helper_method");
        this.defineParamsCopy("AbstractController::Layouts::ClassMethods::layout", "ActionController::Layout::ClassMethods::layout");
        this.defineParamsCopy("ActionController::Instrumentation.render", "ActionController::Base::render");
        this.defineParamsCopy("ActionController::Instrumentation.render_to_string", "ActionController::Base::render_to_string");
        this.defineParamsCopy("ActionController::Instrumentation.redirect_to", "ActionController::Base::redirect_to");
        this.defineParamsCopy("ActionController::HideActions::ClassMethods::hide_action", "ActionController::Base::hide_action");
        this.defineParamsCopy("ActionController::Rendering::render", "ActionController::Base::render");
        this.defineParamsCopy("ActionController::Redirecting::redirect_to", "ActionController::Base::redirect_to");
        this.paramDef("ActionController::ForceSSL::ClassMethods", "force_ssl", RailsParamDefUtil.beforeFilterHash());
        this.paramDef("ActionController::HttpAuthentication::Basic::ControllerMethods::ClassMethods", "http_basic_authenticate_with", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("name"), null).add(ParamDefExpressionUtil.s("password"), null).add(ParamDefExpressionUtil.s("realm"), null).merge(RailsParamDefUtil.beforeFilterHash()));
        this.paramDef("ActionController::Streaming::ClassMethods", "stream", RailsParamDefUtil.beforeFilterHash());
        for (String name : MODEL_CALCULATORS) {
            if (name.equals("calculate")) {
                this.paramDef("ActiveRecord::Base", name, false, ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("average"), ParamDefExpressionUtil.s("count"), ParamDefExpressionUtil.s("maximum"), ParamDefExpressionUtil.s("minimum"), ParamDefExpressionUtil.s("sum")), ParamDefExpressionUtil.maybe(RailsParamDefUtil.migrationRef()), ParamDefExpressionUtil.maybe(RailsParamDefUtil.calculationsOptionsHash()));
            } else {
                this.paramDef("ActiveRecord::Base", name, false, ParamDefExpressionUtil.maybe(RailsParamDefUtil.migrationRef()), ParamDefExpressionUtil.maybe(RailsParamDefUtil.calculationsOptionsHash()));
            }
            this.defineParamsCopy("ActiveRecord::Calculations." + name, "ActiveRecord::Base." + name);
            this.defineParamsCopy("ActiveRecord::Querying." + name, "ActiveRecord::Base." + name);
        }
        this.paramDefArel("includes", ParamDefExpressionUtil.either(ParamDefExpressionUtil.arrayOf(RailsParamDefUtil.activeRecordFinderIncludesListItem()), ParamDefExpressionUtil.oneComplexArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.activeRecordFinderIncludesListItem()))));
        this.defineParamsCopy("ActiveRecord::Base::preload", "ActiveRecord::Relation::includes");
        this.defineParamsCopy("ActiveRecord::Relation::preload", "ActiveRecord::Relation::includes");
        this.defineParamsCopy("ActiveRecord::Base::eager_load", "ActiveRecord::Relation::includes");
        this.defineParamsCopy("ActiveRecord::Relation::eager_load", "ActiveRecord::Relation::includes");
        this.defineParamsCopy("ActiveRecord::Base::references", "ActiveRecord::Relation::includes");
        this.defineParamsCopy("ActiveRecord::Relation::references", "ActiveRecord::Relation::includes");
        this.paramDefArel("readonly", ParamDefExpressionUtil.bool());
        this.defineParamsCopy("ActiveRecord::Querying::includes", "ActiveRecord::Relation::includes");
        this.defineParamsCopy("ActiveRecord::Querying::preload", "ActiveRecord::Relation::preload");
        this.defineParamsCopy("ActiveRecord::Querying::eager_load", "ActiveRecord::Relation::eager_load");
        this.defineParamsCopy("ActiveRecord::Querying::references", "ActiveRecord::Relation::references");
        this.paramDef("ActiveModel::Validations::ClassMethods", "validates", ParamDefExpressionUtil.oneSimpleArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(), RailsParamDefUtil.storeAccessorRef())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("acceptance"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("confirmation"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("inclusion"), null).add(ParamDefExpressionUtil.s("exclusion"), null).add(ParamDefExpressionUtil.s("numericality"), ParamDefExpressionUtil.either(ParamDefExpressionUtil.bool(), RailsParamDefUtil.numericalityParamsHash())).add(ParamDefExpressionUtil.s("presence"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("uniqueness"), ParamDefExpressionUtil.either(ParamDefExpressionUtil.bool(), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("case_sensitive"), ParamDefExpressionUtil.bool()))).add(ParamDefExpressionUtil.s("format"), ParamDefExpressionUtil.either(ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("with"), null).add(ParamDefExpressionUtil.s("message"), null).merge(RailsParamDefUtil.validatorsEachParamsHash()), null)).add(ParamDefExpressionUtil.s("length"), ParamDefExpressionUtil.either(ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("minimum"), null).add(ParamDefExpressionUtil.s("maximum"), null).add(ParamDefExpressionUtil.s("within"), null).add(ParamDefExpressionUtil.s("is"), null).add(ParamDefExpressionUtil.s("tokenizer"), null).add(ParamDefExpressionUtil.s("too_short"), null).add(ParamDefExpressionUtil.s("too_long"), null).merge(RailsParamDefUtil.validatorsEachParamsHash()), null)).add(new ValidatesKeysProvider(), ParamDefExpressionUtil.bool()).merge(RailsParamDefUtil.validatorsEachParamsHash()));
        for (String name : MODEL_VALIDATIONS) {
            this.defineParamsCopy("ActiveModel::Validations::HelperMethods::" + name, "ActiveRecord::Validations::ClassMethods::" + name);
        }
        this.defineParamsCopy("ActiveModel::Validations::ClassMethods::validates_each", "ActiveRecord::Validations::ClassMethods::validates_each");
        this.defineParamsCopy("ActiveModel::Validations::ClassMethods::validate", "ActiveRecord::Validations::validate");
        this.defineParamsCopy("ActiveModel::MassAssignmentSecurity::ClassMethods::attr_accessible", "ActiveRecord::Base::attr_accessible");
        this.defineParamsCopy("ActiveModel::MassAssignmentSecurity::ClassMethods::attr_protected", "ActiveRecord::Base::attr_protected");
        this.defineParamsCopy("ActionView::Rendering::render", "ActionView::Base::render");
        this.defineParamsCopy("ActionView::Helpers::RenderingHelper::render", "ActionView::Base::render");
        this.defineParamsCopy("ActionView::Helpers::AssetTagHelper::JavascriptTagHelpers::javascript_include_tag", "ActionView::Helpers::AssetTagHelper::javascript_include_tag");
        this.defineParamsCopy("ActionView::Helpers::AssetTagHelper::StylesheetTagHelpers::stylesheet_link_tag", "ActionView::Helpers::AssetTagHelper::stylesheet_link_tag");
        this.paramDef("ActionView::Helpers::FormTagHelper", "button_tag", null, ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("confirm?"), null).add(ParamDefExpressionUtil.s("disabled"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("disable_with"), null));
        this.paramDef("ActionMailer::Base", "mail", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("to"), null).add(ParamDefExpressionUtil.s("from"), null).add(ParamDefExpressionUtil.s("content_type"), null).add(ParamDefExpressionUtil.s("parts_order"), null).add(ParamDefExpressionUtil.s("subject"), null).add(ParamDefExpressionUtil.s("charset"), null).add(ParamDefExpressionUtil.s("body"), null).add(ParamDefExpressionUtil.s("cc"), null).add(ParamDefExpressionUtil.s("bcc"), null).add(ParamDefExpressionUtil.s("date"), null).add(ParamDefExpressionUtil.s("template_name"), RailsParamDefUtil.viewRef("template_path")).add(ParamDefExpressionUtil.s("template_path"), RailsParamDefUtil.fileRef(false, "view_root", true)));
        this.paramDef("ActiveRecord::Relation", "order", false, ParamDefExpressionUtil.either(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} ORDER BY ", ";")), ParamDefExpressionUtil.seq(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.migrationRef())), ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.oneOfStringsOrSymbols(ParamDefExpressionUtil.s("asc"), ParamDefExpressionUtil.s("desc"))))));
        this.defineParamsCopy("ActiveRecord::Base::order", "ActiveRecord::Relation::order");
        this.paramDef("ActiveRecord::Relation", "where", false, ParamDefExpressionUtil.either(ParamDefExpressionUtil.oneComplexArgOrMoreOf(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} WHERE ", ";"))), ParamDefExpressionUtil.arrayOf(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} WHERE ", ";"))), ParamDefExpressionUtil.hash(true).add(RailsParamDefUtil.migrationRef(), null).add(RailsParamDefUtil.tableNameRef(), null)));
        this.defineParamsCopy("ActiveRecord::Base::where", "ActiveRecord::Relation::where");
        this.paramDefArel("joins", ParamDefExpressionUtil.either(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} INNER JOIN ", ";")), ParamDefExpressionUtil.oneComplexArgOrMoreOf(RailsParamDefUtil.activeRecordFinderIncludesListItem()), ParamDefExpressionUtil.arrayOf(RailsParamDefUtil.activeRecordFinderIncludesListItem())));
        this.paramDefArel("left_joins", ParamDefExpressionUtil.either(ParamDefExpressionUtil.oneComplexArgOrMoreOf(RailsParamDefUtil.activeRecordFinderIncludesListItem()), ParamDefExpressionUtil.arrayOf(RailsParamDefUtil.activeRecordFinderIncludesListItem()), ParamDefExpressionUtil.array(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} LEFT OUTER JOIN ", ";")))));
        this.defineParamsCopy("ActiveRecord::Base::left_outer_joins", "ActiveRecord::Relation::left_joins");
        this.defineParamsCopy("ActiveRecord::Relation::left_outer_joins", "ActiveRecord::Relation::left_joins");
    }

    private void registerRailsParamDefs() {
        for (String methodName1 : new String[]{"try", "try!"}) {
            this.paramDef("ActiveSupport::Tryable", methodName1, false, ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.methodRef().withVisibility(Visibility.PUBLIC, new Function[0])));
        }
        this.paramDefCopy(FQN.of((String)"ActiveSupport::Try.try"), FQN.of((String)"ActiveSupport::Tryable.try"));
        this.paramDefCopy(FQN.of((String)"ActiveSupport::Try.try!"), FQN.of((String)"ActiveSupport::Tryable.try!"));
        this.paramDefCopy(FQN.of((String)"Object.try"), FQN.of((String)"ActiveSupport::Tryable.try"));
        this.paramDefCopy(FQN.of((String)"Object.try!"), FQN.of((String)"ActiveSupport::Tryable.try!"));
        this.paramDef("Module", "delegate", ParamDefExpressionUtil.array(ParamDefExpressionUtil.any()), ParamDefExpressionUtil.hash().add("allow_nil", ParamDefExpressionUtil.bool()).add("prefix", ParamDefExpressionUtil.any()).add("to", ParamDefExpressionUtil.either(ParamDefExpressionUtil.instanceMethodRef(), ParamDefExpressionUtil.constantRef(), ParamDefExpressionUtil.classRef(), ParamDefExpressionUtil.moduleRef())));
        this.paramDef("ActionController::Base", (String[])ContainerUtil.ar((Object[])new String[]{"render", "render_to_string"}), ParamDefExpressionUtil.either(RailsParamDefUtil.renderParamDefHash(), RailsParamDefUtil.viewRef(), ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("update"))), RailsParamDefUtil.renderParamDefHash());
        this.paramDef("ActionController::Base", "hide_action", ParamDefExpressionUtil.array(RailsParamDefUtil.controllerPublicMethodRef(true)));
        this.paramDef("ActionDispatch::Assertions::ResponseAssertions", "assert_redirected_to", ParamDefExpressionUtil.either(ParamDefExpressionUtil.maybe(null), ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("back")), ParamDefExpressionUtil.either(RailsParamDefUtil.urlForOptionsParamDefHash(), RailsParamDefUtil.urlRef())), ParamDefExpressionUtil.maybe(null));
        this.defineParamsCopy("ActionController::Assertions::ResponseAssertions::assert_redirected_to", "ActionDispatch::Assertions::ResponseAssertions::assert_redirected_to");
        this.paramDef("ActionController::Base", "redirect_to", ParamDefExpressionUtil.maybe(null), ParamDefExpressionUtil.either(ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("back")), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("status"), RailsParamDefUtil.statusCodeRef()).add(ParamDefExpressionUtil.s("alert"), null).add(ParamDefExpressionUtil.s("notice"), null).add(ParamDefExpressionUtil.s("flash"), null).merge(RailsParamDefUtil.urlForOptionsParamDefHash())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("status"), RailsParamDefUtil.statusCodeRef()));
        this.paramDef("ActionController::Verification::ClassMethods", "verify", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("method"), RailsParamDefUtil.httpVerb()).add(ParamDefExpressionUtil.s("only"), ParamDefExpressionUtil.array(RailsParamDefUtil.actionRef())).add(ParamDefExpressionUtil.s("except"), ParamDefExpressionUtil.array(RailsParamDefUtil.actionRef())).add(ParamDefExpressionUtil.s("redirect_to"), null).add(ParamDefExpressionUtil.s("params"), null).add(ParamDefExpressionUtil.s("session"), null).add(ParamDefExpressionUtil.s("flash"), null).add(ParamDefExpressionUtil.s("xhr"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("add_flash"), null).add(ParamDefExpressionUtil.s("add_headers"), null).add(ParamDefExpressionUtil.s("redirect_to"), null).add(ParamDefExpressionUtil.s("render"), RailsParamDefUtil.renderParamDefHash()));
        this.paramDef("ActionController::Pagination::ClassMethods", "paginate", RailsParamDefUtil.modelRef(), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("per_page"), null));
        this.paramDef("ActionController::Filters::ClassMethods", (String[])ContainerUtil.map2Array(CONTROLLER_CALLBACKS, String.class, it -> it.replaceFirst("action", "filter")), ParamDefExpressionUtil.array(ParamDefExpressionUtil.methodRef("ActionController::Base")), RailsParamDefUtil.oldBeforeFilterHash());
        this.paramDef("ActionController::Base", "url_for", ParamDefExpressionUtil.either(RailsParamDefUtil.urlForOptionsParamDefHash(), RailsParamDefUtil.urlRef()));
        this.paramDef("ActionController::Layout::ClassMethods", "layout", RailsParamDefUtil.layoutRef(), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("only"), ParamDefExpressionUtil.array(RailsParamDefUtil.actionRef())).add(ParamDefExpressionUtil.s("except"), ParamDefExpressionUtil.array(RailsParamDefUtil.actionRef())));
        this.paramDef("ActionController::Helpers::ClassMethods", "helper", ParamDefExpressionUtil.array(RailsParamDefUtil.helperRef()));
        this.paramDef("ActionController::Helpers::ClassMethods", "helper_method", ParamDefExpressionUtil.array(ParamDefExpressionUtil.instanceMethodRef()));
        this.paramDef("ActionController::RequestForgeryProtection::ClassMethods", "protect_from_forgery", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("secret"), null).add(ParamDefExpressionUtil.s("digest"), null).add(ParamDefExpressionUtil.s("only"), ParamDefExpressionUtil.array(RailsParamDefUtil.actionWithChildrenRef())).add(ParamDefExpressionUtil.s("except"), ParamDefExpressionUtil.array(RailsParamDefUtil.actionWithChildrenRef())));
        this.paramDef("ActionController::SessionManagement::ClassMethods", "session", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.s("off")), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("session_secure"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("if"), null).add(ParamDefExpressionUtil.s("only"), ParamDefExpressionUtil.array(RailsParamDefUtil.actionRef())).add(ParamDefExpressionUtil.s("except"), ParamDefExpressionUtil.array(RailsParamDefUtil.actionRef())));
        this.paramDef("ActiveRecord::Base", (String[])ContainerUtil.ar((Object[])new String[]{"attr_accessible", "attr_protected"}), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.attributeRef()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("as"), null));
        this.paramDef("ActiveRecord::Validations", "validate", ParamDefExpressionUtil.array(ParamDefExpressionUtil.instanceMethodRef()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("if"), ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.instanceMethodRef())).add("unless", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.instanceMethodRef())));
        this.paramDef("ActiveRecord::Validations::ClassMethods", "validates_each", ParamDefExpressionUtil.oneSimpleArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(), RailsParamDefUtil.storeAccessorRef())), RailsParamDefUtil.validatorsEachParamsHash());
        this.paramDef("ActiveRecord::Validations::ClassMethods", (String[])ContainerUtil.ar((Object[])new String[]{"validates_length_of", "validates_size_of"}), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(), RailsParamDefUtil.storeAccessorRef())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("minimum"), null).add(ParamDefExpressionUtil.s("maximum"), null).add(ParamDefExpressionUtil.s("is"), null).add(ParamDefExpressionUtil.s("within"), null).add(ParamDefExpressionUtil.s("in"), null).add(ParamDefExpressionUtil.s("too_long"), null).add(ParamDefExpressionUtil.s("too_short"), null).add(ParamDefExpressionUtil.s("wrong_length"), null).add(ParamDefExpressionUtil.s("tokenizer"), null).merge(RailsParamDefUtil.specialValidatorsParamsHash()));
        this.paramDef("ActiveRecord::Validations::ClassMethods", (String[])ContainerUtil.ar((Object[])new String[]{"validates_exclusion_of", "validates_inclusion_of"}), ParamDefExpressionUtil.oneSimpleArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(), RailsParamDefUtil.storeAccessorRef())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("within"), null).add(ParamDefExpressionUtil.s("in"), null).merge(RailsParamDefUtil.specialValidatorsParamsHash()));
        this.paramDef("ActiveRecord::Validations::ClassMethods", "validates_uniqueness_of", ParamDefExpressionUtil.oneSimpleArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(), RailsParamDefUtil.storeAccessorRef())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("scope"), null).add(ParamDefExpressionUtil.s("case_sensitive"), null).merge(RailsParamDefUtil.specialValidatorsParamsHash()));
        this.paramDef("ActiveRecord::Validations::ClassMethods", "validates_format_of", ParamDefExpressionUtil.oneSimpleArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(), RailsParamDefUtil.storeAccessorRef())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("with"), null).merge(RailsParamDefUtil.specialValidatorsParamsHash()));
        this.paramDef("ActiveRecord::Validations::ClassMethods", "validates_confirmation_of", ParamDefExpressionUtil.oneSimpleArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(), RailsParamDefUtil.storeAccessorRef())), RailsParamDefUtil.specialValidatorsParamsHash());
        this.paramDef("ActiveRecord::Validations::ClassMethods", "validates_presence_of", ParamDefExpressionUtil.oneSimpleArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(), RailsParamDefUtil.usedAssociationRef(), RailsParamDefUtil.storeAccessorRef())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("message"), null).merge(RailsParamDefUtil.validationMethodParamsHash()));
        this.paramDef("ActiveRecord::Validations::ClassMethods", "validates_associated", ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.usedAssociationRef()), RailsParamDefUtil.specialValidatorsParamsHash());
        this.paramDef("ActiveRecord::Validations::ClassMethods", "validates_acceptance_of", ParamDefExpressionUtil.oneSimpleArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.storeAccessorRef(), RailsParamDefUtil.migrationRef())), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("accept"), null).merge(RailsParamDefUtil.specialValidatorsParamsHash()));
        this.paramDef("ActiveRecord::Validations::ClassMethods", "validates_numericality_of", ParamDefExpressionUtil.oneSimpleArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.storeAccessorRef(), RailsParamDefUtil.migrationRef())), RailsParamDefUtil.numericalityParamsHash());
        this.paramDef("ActiveRecord::Base", "find", false, ParamDefExpressionUtil.either(ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("first"), ParamDefExpressionUtil.s("last"), ParamDefExpressionUtil.s("all")), RailsParamDefUtil.findersParamsHash(), ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} WHERE ${primary_key} = ", " LIMIT 1;")));
        for (String methodName : (String[])ContainerUtil.ar((Object[])new String[]{"first", "last", "all"})) {
            this.paramDef("ActiveRecord::Base", methodName, false, RailsParamDefUtil.findersParamsHash());
        }
        this.paramDef("ActiveRecord::Associations::ClassMethods", "belongs_to", RailsParamDefUtil.associationRef(), ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.any()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("counter_cache"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("default"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("dependent"), ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("delete"), ParamDefExpressionUtil.s("destroy"))).add(ParamDefExpressionUtil.s("foreign_key"), RailsParamDefUtil.migrationRef()).add(ParamDefExpressionUtil.s("foreign_type"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("inverse_of"), RailsParamDefUtil.inverseAssocRef()).add(ParamDefExpressionUtil.s("optional"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("primary_key"), RailsParamDefUtil.modelMethodRef()).add(ParamDefExpressionUtil.s("polymorphic"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("required"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("touch"), ParamDefExpressionUtil.bool()).merge(RailsParamDefUtil.associationsCommonHashParams()));
        this.paramDef("ActiveRecord::Associations::ClassMethods", "has_many", RailsParamDefUtil.associationRef(), ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.nil()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("counter_cache"), ParamDefExpressionUtil.any()).add(ParamDefExpressionUtil.s("dependent"), ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("destroy"), ParamDefExpressionUtil.s("delete_all"), ParamDefExpressionUtil.s("nullify"), ParamDefExpressionUtil.s("restrict_with_exception"), ParamDefExpressionUtil.s("restrict_with_error"))).add(ParamDefExpressionUtil.s("extend"), ParamDefExpressionUtil.any()).merge(RailsParamDefUtil.associationsCommonHashParams()).merge(RailsParamDefUtil.hasOneManyCommonHashParams()));
        this.paramDef("ActiveRecord::Associations::ClassMethods", "has_one", RailsParamDefUtil.associationRef(), ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.any()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("dependent"), ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("destroy"), ParamDefExpressionUtil.s("delete"), ParamDefExpressionUtil.s("nullify"), ParamDefExpressionUtil.s("restrict_with_exception"), ParamDefExpressionUtil.s("restrict_with_error"))).add(ParamDefExpressionUtil.s("required"), ParamDefExpressionUtil.bool()).merge(RailsParamDefUtil.associationsCommonHashParams()).merge(RailsParamDefUtil.hasOneManyCommonHashParams()));
        this.paramDef("ActiveRecord::Associations::ClassMethods", "has_and_belongs_to_many", RailsParamDefUtil.associationRef(), ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.nil()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("join_table"), RailsParamDefUtil.associationsJoinTable()).add(ParamDefExpressionUtil.s("foreign_key"), RailsParamDefUtil.joinFieldRef(0)).add(ParamDefExpressionUtil.s("association_foreign_key"), ParamDefExpressionUtil.any()).merge(RailsParamDefUtil.associationsCommonHashParams()));
        this.paramDef("ActiveRecord::Base", ArrayUtil.toStringArray(MODEL_CALLBACKS), ParamDefExpressionUtil.array(ParamDefExpressionUtil.either(null, ParamDefExpressionUtil.instanceMethodRef())), RailsParamDefUtil.callbacksHash());
        this.paramDef("ActiveRecord::NestedAttributes::ClassMethods", "accepts_nested_attributes_for", RailsParamDefUtil.usedAssociationRef(), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("allow_destroy"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("reject_if"), null).add(ParamDefExpressionUtil.s("limit"), null).add(ParamDefExpressionUtil.s("update_only"), ParamDefExpressionUtil.bool()));
        this.paramDef("ActiveRecord::Enum", "enum", ParamDefExpressionUtil.either(ParamDefExpressionUtil.hash(true).add(RailsParamDefUtil.attributeRef(), ParamDefExpressionUtil.any()), ParamDefExpressionUtil.seq(ParamDefExpressionUtil.maybe(RailsParamDefUtil.attributeRef()), ParamDefExpressionUtil.array(ParamDefExpressionUtil.any()))));
        this.register(FQN.of((String)"ActiveRecord::Inheritance::ClassMethods"), registrar -> registrar.define("new", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())));
        this.register(FQN.of((String)"ActiveRecord::Persistence::ClassMethods"), registrar -> {
            registrar.define("create", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("create!", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("update", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("id"), ParamDefExpressionUtil.any()).add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("update!", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("id"), ParamDefExpressionUtil.any()).add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
        });
        this.register(FQN.of((String)"ActiveRecord::Persistence"), registrar -> {
            registrar.define("update", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("update!", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("update_columns", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.alias("update_attributes", FQN.of((String)"ActiveRecord::Persistence.update"));
            registrar.alias("update_attributes!", FQN.of((String)"ActiveRecord::Persistence.update!"));
        });
        this.register(FQN.of((String)"ActiveRecord::Associations::CollectionAssociation"), registrar -> registrar.define("build", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())));
        this.register(FQN.of((String)"ActiveRecord::Associations::CollectionProxy"), registrar -> {
            registrar.define("build", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("create", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("create!", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
        });
        this.register(FQN.of((String)"ActiveRecord::Transactions::ClassMethods"), registrar -> {
            registrar.define("after_commit", ParamDefExpressionUtil.seq(ParamDefExpressionUtil.array(ParamDefExpressionUtil.either(null, ParamDefExpressionUtil.instanceMethodRef())), RailsParamDefUtil.callbacksHash()));
            registrar.define("after_create_commit", ParamDefExpressionUtil.seq(ParamDefExpressionUtil.array(ParamDefExpressionUtil.either(null, ParamDefExpressionUtil.instanceMethodRef())), RailsParamDefUtil.callbacksHash()));
            registrar.define("after_update_commit", ParamDefExpressionUtil.seq(ParamDefExpressionUtil.array(ParamDefExpressionUtil.either(null, ParamDefExpressionUtil.instanceMethodRef())), RailsParamDefUtil.callbacksHash()));
            registrar.define("after_save_commit", ParamDefExpressionUtil.seq(ParamDefExpressionUtil.array(ParamDefExpressionUtil.either(null, ParamDefExpressionUtil.instanceMethodRef())), RailsParamDefUtil.callbacksHash()));
            registrar.define("after_destroy_commit", ParamDefExpressionUtil.seq(ParamDefExpressionUtil.array(ParamDefExpressionUtil.either(null, ParamDefExpressionUtil.instanceMethodRef())), RailsParamDefUtil.callbacksHash()));
            registrar.highlight("after_commit", "after_create_commit", "after_update_commit", "after_save_commit", "after_destroy_commit");
        });
        this.paramDef("ActionView::Helpers::FormTagHelper", "form_tag", ParamDefExpressionUtil.maybe(null), RailsParamDefUtil.urlForOptionsParamDefHash(), ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("method"), RailsParamDefUtil.httpVerb()).add(ParamDefExpressionUtil.s("multipart"), null).add(ParamDefExpressionUtil.s("id"), null).add(ParamDefExpressionUtil.s("url"), null));
        this.paramDef("ActionView::Helpers::UrlHelper", (String[])ContainerUtil.ar((Object[])new String[]{"link_to", "link_to_if", "link_to_unless", "link_to_unless_current"}), null, ParamDefExpressionUtil.either(RailsParamDefUtil.urlForOptionsParamDefHash(), ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("back")), null), ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("confirm"), null).add(ParamDefExpressionUtil.s("method"), RailsParamDefUtil.httpVerb()).add(ParamDefExpressionUtil.s("popup"), null).add(ParamDefExpressionUtil.s("id"), null).add(ParamDefExpressionUtil.s("class"), null).add(ParamDefExpressionUtil.s("title"), null).add(ParamDefExpressionUtil.s("style"), ParamDefExpressionUtil.maybeOneOf("display: none")).add(ParamDefExpressionUtil.s("dir"), null).add(ParamDefExpressionUtil.s("lang"), null).add(ParamDefExpressionUtil.s("charset"), null).add(ParamDefExpressionUtil.s("coords"), null).add(ParamDefExpressionUtil.s("href"), null).add(ParamDefExpressionUtil.s("hreflang"), null).add(ParamDefExpressionUtil.s("name"), null).add(ParamDefExpressionUtil.s("rel"), RailsParamDefUtil.relRef()).add(ParamDefExpressionUtil.s("rev"), RailsParamDefUtil.relRef()).add(ParamDefExpressionUtil.s("shape"), ParamDefExpressionUtil.oneOf("rect", "rectangle", "circ", "circle", "poly", "polygon")).add(ParamDefExpressionUtil.s("target"), ParamDefExpressionUtil.oneOf("_blank", "_parent", "_self", "_top")));
        this.paramDef("ActionView::Helpers::UrlHelper", "mail_to", null, ParamDefExpressionUtil.maybe(null), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("encode"), ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("javascript"), ParamDefExpressionUtil.s("hex"))).add(ParamDefExpressionUtil.s("replace_at"), null).add(ParamDefExpressionUtil.s("replace_dot"), null).add(ParamDefExpressionUtil.s("subject"), null).add(ParamDefExpressionUtil.s("body"), null).add(ParamDefExpressionUtil.s("cc"), null).add(ParamDefExpressionUtil.s("bcc"), null));
        this.paramDef("ActionView::Helpers::FormHelper", "form_for", null, ParamDefExpressionUtil.maybe(null), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("url"), ParamDefExpressionUtil.either(null, RailsParamDefUtil.urlForOptionsParamDefHash())).add(ParamDefExpressionUtil.s("html"), null).add(ParamDefExpressionUtil.s("builder"), null));
        this.paramDef("ActionView::Helpers::PrototypeHelper", "form_remote_tag", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("url"), RailsParamDefUtil.urlForOptionsParamDefHash()).add(ParamDefExpressionUtil.s("html"), null));
        this.paramDef("ActionView::Helpers::AssetTagHelper", "stylesheet_link_tag", ParamDefExpressionUtil.either(ParamDefExpressionUtil.seq(ParamDefExpressionUtil.s("all"), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("recursive"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("cache"), ParamDefExpressionUtil.bool())), ParamDefExpressionUtil.seq(ParamDefExpressionUtil.oneSimpleArgOrMoreOf(RailsParamDefUtil.stylesheetRef()), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("media"), ParamDefExpressionUtil.oneOfStringsOrSymbols("screen", "all", "aural", "braille", "embossed", "handheld", "print", "projection", "tty", "tv")))));
        this.paramDef("ActionView::Helpers::AssetTagHelper", "image_tag", RailsParamDefUtil.imageRef(), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("align"), ParamDefExpressionUtil.oneOf("top", "bottom", "middle", "left", "right")).add(ParamDefExpressionUtil.s("border"), null).add(ParamDefExpressionUtil.s("alt"), null).add(ParamDefExpressionUtil.s("title"), null).add(ParamDefExpressionUtil.s("id"), null).add(ParamDefExpressionUtil.s("style"), null).add(ParamDefExpressionUtil.s("class"), null).add(ParamDefExpressionUtil.s("height"), null).add(ParamDefExpressionUtil.s("hspace"), null).add(ParamDefExpressionUtil.s("ismap"), null).add(ParamDefExpressionUtil.s("longdesc"), null).add(ParamDefExpressionUtil.s("usemap"), null).add(ParamDefExpressionUtil.s("vspace"), null).add(ParamDefExpressionUtil.s("width"), null).add(ParamDefExpressionUtil.s("size"), null).add(ParamDefExpressionUtil.s("mouseover"), RailsParamDefUtil.imageRef()).add(ParamDefExpressionUtil.s("onmouseover"), RailsParamDefUtil.imageRef()).add(ParamDefExpressionUtil.s("onmouseout"), RailsParamDefUtil.imageRef()));
        this.paramDef("ActionView::Helpers::AssetTagHelper", "javascript_include_tag", ParamDefExpressionUtil.either(ParamDefExpressionUtil.seq(ParamDefExpressionUtil.s("all"), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("recursive"), ParamDefExpressionUtil.bool())), ParamDefExpressionUtil.seq(ParamDefExpressionUtil.s("defaults")), ParamDefExpressionUtil.array(RailsParamDefUtil.scriptRef())));
        this.paramDef("ActionView::Helpers::PrototypeHelper::JavaScriptGenerator::GeneratorMethods", "replace_html", null, ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("partial"), RailsParamDefUtil.partialRef()));
        this.paramDef("ActionView::Helpers::UrlHelper", "button_to", null, ParamDefExpressionUtil.either(ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("controller"), RailsParamDefUtil.controllerRef()).add(ParamDefExpressionUtil.s("action"), RailsParamDefUtil.actionRef("controller")).add(ParamDefExpressionUtil.s("remote"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("disabled"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("confirm"), null).add(ParamDefExpressionUtil.s("method"), RailsParamDefUtil.httpVerb()), null), ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("anchor"), null).add(ParamDefExpressionUtil.s("only_path"), null).add(ParamDefExpressionUtil.s("trailing_slash"), null).add(ParamDefExpressionUtil.s("skip_relative_url_root"), null).add(ParamDefExpressionUtil.s("host"), null).add(ParamDefExpressionUtil.s("protocol"), null).add(ParamDefExpressionUtil.s("user"), null).add(ParamDefExpressionUtil.s("password"), null).add(ParamDefExpressionUtil.s("escape"), null).add(ParamDefExpressionUtil.s("disable"), null).add(ParamDefExpressionUtil.s("confirm"), null).add(ParamDefExpressionUtil.s("method"), RailsParamDefUtil.httpVerb()));
        this.defineParamsCopy("ActionView::Helpers::UrlHelper::url_for", "ActionController::Base::url_for");
        this.paramDef("ActionView::Base", (String[])ContainerUtil.ar((Object[])new String[]{"render", "render_to_string", "render_with_haml"}), ParamDefExpressionUtil.either(RailsParamDefUtil.renderParamDefHash(), ParamDefExpressionUtil.seq(RailsParamDefUtil.partialRef(), ParamDefExpressionUtil.hash(true)), ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("update"))));
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "add_reference", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), null), RailsParamDefProvider.referenceOptionsHash());
        this.defineParamsCopy("ActiveRecord::ConnectionAdapters::SchemaStatements::add_belongs_to", "ActiveRecord::ConnectionAdapters::SchemaStatements::add_reference");
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "add_column", RailsParamDefUtil.tableNameRef(), null, RailsParamDefUtil.tableColumnTypeRef(), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("column"), null).merge(RailsParamDefUtil.tableColumnChangeParamDefHash()));
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "add_index", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), ParamDefExpressionUtil.arrayOf(RailsParamDefUtil.migrationRef(-1, 0)), null), ParamDefExpressionUtil.either(RailsParamDefProvider.indexOptionsHash(), ParamDefExpressionUtil.hash().add("length", null).add("order", null).add("where", null).add("using", null).add("type", null)));
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "add_timestamps", RailsParamDefUtil.tableNameRef());
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "change_column", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), null), RailsParamDefUtil.tableColumnTypeRef(), RailsParamDefUtil.tableColumnChangeParamDefHash());
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "change_column_default", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), null), null);
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "change_column_null", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), null), ParamDefExpressionUtil.bool(), null);
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "change_table", RailsParamDefUtil.tableNameRef());
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "column_exists?", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), null), ParamDefExpressionUtil.either(RailsParamDefUtil.tableColumnTypeRef(), null), RailsParamDefUtil.tableColumnChangeParamDefHash());
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "columns", RailsParamDefUtil.tableNameRef());
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "create_join_table", RailsParamDefUtil.tableNameRef(), RailsParamDefUtil.tableNameRef());
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "create_table", null, ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("if_not_exists"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("primary_key"), null).add(ParamDefExpressionUtil.s("temporary"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("force"), CreateTableForceParam.INSTANCE).add(ParamDefExpressionUtil.s("options"), null).add(ParamDefExpressionUtil.s("id"), null));
        this.paramDef("ActiveRecord::ConnectionAdapters::TableDefinition", "decimal", null, ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("precision"), null).add(ParamDefExpressionUtil.s("scale"), null));
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "drop_join_table", RailsParamDefUtil.tableNameRef(), RailsParamDefUtil.tableNameRef());
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "drop_table", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.hash(true));
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "index_exists?", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), ParamDefExpressionUtil.arrayOf(RailsParamDefUtil.migrationRef(-1, 0), null), RailsParamDefProvider.indexOptionsHash()));
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "index_name_exists?", RailsParamDefUtil.tableNameRef(), null, null);
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "remove_reference", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), null), RailsParamDefProvider.referenceOptionsHash());
        this.defineParamsCopy("ActiveRecord::ConnectionAdapters::SchemaStatements::remove_belongs_to", "ActiveRecord::ConnectionAdapters::SchemaStatements::remove_reference");
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "remove_column", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.oneComplexArgOrMoreOf(ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), null)), RailsParamDefUtil.tableColumnTypeRef());
        this.defineParamsCopy("ActiveRecord::ConnectionAdapters::SchemaStatements::remove_columns", "ActiveRecord::ConnectionAdapters::SchemaStatements::remove_column");
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "remove_index", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), null), ParamDefExpressionUtil.either(ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("column"), null).add(ParamDefExpressionUtil.s("name"), null), null));
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "remove_timestamps", RailsParamDefUtil.tableNameRef());
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "rename_column", RailsParamDefUtil.tableNameRef(), ParamDefExpressionUtil.either(RailsParamDefUtil.migrationRef(-1, 0), null), null);
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "rename_index", RailsParamDefUtil.tableNameRef(), null, null);
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "rename_table", RailsParamDefUtil.tableNameRef(), null);
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "table_alias_for", RailsParamDefUtil.tableNameRef());
        this.paramDef("ActiveRecord::ConnectionAdapters::SchemaStatements", "table_exists?", RailsParamDefUtil.tableNameRef());
    }

    private void registerActiveRecordConnectionAdaptersDatabaseStatements() {
        this.register(FQN.of((String)"ActiveRecord::ConnectionAdapters::DatabaseStatements"), registrar -> {
            registrar.define("create", ParamDefExpressionUtil.string("SQL"));
            registrar.define("delete", ParamDefExpressionUtil.string("SQL"));
            registrar.define("exec_delete", ParamDefExpressionUtil.string("SQL"));
            registrar.define("exec_insert", ParamDefExpressionUtil.string("SQL"));
            registrar.define("exec_query", ParamDefExpressionUtil.string("SQL"));
            registrar.define("exec_update", ParamDefExpressionUtil.string("SQL"));
            registrar.define("execute", ParamDefExpressionUtil.string("SQL"));
            registrar.define("insert", ParamDefExpressionUtil.string("SQL"));
            registrar.define("select_all", ParamDefExpressionUtil.string("SQL"));
            registrar.define("select_one", ParamDefExpressionUtil.string("SQL"));
            registrar.define("select_rows", ParamDefExpressionUtil.string("SQL"));
            registrar.define("select_value", ParamDefExpressionUtil.string("SQL"));
            registrar.define("select_values", ParamDefExpressionUtil.string("SQL"));
            registrar.define("to_sql", ParamDefExpressionUtil.string("SQL"));
            registrar.define("update", ParamDefExpressionUtil.string("SQL"));
            registrar.define("write_query?", ParamDefExpressionUtil.string("SQL"));
        });
    }

    private void registerActiveRecordConnectionAdaptersQueryCache() {
        this.register(FQN.of((String)"ActiveRecord::ConnectionAdapters::QueryCache"), registrar -> registrar.alias("select_all", FQN.of((String)"ActiveRecord::ConnectionAdapters::DatabaseStatements.select_all")));
    }

    private void registerActiveRecordFinderMethods() {
        this.register(FQN.of((String)"ActiveRecord::FinderMethods"), registrar -> {
            registrar.define("exists?", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT 1 FROM ${table_name} WHERE ${primary_key} = ", " LIMIT 1;")));
            registrar.alias("find", FQN.of((String)"ActiveRecord::Base.find"));
            registrar.define("find_by", ParamDefExpressionUtil.either(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} WHERE (", ") LIMIT 1;")), ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())));
            registrar.alias("find_by!", "find_by");
            registrar.define("find_sole_by", ParamDefExpressionUtil.either(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} WHERE (", ") LIMIT 2;")), ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())));
        });
    }

    private void registerActiveRecordQueryMethods() {
        this.register(FQN.of((String)"ActiveRecord::QueryMethods"), registrar -> {
            registrar.define("annotate", ParamDefExpressionUtil.string("SQL", "/* ", " */"));
            registrar.define("from", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ", ";")));
            registrar.define("group", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} GROUP BY ", ";")));
            registrar.define("having", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} GROUP BY #{group_by} HAVING ", ";")));
            registrar.alias("joins", FQN.of((String)"ActiveRecord::Base.joins"));
            registrar.alias("left_joins", FQN.of((String)"ActiveRecord::Base.left_joins"));
            registrar.alias("left_outer_joins", FQN.of((String)"ActiveRecord::Base.left_outer_joins"));
            registrar.define("optimizer_hints", ParamDefExpressionUtil.string("SQL", "SELECT /*+ ", " */ * FROM ${table_name};"));
            registrar.alias("order", FQN.of((String)"ActiveRecord::Base.order"));
            registrar.define("reorder", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} ORDER BY ", ";")));
            registrar.define("rewhere", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} WHERE ", ";")));
            registrar.define("select", ParamDefExpressionUtil.array(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT ", " FROM ${table_name};"))));
            registrar.alias("where", FQN.of((String)"ActiveRecord::Base.where"));
        });
    }

    private void registerActiveRecordQuerying() {
        this.register(FQN.of((String)"ActiveRecord::Querying"), registrar -> {
            registrar.alias("annotate", FQN.of((String)"ActiveRecord::QueryMethods.annotate"));
            registrar.define("count_by_sql", ParamDefExpressionUtil.string("SQL"));
            registrar.define("delete_by", ParamDefExpressionUtil.either(ParamDefExpressionUtil.string("SQL", "DELETE FROM ${table_name} WHERE ", ";"), ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())));
            registrar.define("destroy_by", ParamDefExpressionUtil.either(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} WHERE ", ";"), ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())));
            registrar.alias("exists?", FQN.of((String)"ActiveRecord::FinderMethods.exists?"));
            registrar.alias("find", FQN.of((String)"ActiveRecord::FinderMethods.find"));
            registrar.alias("find_by", FQN.of((String)"ActiveRecord::FinderMethods.find_by"));
            registrar.alias("find_by!", FQN.of((String)"ActiveRecord::FinderMethods.find_by!"));
            registrar.define("find_by_sql", ParamDefExpressionUtil.string("SQL"));
            registrar.define("find_or_create_by", ParamDefExpressionUtil.either(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} WHERE ", " LIMIT 1;")), ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())));
            registrar.define("find_or_create_by!", ParamDefExpressionUtil.either(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} WHERE ", " LIMIT 1;")), ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())));
            registrar.define("find_or_initialize_by", ParamDefExpressionUtil.either(ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "SELECT * FROM ${table_name} WHERE ", " LIMIT 1;")), ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any())));
            registrar.alias("find_sole_by", FQN.of((String)"ActiveRecord::FinderMethods.find_sole_by"));
            registrar.alias("from", FQN.of((String)"ActiveRecord::QueryMethods.from"));
            registrar.alias("group", FQN.of((String)"ActiveRecord::QueryMethods.group"));
            registrar.alias("having", FQN.of((String)"ActiveRecord::QueryMethods.having"));
            registrar.alias("joins", FQN.of((String)"ActiveRecord::QueryMethods.joins"));
            registrar.alias("left_joins", FQN.of((String)"ActiveRecord::QueryMethods.left_joins"));
            registrar.alias("left_outer_joins", FQN.of((String)"ActiveRecord::QueryMethods.left_outer_joins"));
            registrar.alias("optimizer_hints", FQN.of((String)"ActiveRecord::QueryMethods.optimizer_hints"));
            registrar.alias("order", FQN.of((String)"ActiveRecord::QueryMethods.order"));
            registrar.alias("reorder", FQN.of((String)"ActiveRecord::QueryMethods.reorder"));
            registrar.alias("reselect", FQN.of((String)"ActiveRecord::QueryMethods.reselect"));
            registrar.alias("rewhere", FQN.of((String)"ActiveRecord::QueryMethods.rewhere"));
            registrar.alias("select", FQN.of((String)"ActiveRecord::QueryMethods.select"));
            registrar.define("update_all", ParamDefExpressionUtil.maybe(ParamDefExpressionUtil.string("SQL", "UPDATE ${table_name} SET ", ";")));
            registrar.alias("where", FQN.of((String)"ActiveRecord::QueryMethods.where"));
        });
    }

    private void registerActiveRecordRelation() {
        this.register(FQN.of((String)"ActiveRecord::Relation"), registrar -> {
            registrar.define("new", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("create", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("create!", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("first_or_create", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("first_or_create!", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("first_or_initialize", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("create_or_find_by", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("create_or_find_by!", ParamDefExpressionUtil.hash().add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("update", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("id"), ParamDefExpressionUtil.any()).add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.define("update!", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("id"), ParamDefExpressionUtil.any()).add(RailsParamDefUtil.migrationRef(), ParamDefExpressionUtil.any()));
            registrar.alias("build", FQN.of((String)"ActiveRecord::Relation.new"));
            registrar.alias("delete_by", FQN.of((String)"ActiveRecord::Querying.delete_by"));
            registrar.alias("destroy_by", FQN.of((String)"ActiveRecord::Querying.destroy_by"));
            registrar.alias("find_or_create_by", FQN.of((String)"ActiveRecord::Querying.find_or_create_by"));
            registrar.alias("find_or_create_by!", FQN.of((String)"ActiveRecord::Querying.find_or_create_by!"));
            registrar.alias("find_or_initialize_by", FQN.of((String)"ActiveRecord::Querying.find_or_initialize_by"));
            registrar.alias("update_all", FQN.of((String)"ActiveRecord::Querying.update_all"));
        });
    }

    private void registerActiveRecordRelationDeprecatedMethods() {
        this.register(FQN.of((String)"ActiveRecord::Relation::DeprecatedMethods"), registrar -> registrar.alias("find", FQN.of((String)"ActiveRecord::Base.find")));
    }

    private void registerArel() {
        this.register(FQN.of((String)"Arel"), registrar -> registrar.define("sql", ParamDefExpressionUtil.string("SQL")));
    }

    @NotNull
    private static ParamDefExpressionConvertable indexOptionsHash() {
        ParamDefExpressionConvertable paramDefExpressionConvertable = ParamDefExpressionUtil.either(ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("unique"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("name"), null), null);
        if (paramDefExpressionConvertable == null) {
            RailsParamDefProvider.$$$reportNull$$$0(0);
        }
        return paramDefExpressionConvertable;
    }

    @NotNull
    private static RubyHashParamDef referenceOptionsHash() {
        RubyHashParamDef rubyHashParamDef = ParamDefExpressionUtil.hash(true).add(ParamDefExpressionUtil.s("polymorphic"), ParamDefExpressionUtil.bool()).add(ParamDefExpressionUtil.s("index"), ParamDefExpressionUtil.bool());
        if (rubyHashParamDef == null) {
            RailsParamDefProvider.$$$reportNull$$$0(1);
        }
        return rubyHashParamDef;
    }

    private void paramDefArel(String methodName, ParamDefExpressionConvertable ... expressions) {
        this.paramDef("ActiveRecord::Base", methodName, false, expressions);
        this.paramDef("ActiveRecord::Relation", methodName, false, expressions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/RailsParamDefProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "indexOptionsHash";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "referenceOptionsHash";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

