/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsTypeProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.RailsModelSymbol;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RTypedSyntheticSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RDynamicType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RSymbolTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyConstantDeclarationFqnIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.StructNewCallTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class ActiveRecordType
extends RDynamicType {
    public static final Set<String> COLUMN_TYPES = new TreeSet<String>(Set.of("bigint", "binary", "boolean", "date", "datetime", "decimal", "float", "integer", "json", "jsonb", "numeric", "string", "text", "time", "timestamp", "uuid", "point"));
    @NonNls
    private static final String FIND_ALL_BY = "find_all_by_";
    @NonNls
    public static final String FIND_BY = "find_by_";
    private static final List<@NonNls String> ourFindByPrefixes = Arrays.asList("find_by_", "find_all_by_", "find_or_initialize_by_", "find_or_create_by_");
    @NotNull
    private final Map<String, GroupBySymbolType> myNameWithType2GroupTable;

    private ActiveRecordType(@NotNull Symbol symbol) {
        if (symbol == null) {
            ActiveRecordType.$$$reportNull$$$0(0);
        }
        super(symbol);
        this.myNameWithType2GroupTable = new HashMap<String, GroupBySymbolType>();
    }

    @Override
    public void processMembers(@NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint, @NotNull Consumer<? super Symbol> consumer) {
        if (filter == null) {
            ActiveRecordType.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            ActiveRecordType.$$$reportNull$$$0(2);
        }
        this.myNameWithType2GroupTable.clear();
        super.processMembers(filter, invocationPoint, consumer);
    }

    @Override
    public Symbol getMemberForName(@NotNull @NonNls String name, @NotNull Predicate<? super Symbol> filter, PsiElement invocationPoint) {
        Symbol result;
        if (name == null) {
            ActiveRecordType.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            ActiveRecordType.$$$reportNull$$$0(4);
        }
        this.myNameWithType2GroupTable.clear();
        if (name.equals("save") && (result = super.getMemberForName("save_with_validation", filter, invocationPoint)) != null) {
            return result;
        }
        result = super.getMemberForName(name, filter, invocationPoint);
        if (result != null) {
            return result;
        }
        Project project = this.getSymbol().getProject();
        if (this.getFindByPrefix(name) != null && this.getSymbol() instanceof SingletonClassSymbol) {
            ActiveRecordType modelType = ActiveRecordType.createActiveRecordType(((SingletonClassSymbol)this.getSymbol()).getOriginSymbol());
            ActiveRecordType returnType = name.startsWith(FIND_ALL_BY) ? RTypeFactory.createArrayType(project, (RType)ObjectUtils.coalesce((Object)((Object)modelType), (Object)REmptyType.INSTANCE)) : modelType;
            FindByCompletionPrefix completionPrefix = new FindByCompletionPrefix();
            completionPrefix.parsePrefix(name, null);
            Symbol methodMissing = SymbolUtil.getMethodMissing(project, "ActiveRecord::Base", ContextImpl.CLASS_PRIVATE);
            PsiElement declaration = (PsiElement)ObjectUtils.doIfNotNull((Object)methodMissing, Symbol::getPsiElement);
            DynamicFinder symbol = new DynamicFinder(project, name, Type.INSTANCE_METHOD, this.getSymbol(), (RType)ObjectUtils.coalesce((Object)((Object)returnType), (Object)REmptyType.INSTANCE), completionPrefix.myColumnsInPrefix, declaration);
            return filter.test((Symbol)symbol) ? symbol : null;
        }
        return null;
    }

    @Override
    @NotNull
    protected <T extends RSymbolTypeImpl> T createThis(@Nullable T initialObject, @NotNull Symbol symbol) {
        if (symbol == null) {
            ActiveRecordType.$$$reportNull$$$0(5);
        }
        ActiveRecordType type = (ActiveRecordType)super.createThis(initialObject != null ? initialObject : new ActiveRecordType(symbol), symbol);
        type.myNameWithType2GroupTable.putAll(this.myNameWithType2GroupTable);
        ActiveRecordType activeRecordType = type;
        if (activeRecordType == null) {
            ActiveRecordType.$$$reportNull$$$0(6);
        }
        return (T)((Object)activeRecordType);
    }

    @Nullable
    private String getFindByPrefix(String name) {
        for (String prefix : this.getFinderPrefixes()) {
            if (!name.startsWith(prefix)) continue;
            return prefix;
        }
        return null;
    }

    private List<String> getFinderPrefixes() {
        Symbol dynScopeMatch;
        Project project = this.getSymbol().getProject();
        Symbol deprecated = SymbolUtil.findConstantByFQN(project, Type.MODULE, FQN.of((String)"ActiveRecord::DynamicMatchers::DeprecatedFinder"), null);
        if (RailsUtil.isRails40OrHigher(this.getSymbol().getModule()) && deprecated == null) {
            return Collections.singletonList(FIND_BY);
        }
        ArrayList<@NonNls String> prefixes = new ArrayList<String>(ourFindByPrefixes);
        if (deprecated != null) {
            prefixes.add("find_last_by_");
            prefixes.add("scoped_by_");
            return prefixes;
        }
        Symbol finderMatch = SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.of((String)"ActiveRecord::DynamicFinderMatch"), null);
        if (finderMatch != null) {
            prefixes.add("find_last_by_");
        }
        if ((dynScopeMatch = SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.of((String)"ActiveRecord::DynamicScopeMatch"), null)) != null) {
            prefixes.add("scoped_by_");
        }
        return prefixes;
    }

    public void processMembersForPrefix(@NotNull String prefix, @NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint, @NotNull Consumer<? super Symbol> consumer) {
        if (prefix == null) {
            ActiveRecordType.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            ActiveRecordType.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            ActiveRecordType.$$$reportNull$$$0(9);
        }
        this.myNameWithType2GroupTable.clear();
        this.processMembers(filter, invocationPoint, consumer);
        Collection<MigrationField> fields = this.getMigrationFields();
        if (fields == null) {
            return;
        }
        Project project = this.getSymbol().getProject();
        FindByCompletionPrefix completionPrefix = new FindByCompletionPrefix();
        completionPrefix.parsePrefix(prefix, fields);
        for (MigrationField field : fields) {
            String fieldName = field.getName();
            if (fieldName == null || fieldName.equals("id") || completionPrefix.getColumnsInPrefix().contains(fieldName)) continue;
            for (String fieldPrefix : completionPrefix.getPrefixesForField()) {
                String name = fieldPrefix + fieldName;
                consumer.accept((Symbol)new SymbolImpl(project, name, Type.CLASS_METHOD, this.getSymbol()));
            }
        }
        String prefixOfCompleteColumns = completionPrefix.getPrefixOfCompleteColumns();
        if (prefixOfCompleteColumns != null && !prefixOfCompleteColumns.isEmpty()) {
            consumer.accept((Symbol)new SymbolImpl(project, prefixOfCompleteColumns, Type.CLASS_METHOD, this.getSymbol()));
        }
    }

    @Nullable
    private Collection<MigrationField> getMigrationFields() {
        Module module;
        PsiElement declaration = this.getSymbol().getPsiElement();
        if (declaration instanceof RClass && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)declaration)) != null) {
            return ActiveRecordModel.getFields(module, (RClass)declaration);
        }
        return null;
    }

    @NotNull
    public RubyCompletionGrouping getGroupForMember(@NotNull Symbol member) {
        String name;
        if (member == null) {
            ActiveRecordType.$$$reportNull$$$0(10);
        }
        if (this.myNameWithType2GroupTable.isEmpty()) {
            this.buildGroupsTable();
        }
        if ((name = member.getName()) != null) {
            RubyCompletionGrouping group;
            GroupBySymbolType groupBySymbolType = this.myNameWithType2GroupTable.get(name);
            RubyCompletionGrouping rubyCompletionGrouping = group = groupBySymbolType == null ? null : groupBySymbolType.getGroup(member);
            if (group != null) {
                RubyCompletionGrouping rubyCompletionGrouping2 = group;
                if (rubyCompletionGrouping2 == null) {
                    ActiveRecordType.$$$reportNull$$$0(11);
                }
                return rubyCompletionGrouping2;
            }
            if (name.equals("save") || this.getFindByPrefix(name) != null) {
                RubyCompletionGrouping rubyCompletionGrouping3 = RubyCompletionGrouping.RAILS_IMPORTANT_METHOD;
                if (rubyCompletionGrouping3 == null) {
                    ActiveRecordType.$$$reportNull$$$0(12);
                }
                return rubyCompletionGrouping3;
            }
        }
        if (member.getType() == Type.FIELD_READER || member.getType() == Type.FIELD_WRITER) {
            RubyCompletionGrouping rubyCompletionGrouping = RubyCompletionGrouping.INSTANCE_FIELDS;
            if (rubyCompletionGrouping == null) {
                ActiveRecordType.$$$reportNull$$$0(13);
            }
            return rubyCompletionGrouping;
        }
        RubyCompletionGrouping rubyCompletionGrouping = super.getGroupForMember(member);
        if (rubyCompletionGrouping == null) {
            ActiveRecordType.$$$reportNull$$$0(14);
        }
        return rubyCompletionGrouping;
    }

    private void buildGroupsTable() {
        for (String finder : RailsTypeProvider.ACTIVE_RECORD_FINDERS) {
            this.myNameWithType2GroupTable.put(finder, new GroupBySymbolType(RubyCompletionGrouping.RAILS_IMPORTANT_METHOD, Type.INSTANCE_METHOD));
        }
    }

    @Nullable
    public static ActiveRecordType createActiveRecordType(@Nullable Symbol symbol) {
        return (ActiveRecordType)((Object)ObjectUtils.doIfNotNull((Object)RailsModelSymbol.createModelSymbol(symbol), modelSymbol -> new ActiveRecordType((Symbol)modelSymbol)));
    }

    @NotNull
    public static RType createTypeByDataType(@NotNull Project project, @Nullable String dataType) {
        RType pointType;
        if (project == null) {
            ActiveRecordType.$$$reportNull$$$0(15);
        }
        if (dataType == null || !COLUMN_TYPES.contains(dataType)) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                ActiveRecordType.$$$reportNull$$$0(16);
            }
            return rEmptyType;
        }
        if (dataType.equals("bigint") || dataType.equals("integer")) {
            RType rType = RTypeFactory.createIntType(project);
            if (rType == null) {
                ActiveRecordType.$$$reportNull$$$0(17);
            }
            return rType;
        }
        if (dataType.equals("binary") || dataType.equals("string") || dataType.equals("text") || dataType.equals("uuid")) {
            RType rType = RTypeFactory.createStringType(project);
            if (rType == null) {
                ActiveRecordType.$$$reportNull$$$0(18);
            }
            return rType;
        }
        if (dataType.equals("boolean")) {
            RType rType = RTypeFactory.createBoolType(project);
            if (rType == null) {
                ActiveRecordType.$$$reportNull$$$0(19);
            }
            return rType;
        }
        if (dataType.equals("date")) {
            RType rType = RTypeFactory.createTypeByFQN(project, "Date");
            if (rType == null) {
                ActiveRecordType.$$$reportNull$$$0(20);
            }
            return rType;
        }
        if (dataType.equals("datetime") || dataType.equals("time") || dataType.equals("timestamp")) {
            RType rType = RTypeFactory.createTypeByFQN(project, "ActiveSupport::TimeWithZone");
            if (rType == null) {
                ActiveRecordType.$$$reportNull$$$0(21);
            }
            return rType;
        }
        if (dataType.equals("decimal") || dataType.equals("numeric")) {
            RType rType = RTypeFactory.createTypeByFQN(project, "BigDecimal");
            if (rType == null) {
                ActiveRecordType.$$$reportNull$$$0(22);
            }
            return rType;
        }
        if (dataType.equals("float")) {
            RType rType = RTypeFactory.createFloatType(project);
            if (rType == null) {
                ActiveRecordType.$$$reportNull$$$0(23);
            }
            return rType;
        }
        if (dataType.equals("point") && (pointType = ActiveRecordType.getActiveRecordPointType(project)) != null) {
            RType rType = pointType;
            if (rType == null) {
                ActiveRecordType.$$$reportNull$$$0(24);
            }
            return rType;
        }
        REmptyType rEmptyType = REmptyType.INSTANCE;
        if (rEmptyType == null) {
            ActiveRecordType.$$$reportNull$$$0(25);
        }
        return rEmptyType;
    }

    @Nullable
    private static RType getActiveRecordPointType(@NotNull Project project) {
        RubyCallType rubyCallType;
        RConstant constant;
        if (project == null) {
            ActiveRecordType.$$$reportNull$$$0(26);
        }
        if ((constant = (RConstant)RubyConstantDeclarationFqnIndex.getInstance().findElement(project, (SearchScope)GlobalSearchScope.allScope((Project)project), "ActiveRecord::Point")) == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)constant, RContainer.class);
        RCall call = (RCall)PsiTreeUtil.getStubChildOfType((PsiElement)parent, RCall.class);
        if (call == null || !((rubyCallType = call.getCallType()) instanceof StructNewCallTypeImpl)) {
            return null;
        }
        StructNewCallTypeImpl structNewCallType = (StructNewCallTypeImpl)rubyCallType;
        FQN fqn = (FQN)ContainerUtil.getFirstItem((List)((List)call.getData(new RubyCallType[]{structNewCallType})));
        if (fqn == null) {
            return null;
        }
        Symbol symbol = SymbolUtil.findConstantByFQN(project, RObjectClass.makeNonSingletonClassFqn((FQN)fqn), null);
        if (symbol != null) {
            return new RSymbolTypeImpl(symbol);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/ActiveRecordType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/ActiveRecordType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createThis";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupForMember";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByDataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMemberForName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createThis";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processMembersForPrefix";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGroupForMember";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByDataType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getActiveRecordPointType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }

    private class FindByCompletionPrefix {
        @NotNull
        private final List<String> myColumnsInPrefix = new ArrayList<String>();
        private int myCompleteColumnsInPrefix = 0;
        private String myPrefixOfCompleteColumns = null;
        private String myFindByPrefix;
        @NonNls
        private static final String AND_INFIX = "_and_";

        private FindByCompletionPrefix() {
        }

        public void parsePrefix(String prefix, @Nullable Collection<MigrationField> fields) {
            this.myFindByPrefix = ActiveRecordType.this.getFindByPrefix(prefix);
            if (this.myFindByPrefix != null) {
                String prefixTail = prefix.substring(this.myFindByPrefix.length());
                if (!prefixTail.isEmpty()) {
                    int pos;
                    while ((pos = prefixTail.indexOf(AND_INFIX)) >= 0) {
                        this.myColumnsInPrefix.add(prefixTail.substring(0, pos));
                        prefixTail = prefixTail.substring(pos + 5);
                    }
                    this.myColumnsInPrefix.add(prefixTail);
                }
                if (fields != null) {
                    this.validateColumns(fields);
                }
            }
        }

        public String getPrefixOfCompleteColumns() {
            return this.myPrefixOfCompleteColumns;
        }

        public List<String> getPrefixesForField() {
            if (this.myPrefixOfCompleteColumns != null) {
                if (this.myCompleteColumnsInPrefix > 0) {
                    return Collections.singletonList(this.myPrefixOfCompleteColumns + AND_INFIX);
                }
                return Collections.singletonList(this.myPrefixOfCompleteColumns);
            }
            return ActiveRecordType.this.getFinderPrefixes();
        }

        private void validateColumns(Collection<MigrationField> fields) {
            this.myPrefixOfCompleteColumns = this.myFindByPrefix;
            for (String col : this.myColumnsInPrefix) {
                if (!FindByCompletionPrefix.isCorrectColumn(fields, col)) break;
                if (this.myCompleteColumnsInPrefix > 0) {
                    this.myPrefixOfCompleteColumns = this.myPrefixOfCompleteColumns + AND_INFIX;
                }
                this.myPrefixOfCompleteColumns = this.myPrefixOfCompleteColumns + col;
                ++this.myCompleteColumnsInPrefix;
            }
        }

        private static boolean isCorrectColumn(Collection<MigrationField> fields, String col) {
            for (MigrationField field : fields) {
                if (!col.equals(field.getName())) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public List<String> getColumnsInPrefix() {
            List<String> list = this.myColumnsInPrefix;
            if (list == null) {
                FindByCompletionPrefix.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/rails/codeInsight/ActiveRecordType$FindByCompletionPrefix", "getColumnsInPrefix"));
        }
    }

    public static class DynamicFinder
    extends RTypedSyntheticSymbol {
        public DynamicFinder(Project project, @Nullable String name, Type type, @Nullable Symbol parent, @NotNull RType returnType, @NotNull List<String> columns, @Nullable PsiElement declaration) {
            if (returnType == null) {
                DynamicFinder.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                DynamicFinder.$$$reportNull$$$0(1);
            }
            super(project, name, type, parent, returnType, DynamicFinder.createArgumentInfos(columns), declaration);
        }

        private static List<ArgumentInfo> createArgumentInfos(List<String> columns) {
            ArrayList<ArgumentInfo> result = new ArrayList<ArgumentInfo>();
            for (String column : columns) {
                result.add(new ArgumentInfo(column, ArgumentInfo.Type.SIMPLE));
            }
            result.add(new ArgumentInfo("options", ArgumentInfo.Type.HASH));
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "returnType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "columns";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/ActiveRecordType$DynamicFinder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GroupBySymbolType {
        private final RubyCompletionGrouping myGroup;
        private final Type myType;

        GroupBySymbolType(RubyCompletionGrouping group, Type type) {
            this.myGroup = group;
            this.myType = type;
        }

        @Nullable
        public RubyCompletionGrouping getGroup(Symbol symbol) {
            return symbol.getType() == this.myType ? this.myGroup : null;
        }
    }
}

