/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.associations;

import com.intellij.openapi.module.Module;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.AssociatedItem;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.associations.AssociationFactory;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.rails.associations.RailsAssociationFactory;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.AssociationCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RailsAssociation
extends Association {
    private final AssociationFactory myFactory;
    private final Module myModule;
    private String myName;
    private final RCall myRCall;
    private final AssociatedItem myModel;
    private String myClassName;
    private boolean myIsPolymorphic;
    @Nullable
    private String myAs;
    @Nullable
    private String myThrough;

    public RailsAssociation(@NotNull Module module, AssociatedItem from, @NotNull RCall call) {
        if (module == null) {
            RailsAssociation.$$$reportNull$$$0(0);
        }
        if (call == null) {
            RailsAssociation.$$$reportNull$$$0(1);
        }
        this.myFactory = RailsAssociationFactory.getInstance();
        this.myAs = null;
        this.myThrough = null;
        this.myModule = module;
        this.myModel = from;
        this.myRCall = call;
        this.init();
    }

    public int hashCode() {
        return this.myRCall.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != RailsAssociation.class) {
            return false;
        }
        return this.myRCall.equals(((RailsAssociation)obj).myRCall);
    }

    private void init() {
        RCall call = this.getRCall();
        this.myName = AssociationCallType.getName((RPossibleCall)call);
        this.myClassName = AssociationCallType.getClassNameFqn((RPossibleCall)call).getFullPath();
        this.myIsPolymorphic = AssociationCallType.isPolymorphic((RPossibleCall)call);
        this.myAs = AssociationCallType.getAs((RPossibleCall)call);
        this.myThrough = AssociationCallType.getThrough((RPossibleCall)call);
    }

    @Override
    public AssociationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public String getName() {
        return this.myName != null ? this.myName : "";
    }

    @Override
    public AssociatedItem getItem() {
        return this.myModel;
    }

    @Override
    @NotNull
    public List<AssociatedItem> getResolvedItems() {
        return new ArrayList<AssociatedItem>(this.resolveToModels());
    }

    @Override
    @NotNull
    public RCall getRCall() {
        RCall rCall = this.myRCall;
        if (rCall == null) {
            RailsAssociation.$$$reportNull$$$0(2);
        }
        return rCall;
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    @NotNull
    public List<AssociatedItem> getThroughModels() {
        if (this.myThrough != null) {
            List list = ContainerUtil.map(AssociationsUtil.findThroughModels(this.myModule, this.getRCall(), this.myThrough, new HashSet<RCall>()), this.myFactory::createAssociatedItem);
            if (list == null) {
                RailsAssociation.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<AssociatedItem> list = Collections.emptyList();
        if (list == null) {
            RailsAssociation.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @Nullable
    public String getAs() {
        return this.myAs;
    }

    @Override
    public boolean isPolymorphic() {
        return this.myIsPolymorphic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/associations/RailsAssociation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/associations/RailsAssociation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRCall";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThroughModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

