/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.associations;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.mongoid.MongoidCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.associations.AssociationType;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.AssociationCallType;
import org.jetbrains.plugins.ruby.rails.lang.psi.stubs.indexes.RailsPolymorphicAssociationRefereeIndex;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ArgumentFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyInheritanceIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class AssociationsUtil {
    private AssociationsUtil() {
    }

    @Nullable
    public static RCall findAssociation(@NotNull Symbol modelSymbol, @NotNull String name, @Nullable PsiElement invocationPoint) {
        if (modelSymbol == null) {
            AssociationsUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AssociationsUtil.$$$reportNull$$$0(1);
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        AssociationsUtil.processAssociations(modelSymbol, name, invocationPoint, (Processor<? super RCall>)finder);
        return (RCall)finder.getFoundValue();
    }

    @NotNull
    public static Set<RClass> findAndResolveAssociation(@NotNull Symbol modelSymbol, @NotNull String name, @Nullable PsiElement invocationPoint) {
        RCall association;
        if (modelSymbol == null) {
            AssociationsUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            AssociationsUtil.$$$reportNull$$$0(3);
        }
        if ((association = AssociationsUtil.findAssociation(modelSymbol, name, invocationPoint)) == null) {
            Set<RClass> set = Collections.emptySet();
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(4);
            }
            return set;
        }
        return AssociationsUtil.resolveToModels(association);
    }

    @Nullable
    public static RClass resolveToModel(@NotNull RCall association) {
        if (association == null) {
            AssociationsUtil.$$$reportNull$$$0(5);
        }
        return (RClass)ContainerUtil.getFirstItem(AssociationsUtil.resolveToModels(association));
    }

    @NotNull
    public static Set<RClass> resolveToModels(@NotNull RCall association) {
        Module module;
        if (association == null) {
            AssociationsUtil.$$$reportNull$$$0(6);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)association)) == null) {
            Set<RClass> set = Collections.emptySet();
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(7);
            }
            return set;
        }
        InflectorService inflector = InflectorService.getInstance(module);
        if (inflector == null || !inflector.isInflectorAvailable()) {
            Set<RClass> set = Collections.emptySet();
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(8);
            }
            return set;
        }
        return AssociationsUtil.resolveToModelsImpl(module, association, new HashSet<RCall>());
    }

    public static boolean processAssociations(@NotNull Symbol modelSymbol, @Nullable PsiElement invocationPoint, @NotNull Processor<? super RCall> processor) {
        if (modelSymbol == null) {
            AssociationsUtil.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            AssociationsUtil.$$$reportNull$$$0(10);
        }
        return AssociationsUtil.processAssociations(modelSymbol, null, invocationPoint, processor);
    }

    public static boolean processAssociations(@NotNull Symbol modelSymbol, final @Nullable String name, final @Nullable PsiElement invocationPoint, @NotNull Processor<? super RCall> processor) {
        if (modelSymbol == null) {
            AssociationsUtil.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            AssociationsUtil.$$$reportNull$$$0(12);
        }
        final CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
        return SymbolHierarchy.processSymbolChildren(modelSymbol, new SymbolProcessor(){

            @Override
            public boolean process(@NotNull Symbol symbol) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                RCall call = ArgumentFakePsiElement.getCallByArgument((PsiElement)symbol.getPsiElement());
                return call == null || !(call.getCallType() instanceof AssociationCallType) || uniqueProcessor.process((Object)call);
            }

            @Override
            @Nullable
            public String getName() {
                return name;
            }

            @Override
            @Nullable
            public PsiElement getInvocationPoint() {
                return invocationPoint;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/rails/associations/AssociationsUtil$1", "process"));
            }
        });
    }

    @NotNull
    private static Set<RClass> resolveToModelsImpl(@NotNull Module module, @NotNull RCall association, @NotNull Set<RCall> visited) {
        FQN name;
        if (module == null) {
            AssociationsUtil.$$$reportNull$$$0(13);
        }
        if (association == null) {
            AssociationsUtil.$$$reportNull$$$0(14);
        }
        if (visited == null) {
            AssociationsUtil.$$$reportNull$$$0(15);
        }
        if (!visited.add(association)) {
            Set<RClass> set = Collections.emptySet();
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(16);
            }
            return set;
        }
        String associationName = AssociationCallType.getName((RPossibleCall)association);
        AssociationType associationType = AssociationsUtil.getAssociationType(association);
        if (associationName == null) {
            Set<RClass> set = Collections.emptySet();
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(17);
            }
            return set;
        }
        FQN className = AssociationCallType.getClassNameFqn((RPossibleCall)association);
        if (className != FQN.INVALID) {
            Set set = ContainerUtil.createMaybeSingletonSet((Object)AssociationsUtil.findModel(className, module, (PsiElement)association));
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(18);
            }
            return set;
        }
        FQN sourceType = AssociationCallType.getSourceTypeFqn((RPossibleCall)association);
        if (sourceType != FQN.INVALID) {
            Set set = ContainerUtil.createMaybeSingletonSet((Object)AssociationsUtil.findModel(sourceType, module, (PsiElement)association));
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(19);
            }
            return set;
        }
        String through = AssociationCallType.getThrough((RPossibleCall)association);
        if (through != null) {
            if (associationType.allowsThrough()) {
                String source = AssociationCallType.getSource((RPossibleCall)association);
                return AssociationsUtil.resolveThrough(module, association, through, (String)ObjectUtils.coalesce((Object)source, (Object)associationName), visited);
            }
            Set<RClass> set = Collections.emptySet();
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(20);
            }
            return set;
        }
        if (associationType == AssociationType.BELONGS_TO && AssociationCallType.isPolymorphic((RPossibleCall)association)) {
            Project project = module.getProject();
            GlobalSearchScope searchScope = association.getResolveScope();
            Set<RClass> set = RailsPolymorphicAssociationRefereeIndex.getInstance().getElements(project, (SearchScope)searchScope, associationName).stream().map(RubyPsiUtilCore::getContainingRClassOrModule).flatMap(container -> {
                if (container instanceof RClass) {
                    return Stream.of((RClass)container);
                }
                if (container instanceof RModule) {
                    return RubyInheritanceIndex.getInstance().getElements(project, (SearchScope)searchScope, container.getFQNWithNesting()).stream().map(RubyPsiUtil::getContainingRClass).filter(Objects::nonNull);
                }
                return null;
            }).collect(Collectors.toSet());
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(21);
            }
            return set;
        }
        FQN fQN = name = AssociationsUtil.isSingularAssociation(association) ? FQN.of((String)NamingConventions.toCamelCase((String)associationName, (Module)module)) : AssociationsUtil.classify(module, associationName);
        if (name != FQN.INVALID) {
            Set set = ContainerUtil.createMaybeSingletonSet((Object)AssociationsUtil.findModel(name, module, (PsiElement)association));
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(22);
            }
            return set;
        }
        Set<RClass> set = Collections.emptySet();
        if (set == null) {
            AssociationsUtil.$$$reportNull$$$0(23);
        }
        return set;
    }

    @Nullable
    public static String singularize(@NotNull Module module, @NotNull String name) {
        InflectorService service;
        if (module == null) {
            AssociationsUtil.$$$reportNull$$$0(24);
        }
        if (name == null) {
            AssociationsUtil.$$$reportNull$$$0(25);
        }
        return (service = InflectorService.getInstance(module)) != null && service.isInflectorAvailable() ? service.singularize(name) : null;
    }

    @Nullable
    public static String pluralize(@NotNull Module module, @NotNull String name) {
        InflectorService service;
        if (module == null) {
            AssociationsUtil.$$$reportNull$$$0(26);
        }
        if (name == null) {
            AssociationsUtil.$$$reportNull$$$0(27);
        }
        return (service = InflectorService.getInstance(module)) != null && service.isInflectorAvailable() ? service.pluralize(name) : null;
    }

    @NotNull
    public static FQN classify(@NotNull Module module, @NotNull String name) {
        InflectorService service;
        if (module == null) {
            AssociationsUtil.$$$reportNull$$$0(28);
        }
        if (name == null) {
            AssociationsUtil.$$$reportNull$$$0(29);
        }
        if ((service = InflectorService.getInstance(module)) == null || !service.isInflectorAvailable()) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                AssociationsUtil.$$$reportNull$$$0(30);
            }
            return fQN;
        }
        FQN fQN = FQN.ofNullable((String)service.classify(name));
        if (fQN == null) {
            AssociationsUtil.$$$reportNull$$$0(31);
        }
        return fQN;
    }

    @NotNull
    private static Set<RClass> resolveThrough(@NotNull Module module, @NotNull RCall resolvee, @NotNull String through, @NotNull String source, @NotNull Set<RCall> visited) {
        if (module == null) {
            AssociationsUtil.$$$reportNull$$$0(32);
        }
        if (resolvee == null) {
            AssociationsUtil.$$$reportNull$$$0(33);
        }
        if (through == null) {
            AssociationsUtil.$$$reportNull$$$0(34);
        }
        if (source == null) {
            AssociationsUtil.$$$reportNull$$$0(35);
        }
        if (visited == null) {
            AssociationsUtil.$$$reportNull$$$0(36);
        }
        Set<RClass> set = AssociationsUtil.findThroughModels(module, resolvee, through, visited).stream().flatMap(model -> AssociationsUtil.findAndResolve(module, resolvee, model, source, visited).stream()).collect(Collectors.toSet());
        if (set == null) {
            AssociationsUtil.$$$reportNull$$$0(37);
        }
        return set;
    }

    @NotNull
    public static Set<RClass> findThroughModels(@NotNull Module module, @NotNull RCall resolvee, @NotNull String through, @NotNull Set<RCall> visited) {
        RClass clazz;
        if (module == null) {
            AssociationsUtil.$$$reportNull$$$0(38);
        }
        if (resolvee == null) {
            AssociationsUtil.$$$reportNull$$$0(39);
        }
        if (through == null) {
            AssociationsUtil.$$$reportNull$$$0(40);
        }
        if (visited == null) {
            AssociationsUtil.$$$reportNull$$$0(41);
        }
        Set<RClass> set = (clazz = RubyPsiUtil.getContainingRClass((PsiElement)resolvee)) != null ? AssociationsUtil.findAndResolve(module, resolvee, clazz, through, visited) : Collections.emptySet();
        if (set == null) {
            AssociationsUtil.$$$reportNull$$$0(42);
        }
        return set;
    }

    @Nullable
    public static RClass findModel(@NotNull FQN modelFqn, @NotNull Module module, @NotNull PsiElement invocationPoint) {
        if (modelFqn == null) {
            AssociationsUtil.$$$reportNull$$$0(43);
        }
        if (module == null) {
            AssociationsUtil.$$$reportNull$$$0(44);
        }
        if (invocationPoint == null) {
            AssociationsUtil.$$$reportNull$$$0(45);
        }
        Project project = module.getProject();
        if (modelFqn.getCallerFQN() != FQN.INVALID) {
            RClass clazz = (RClass)ObjectUtils.tryCast((Object)RubyFQNUtil.findContainerByFQN(project, SymbolUtil.getClassTypes(), modelFqn, null), RClass.class);
            return ActiveRecordModel.isActiveRecordClass(clazz) ? clazz : null;
        }
        return (RClass)ReadAction.compute(() -> (RElementWithFQN)RubyClassModuleNameIndex.getInstance().findElement(project, (SearchScope)invocationPoint.getResolveScope(), modelFqn.getShortName(), it -> {
            RClass clazz;
            return it instanceof RClass && ActiveRecordModel.isActiveRecordClass(clazz = (RClass)it);
        }));
    }

    @NotNull
    private static Set<RClass> findAndResolve(final @NotNull Module module, final @NotNull RCall resolvee, @NotNull RClass clazz, final @NotNull String associationName, @NotNull Set<RCall> visited) {
        Symbol modelSymbol;
        if (module == null) {
            AssociationsUtil.$$$reportNull$$$0(46);
        }
        if (resolvee == null) {
            AssociationsUtil.$$$reportNull$$$0(47);
        }
        if (clazz == null) {
            AssociationsUtil.$$$reportNull$$$0(48);
        }
        if (associationName == null) {
            AssociationsUtil.$$$reportNull$$$0(49);
        }
        if (visited == null) {
            AssociationsUtil.$$$reportNull$$$0(50);
        }
        if ((modelSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)clazz)) == null) {
            Set<RClass> set = Collections.emptySet();
            if (set == null) {
                AssociationsUtil.$$$reportNull$$$0(51);
            }
            return set;
        }
        CommonProcessors.FindProcessor<RCall> finder = new CommonProcessors.FindProcessor<RCall>(){

            protected boolean accept(@NotNull RCall call) {
                if (call == null) {
                    2.$$$reportNull$$$0(0);
                }
                return AssociationsUtil.isMatchingAssociationCall(module, resolvee, associationName, call);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/ruby/rails/associations/AssociationsUtil$2", "accept"));
            }
        };
        AssociationsUtil.processAssociations(modelSymbol, (PsiElement)resolvee, (Processor<? super RCall>)finder);
        RCall candidate = (RCall)finder.getFoundValue();
        Set<RClass> set = candidate != null ? AssociationsUtil.resolveToModelsImpl(module, candidate, visited) : Collections.emptySet();
        if (set == null) {
            AssociationsUtil.$$$reportNull$$$0(52);
        }
        return set;
    }

    public static boolean isMatchingAssociationCall(@NotNull Module module, @NotNull RCall resolvee, @NotNull String source, @NotNull RCall candidate) {
        if (module == null) {
            AssociationsUtil.$$$reportNull$$$0(53);
        }
        if (resolvee == null) {
            AssociationsUtil.$$$reportNull$$$0(54);
        }
        if (source == null) {
            AssociationsUtil.$$$reportNull$$$0(55);
        }
        if (candidate == null) {
            AssociationsUtil.$$$reportNull$$$0(56);
        }
        RubyCallType resolveeCallType = resolvee.getCallType();
        RubyCallType candidateCallType = candidate.getCallType();
        if (candidateCallType != resolveeCallType && candidateCallType != RailsCallTypeProvider.BELONGS_TO_CALL) {
            return false;
        }
        boolean result = Comparing.strEqual((String)source, (String)AssociationCallType.getName((RPossibleCall)candidate));
        return result |= resolveeCallType == RailsCallTypeProvider.HAS_MANY_CALL && Comparing.strEqual((String)AssociationsUtil.singularize(module, source), (String)AssociationCallType.getName((RPossibleCall)candidate));
    }

    public static boolean isSingularAssociation(@NotNull RCall association) {
        if (association == null) {
            AssociationsUtil.$$$reportNull$$$0(57);
        }
        return AssociationsUtil.getAssociationType(association).isSingular();
    }

    @NotNull
    public static AssociationType getAssociationType(@NotNull RCall call) {
        RubyCallType type;
        if (call == null) {
            AssociationsUtil.$$$reportNull$$$0(58);
        }
        if ((type = call.getCallType()) == RailsCallTypeProvider.HAS_ONE_CALL) {
            AssociationType associationType = AssociationType.HAS_ONE;
            if (associationType == null) {
                AssociationsUtil.$$$reportNull$$$0(59);
            }
            return associationType;
        }
        if (type == RailsCallTypeProvider.BELONGS_TO_CALL) {
            AssociationType associationType = AssociationType.BELONGS_TO;
            if (associationType == null) {
                AssociationsUtil.$$$reportNull$$$0(60);
            }
            return associationType;
        }
        if (type == RailsCallTypeProvider.HAS_AND_BELONGS_TO_MANY_CALL) {
            AssociationType associationType = AssociationType.HAS_AND_BELONGS_TO_MANY;
            if (associationType == null) {
                AssociationsUtil.$$$reportNull$$$0(61);
            }
            return associationType;
        }
        if (type == RailsCallTypeProvider.HAS_MANY_CALL) {
            AssociationType associationType = AssociationType.HAS_MANY;
            if (associationType == null) {
                AssociationsUtil.$$$reportNull$$$0(62);
            }
            return associationType;
        }
        if (type == MongoidCallTypeProvider.EMBEDS_MANY) {
            AssociationType associationType = AssociationType.EMBEDS_MANY;
            if (associationType == null) {
                AssociationsUtil.$$$reportNull$$$0(63);
            }
            return associationType;
        }
        if (type == MongoidCallTypeProvider.EMBEDS_ONE) {
            AssociationType associationType = AssociationType.EMBEDS_ONE;
            if (associationType == null) {
                AssociationsUtil.$$$reportNull$$$0(64);
            }
            return associationType;
        }
        if (type == MongoidCallTypeProvider.EMBEDDED_IN) {
            AssociationType associationType = AssociationType.EMBEDDED_IN;
            if (associationType == null) {
                AssociationsUtil.$$$reportNull$$$0(65);
            }
            return associationType;
        }
        AssociationType associationType = AssociationType.UNDEFINED;
        if (associationType == null) {
            AssociationsUtil.$$$reportNull$$$0(66);
        }
        return associationType;
    }

    @Nullable
    public static RPsiElement getAssociationNameElement(@NotNull RCall association) {
        if (association == null) {
            AssociationsUtil.$$$reportNull$$$0(67);
        }
        return association.getCallType() instanceof AssociationCallType ? (RPsiElement)ContainerUtil.getFirstItem((List)association.getArguments()) : null;
    }

    public static boolean isAssociationCall(@Nullable PsiElement element) {
        return element instanceof RCall && ((RCall)element).getCallType() instanceof AssociationCallType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 16, 17, 18, 19, 20, 21, 22, 23, 30, 31, 37, 42, 51, 52, 59, 60, 61, 62, 63, 64, 65, 66 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSymbol";
                break;
            }
            case 1: 
            case 3: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 37: 
            case 42: 
            case 51: 
            case 52: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/associations/AssociationsUtil";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 57: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "association";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 24: 
            case 26: 
            case 28: 
            case 32: 
            case 38: 
            case 44: 
            case 46: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: 
            case 36: 
            case 41: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 33: 
            case 39: 
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvee";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "through";
                break;
            }
            case 35: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFqn";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associationName";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/associations/AssociationsUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndResolveAssociation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToModels";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToModelsImpl";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveThrough";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "findThroughModels";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndResolve";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAssociation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAndResolveAssociation";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 37: 
            case 42: 
            case 51: 
            case 52: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveToModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveToModels";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processAssociations";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveToModelsImpl";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "singularize";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveThrough";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findThroughModels";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findModel";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findAndResolve";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingAssociationCall";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isSingularAssociation";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getAssociationType";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getAssociationNameElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 16, 17, 18, 19, 20, 21, 22, 23, 30, 31, 37, 42, 51, 52, 59, 60, 61, 62, 63, 64, 65, 66 -> new IllegalStateException(string);
        };
    }
}

