/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.navigation.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsNavigateFromProvider;
import org.jetbrains.plugins.ruby.rails.actions.navigation.providers.NavigateFromRoutesProvider;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsMailerTemplate;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;

public final class NavigateFromViewProvider
extends RailsNavigateFromProvider {
    @Override
    @Nullable
    public RailsModel modelBy(@NotNull PsiElement location) {
        if (location == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(0);
        }
        return (RailsModel)ObjectUtils.doIfCast((Object)this.viewOwnerBy(location), RailsController.class, RailsController::getModel);
    }

    @Override
    @Nullable
    public RailsViewOwner viewOwnerBy(@NotNull PsiElement location) {
        PsiFile file;
        if (location == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(1);
        }
        if ((file = location.getContainingFile()) == null) {
            return null;
        }
        RailsViewOwner viewOwner = (RailsViewOwner)ObjectUtils.doIfNotNull((Object)RailsView.fromFile(file), RailsBaseView::getViewOwner);
        RailsViewOwner mailerViewOwner = (RailsViewOwner)ObjectUtils.doIfNotNull((Object)RailsMailerTemplate.fromFile(file), RailsBaseView::getViewOwner);
        return (RailsViewOwner)ObjectUtils.coalesce((Object)viewOwner, (Object)mailerViewOwner);
    }

    @Override
    @Nullable
    public RailsAction viewOwnerActionBy(@NotNull PsiElement location) {
        PsiFile file;
        if (location == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(2);
        }
        if ((file = location.getContainingFile()) == null) {
            return null;
        }
        return (RailsAction)ObjectUtils.doIfNotNull((Object)RailsView.fromFile(file), RailsView::getAction);
    }

    @Override
    @Nullable
    public RailsHelper helperBy(@NotNull PsiElement location) {
        if (location == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(3);
        }
        return (RailsHelper)ObjectUtils.doIfCast((Object)this.viewOwnerBy(location), RailsController.class, RailsViewOwner::getHelper);
    }

    @Override
    @NotNull
    public List<? extends RailsBaseView> viewsBy(@NotNull PsiElement location, boolean includePartials) {
        if (location == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)RailsView.fromFile(location.getContainingFile()));
        if (list == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends RailsLayout> layoutsBy(@NotNull PsiElement location) {
        RailsViewOwner viewOwner;
        if (location == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(6);
        }
        List<Object> list = (viewOwner = this.viewOwnerBy(location)) != null ? viewOwner.getAllLayouts() : Collections.emptyList();
        if (list == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> layoutsFolderUrlsBy(@NotNull PsiElement location) {
        RailsViewOwner viewOwner;
        if (location == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(8);
        }
        List<String> list = (viewOwner = this.viewOwnerBy(location)) != null ? viewOwner.getLayoutsFolderUrls() : Collections.emptyList();
        if (list == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public PsiElement schemaBy(@NotNull PsiElement location) {
        ActiveRecordModel model;
        if (location == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(10);
        }
        if ((model = (ActiveRecordModel)ObjectUtils.doIfNotNull((Object)this.modelBy(location), ActiveRecordModel::fromModel)) == null) {
            return null;
        }
        return Optional.ofNullable(model.getSchemaCreateTableElement()).orElseGet(model::getSchemaFile);
    }

    @Override
    @Nullable
    public PsiElement routesBy(@NotNull PsiElement location) {
        RailsAction action;
        if (location == null) {
            NavigateFromViewProvider.$$$reportNull$$$0(11);
        }
        if ((action = this.viewOwnerActionBy(location)) != null && !action.getRoutes().isEmpty()) {
            return NavigateFromRoutesProvider.getBestRouteForNavigation(action.getRoutes());
        }
        RailsViewOwner viewOwner = this.viewOwnerBy(location);
        if (!(viewOwner instanceof RailsController)) {
            return null;
        }
        return NavigateFromRoutesProvider.getBestRouteForNavigation(((RailsController)viewOwner).getRoutes());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/navigation/providers/NavigateFromViewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/navigation/providers/NavigateFromViewProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "viewsBy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutsBy";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutsFolderUrlsBy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modelBy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "viewOwnerBy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "viewOwnerActionBy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "helperBy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "viewsBy";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "layoutsBy";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "layoutsFolderUrlsBy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "schemaBy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "routesBy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9 -> new IllegalStateException(string);
        };
    }
}

