/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.navigation.providers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsNavigateFromProvider;
import org.jetbrains.plugins.ruby.rails.actions.navigation.providers.NavigateFromControllerProvider;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.routes.RoutesParser;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;

public final class NavigateFromRoutesProvider
extends RailsNavigateFromProvider {
    private static final Comparator<PsiElement> ROUTES_COMPARATOR = Comparator.comparing(element -> !RubyPsiUtil.isCallWithCommand(element, "resource", "resources")).thenComparing(RubyPsiUtil.getRelativePositionComparator().reversed());

    @Override
    @Nullable
    public RailsModel modelBy(@NotNull PsiElement location) {
        if (location == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(0);
        }
        return (RailsModel)ObjectUtils.doIfNotNull((Object)this.viewOwnerBy(location), RailsController::getModel);
    }

    @Override
    @Nullable
    public RailsController viewOwnerBy(@NotNull PsiElement location) {
        Module module;
        if (location == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)location)) == null) {
            return null;
        }
        RPossibleCall call = RCallNavigator.getRealCall((RPossibleCall)((RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)location, RPossibleCall.class)));
        if (call == null) {
            return null;
        }
        FQN fqn = RoutesParser.getInstance(module).getControllerFqn((PsiElement)ObjectUtils.coalesce((Object)RBlockCallNavigator.getByCall((RPsiElement)call), (Object)call));
        return RailsController.fromClassFullyQualifiedName(module, fqn);
    }

    @Override
    @Nullable
    public RailsAction viewOwnerActionBy(@NotNull PsiElement location) {
        Module module;
        if (location == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)location)) == null) {
            return null;
        }
        RPossibleCall call = RCallNavigator.getRealCall((RPossibleCall)((RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)location, RPossibleCall.class)));
        if (call == null) {
            return null;
        }
        List<FQN> fqns = RoutesParser.getInstance(module).getActionFqns((PsiElement)ObjectUtils.coalesce((Object)RBlockCallNavigator.getByCall((RPsiElement)call), (Object)call));
        return RailsAction.fromMethodFqn(module, (FQN)ContainerUtil.getOnlyItem(fqns, (Object)FQN.INVALID));
    }

    @Override
    @Nullable
    public RailsHelper helperBy(@NotNull PsiElement location) {
        if (location == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(3);
        }
        return (RailsHelper)ObjectUtils.doIfNotNull((Object)this.viewOwnerBy(location), RailsViewOwner::getHelper);
    }

    @Override
    @NotNull
    public List<? extends RailsBaseView> viewsBy(@NotNull PsiElement location, boolean includePartials) {
        Module module;
        if (location == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(4);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)location)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                NavigateFromRoutesProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        RailsController controller = this.viewOwnerBy(location);
        if (controller == null) {
            List list = Collections.emptyList();
            if (list == null) {
                NavigateFromRoutesProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        RPossibleCall call = RCallNavigator.getRealCall((RPossibleCall)((RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)location, RPossibleCall.class)));
        if (call == null) {
            List list = Collections.emptyList();
            if (list == null) {
                NavigateFromRoutesProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<? extends RailsBaseView> views = new ArrayList<RailsBaseView>();
        for (FQN fqn : RoutesParser.getInstance(module).getActionFqns((PsiElement)ObjectUtils.coalesce((Object)RBlockCallNavigator.getByCall((RPsiElement)call), (Object)call))) {
            RMethod method = controller.getAction(fqn.getShortName());
            views.addAll(NavigateFromControllerProvider.findViews((PsiElement)ObjectUtils.coalesce((Object)method, (Object)controller.getRClass()), false));
        }
        ArrayList<? extends RailsBaseView> arrayList = views;
        if (arrayList == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> viewsFolderUrlsBy(@NotNull PsiElement location) {
        RailsController controller;
        if (location == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(9);
        }
        List<String> list = (controller = this.viewOwnerBy(location)) != null ? controller.getViewsFolderUrls() : Collections.emptyList();
        if (list == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends RailsLayout> layoutsBy(@NotNull PsiElement location) {
        RailsController controller;
        if (location == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(11);
        }
        List<Object> list = (controller = this.viewOwnerBy(location)) != null ? controller.getAllLayouts() : Collections.emptyList();
        if (list == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> layoutsFolderUrlsBy(@NotNull PsiElement location) {
        RailsController controller;
        if (location == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(13);
        }
        List<String> list = (controller = this.viewOwnerBy(location)) != null ? controller.getLayoutsFolderUrls() : Collections.emptyList();
        if (list == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @Nullable
    public PsiElement schemaBy(@NotNull PsiElement location) {
        ActiveRecordModel model;
        if (location == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(15);
        }
        if ((model = (ActiveRecordModel)ObjectUtils.doIfNotNull((Object)this.modelBy(location), ActiveRecordModel::fromModel)) == null) {
            return null;
        }
        return Optional.ofNullable(model.getSchemaCreateTableElement()).orElseGet(model::getSchemaFile);
    }

    @Nullable
    public static PsiElement getBestRouteForNavigation(@NotNull List<? extends PsiElement> routes) {
        if (routes == null) {
            NavigateFromRoutesProvider.$$$reportNull$$$0(16);
        }
        return routes.stream().min(ROUTES_COMPARATOR).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 10, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/navigation/providers/NavigateFromRoutesProvider";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/navigation/providers/NavigateFromRoutesProvider";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "viewsBy";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "viewsFolderUrlsBy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutsBy";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutsFolderUrlsBy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modelBy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "viewOwnerBy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "viewOwnerActionBy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "helperBy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "viewsBy";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "viewsFolderUrlsBy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "layoutsBy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "layoutsFolderUrlsBy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "schemaBy";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBestRouteForNavigation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 10, 12, 14 -> new IllegalStateException(string);
        };
    }
}

