/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTargetPopup;
import org.jetbrains.plugins.ruby.model.navigation.PsiFileSystemItemNavigationTarget;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsNavigateFromProvider;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.rails.model.RailsMailerMethod;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwnerAction;
import org.jetbrains.plugins.ruby.rails.templates.RailsCreateViewFileDialog;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public final class RailsGoToViewAction
extends CodeInsightAction {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new MyHandler();
    }

    protected void update(@NotNull Presentation presentation, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull DataContext dataContext, @Nullable String actionPlace) {
        if (presentation == null) {
            RailsGoToViewAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RailsGoToViewAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            RailsGoToViewAction.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            RailsGoToViewAction.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            RailsGoToViewAction.$$$reportNull$$$0(4);
        }
        super.update(presentation, project, editor, psiFile, dataContext, actionPlace);
        if ("MainMenu".equals(actionPlace)) {
            presentation.setText(RBundle.messagePointer((String)"rails.go.to.view.action.title.short"));
        } else if (!RailsGoToViewAction.getViews(psiFile, (PsiElement)ObjectUtils.coalesce((Object)BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)psiFile), (Object)psiFile)).isEmpty()) {
            presentation.setText(RBundle.messagePointer((String)"rails.go.to.view.action.title"));
        } else {
            presentation.setText(RBundle.messagePointer((String)"rails.go.to.view.action.title.create"));
        }
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiElement element;
        if (project == null) {
            RailsGoToViewAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RailsGoToViewAction.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            RailsGoToViewAction.$$$reportNull$$$0(7);
        }
        if (!RailsGoToViewAction.getViews(psiFile, element = (PsiElement)ObjectUtils.coalesce((Object)BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)psiFile), (Object)psiFile)).isEmpty()) {
            return true;
        }
        RailsViewOwnerAction action = RailsGoToViewAction.getActionMethod(element);
        return action != null && !action.getViewOwner().getViewsFolderUrls().isEmpty();
    }

    @Nullable
    private static RailsViewOwnerAction getActionMethod(@NotNull PsiElement element) {
        RMethod method;
        if (element == null) {
            RailsGoToViewAction.$$$reportNull$$$0(8);
        }
        if ((method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)element, RMethod.class)) == null) {
            return null;
        }
        final Ref contentHandledRef = new Ref((Object)false);
        method.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRCall(@NotNull RCall call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RubyPsiUtil.isCallWithCommand((PsiElement)call, "head", "render", "redirect_back", "redirect_to")) {
                    contentHandledRef.set((Object)true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/ruby/rails/actions/navigation/RailsGoToViewAction$1", "visitRCall"));
            }
        });
        if (((Boolean)contentHandledRef.get()).booleanValue()) {
            return null;
        }
        RailsAction action = RailsAction.fromMethod(method);
        if (action != null) {
            return !action.getViewOwner().isApplicationController() ? action : null;
        }
        return RailsMailerMethod.fromMethod(method);
    }

    @NotNull
    private static List<PsiFile> getViews(@NotNull PsiFile file, @NotNull PsiElement element) {
        if (file == null) {
            RailsGoToViewAction.$$$reportNull$$$0(9);
        }
        if (element == null) {
            RailsGoToViewAction.$$$reportNull$$$0(10);
        }
        ArrayList<PsiFile> views = new ArrayList<PsiFile>();
        for (RailsNavigateFromProvider provider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            for (PsiFile viewFile : ContainerUtil.mapNotNull(provider.viewsBy(element, false), RailsBaseView::getPsiFile)) {
                if (file.getManager().areElementsEquivalent((PsiElement)file, (PsiElement)viewFile)) continue;
                views.add(viewFile);
            }
        }
        List<PsiFile> list = Collections.unmodifiableList(views);
        if (list == null) {
            RailsGoToViewAction.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/navigation/RailsGoToViewAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/navigation/RailsGoToViewAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getViews";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActionMethod";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getViews";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }

    private static final class MyHandler
    implements CodeInsightActionHandler {
        private MyHandler() {
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            PsiElement element;
            List<PsiFile> views;
            if (project == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MyHandler.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                MyHandler.$$$reportNull$$$0(2);
            }
            if (!(views = RailsGoToViewAction.getViews(psiFile, element = (PsiElement)ObjectUtils.coalesce((Object)BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)psiFile), (Object)psiFile))).isEmpty()) {
                MyHandler.invokeNavigateToViews(editor, views);
                return;
            }
            RailsViewOwnerAction action = RailsGoToViewAction.getActionMethod(element);
            if (action != null) {
                MyHandler.invokeCreateView(project, action);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static void invokeCreateView(@NotNull Project project, @NotNull RailsViewOwnerAction action) {
            VirtualFile root;
            if (project == null) {
                MyHandler.$$$reportNull$$$0(3);
            }
            if (action == null) {
                MyHandler.$$$reportNull$$$0(4);
            }
            if ((root = action.getApp().getRailsApplicationRoot()) == null) {
                return;
            }
            String prefix = (String)ContainerUtil.getFirstItem(action.getViewOwner().getViewsFolderUrls());
            if (prefix == null) {
                return;
            }
            String filename = "%s/%s".formatted(FileUtil.getRelativePath((String)root.getUrl(), (String)prefix, (char)'/'), action.getName());
            String selectedTemplate = PropertiesComponent.getInstance((Project)project).getValue("RailsCreateViewFileDialog.DEFAULT_TEMPLATE");
            CreateFileFromTemplateDialog.FileCreator<? extends PsiFile> creator = RailsCreateViewFileDialog.fileCreator(project, root);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String template = Objects.requireNonNull(selectedTemplate);
                creator.createFile(RailsCreateViewFileDialog.inputSuggester(filename).getSuggestion(template), template);
                return;
            }
            RailsCreateViewFileDialog.builder(project, filename).show(selectedTemplate, creator, __ -> {});
        }

        private static void invokeNavigateToViews(@NotNull Editor editor, @NotNull List<PsiFile> views) {
            if (editor == null) {
                MyHandler.$$$reportNull$$$0(5);
            }
            if (views == null) {
                MyHandler.$$$reportNull$$$0(6);
            }
            NavigationTargetPopup.builder(ContainerUtil.map(views, PsiFileSystemItemNavigationTarget::new)).withTitle(RBundle.message((String)"rails.go.to.view.action.popup.title")).navigateOrShowInBestPositionFor(editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "views";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/navigation/RailsGoToViewAction$MyHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeCreateView";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeNavigateToViews";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

