/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators.actions.special;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorOptions;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorPanel;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsOptionsPane;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.AbstractGenerateForActiveRecordPanel;

public class GenerateScaffoldPanel
implements GeneratorPanel {
    private final ScaffoldOptionsPanel myOptionsPanel;
    private JPanel myContentPanel;
    private GeneratorsOptionsPane myGeneratorsOptionsPane;
    private LabeledComponent myGeneratorArgsComponent;
    private TextFieldWithAutoCompletion myGeneratorArgsTextField;
    private GeneratorOptions myOptions;
    private final Project myProject;
    private final Module myModule;

    public GenerateScaffoldPanel(String generatorName, Module module) {
        this.myModule = module;
        this.$$$setupUI$$$();
        this.myProject = module.getProject();
        this.myOptionsPanel = new ScaffoldOptionsPanel();
        if (GenerateScaffoldPanel.isRSpecScaffold(generatorName)) {
            this.myOptionsPanel.myCBSkipTimestamps.setEnabled(false);
            this.myOptionsPanel.myCBForcePlural.setEnabled(false);
        }
        this.myGeneratorArgsComponent.getLabel().setText(RBundle.message((String)"dialog.generate.scaffold.label.arguments.text.rails3"));
    }

    private static boolean isRSpecScaffold(String generatorName) {
        return "rspec_scaffold".equals(generatorName) || generatorName.startsWith("rspec:");
    }

    private void createUIComponents() {
        this.myGeneratorArgsComponent = this.createGeneratorArgsComponent();
    }

    private LabeledComponent<TextFieldWithAutoCompletion<String>> createGeneratorArgsComponent() {
        Ref generatorsArgsFieldWrapper = new Ref();
        LabeledComponent<TextFieldWithAutoCompletion<String>> myComponent = AbstractGenerateForActiveRecordPanel.createGeneratorArgsComponent(this.myModule.getProject(), RBundle.message((String)"dialog.generate.scaffold.label.arguments.text.rails3"), (Ref<? super TextFieldWithAutoCompletion>)generatorsArgsFieldWrapper);
        this.myGeneratorArgsTextField = (TextFieldWithAutoCompletion)generatorsArgsFieldWrapper.get();
        return myComponent;
    }

    @Override
    public void initPanel(@NotNull GeneratorOptions options, @NotNull Module module) {
        if (options == null) {
            GenerateScaffoldPanel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GenerateScaffoldPanel.$$$reportNull$$$0(1);
        }
        this.myOptions = options;
        this.myGeneratorsOptionsPane.initPanel(options, module);
        if (this.myOptionsPanel.myCBSkipTimestamps.isEnabled()) {
            this.myOptionsPanel.myCBSkipTimestamps.setSelected(options.MODEL_SKIP_TIMESTAMPS);
        }
        if (this.myOptionsPanel.myCBSkipMigration.isEnabled()) {
            this.myOptionsPanel.myCBSkipMigration.setSelected(options.MODEL_SKIP_MIGRATION);
        }
        if (this.myOptionsPanel.myCBForcePlural.isEnabled()) {
            this.myOptionsPanel.myCBForcePlural.setSelected(options.SCAFFOLD_FORCE_PLURAL);
        }
    }

    @Override
    @NotNull
    public JPanel getContent() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            GenerateScaffoldPanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    @Nullable
    public JComponent getOptionsPanel() {
        return this.myOptionsPanel.myPanel;
    }

    @Override
    @NotNull
    public String getGeneratorArgs() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.myGeneratorArgsTextField.getText().trim());
        if (this.myOptionsPanel.myCBSkipTimestamps.isSelected()) {
            GeneratorsUtil.GeneratorsCmdOption.MODEL_SKIP_TIMESTAMPS.addTo(buff);
        }
        if (this.myOptionsPanel.myCBSkipMigration.isSelected()) {
            GeneratorsUtil.GeneratorsCmdOption.MODEL_SKIP_MIGRATION.addTo(buff);
        }
        if (this.myOptionsPanel.myCBForcePlural.isSelected()) {
            GeneratorsUtil.GeneratorsCmdOption.SCAFFOLD_FORCE_PLURAL.addTo(buff);
        }
        buff.append(this.myGeneratorsOptionsPane.getGeneratorArgs());
        String string = buff.toString();
        if (string == null) {
            GenerateScaffoldPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String getDataToValidate() {
        return this.myGeneratorArgsTextField.getText().trim();
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        TextFieldWithAutoCompletion textFieldWithAutoCompletion = this.myGeneratorArgsTextField;
        if (textFieldWithAutoCompletion == null) {
            GenerateScaffoldPanel.$$$reportNull$$$0(4);
        }
        return textFieldWithAutoCompletion;
    }

    @Override
    public void saveSettings(Project project) {
        this.myGeneratorsOptionsPane.saveSettings(project, this.myOptions);
        if (this.myOptionsPanel.myCBSkipTimestamps.isEnabled()) {
            this.myOptions.MODEL_SKIP_TIMESTAMPS = this.myOptionsPanel.myCBSkipTimestamps.isSelected();
        }
        if (this.myOptionsPanel.myCBSkipMigration.isEnabled()) {
            this.myOptions.MODEL_SKIP_MIGRATION = this.myOptionsPanel.myCBSkipMigration.isSelected();
        }
        if (this.myOptionsPanel.myCBForcePlural.isEnabled()) {
            this.myOptions.SCAFFOLD_FORCE_PLURAL = this.myOptionsPanel.myCBForcePlural.isSelected();
        }
    }

    @Override
    @NotNull
    public String getEnvironment() {
        String string = this.myGeneratorsOptionsPane.getEnvironment();
        if (string == null) {
            GenerateScaffoldPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        GeneratorsOptionsPane generatorsOptionsPane;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myGeneratorsOptionsPane = generatorsOptionsPane = new GeneratorsOptionsPane();
        jPanel.add((Component)generatorsOptionsPane, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        LabeledComponent labeledComponent = this.myGeneratorArgsComponent;
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", GenerateScaffoldPanel.class).getString("dialog.generate.scaffold.label.arguments.text"));
        jPanel.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/special/GenerateScaffoldPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/special/GenerateScaffoldPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorArgs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static class ScaffoldOptionsPanel {
        private JCheckBox myCBSkipTimestamps;
        private JCheckBox myCBSkipMigration;
        private JCheckBox myCBForcePlural;
        private JPanel myPanel;

        public ScaffoldOptionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JPanel jPanel;
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myCBSkipTimestamps = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/RBundle", ScaffoldOptionsPanel.class).getString("dialog.generate.model.cb.skip-timestamps"));
            jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCBSkipMigration = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/RBundle", ScaffoldOptionsPanel.class).getString("dialog.generate.model.cb.skip-migration"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCBForcePlural = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", ScaffoldOptionsPanel.class).getString("dialog.generate.scaffold.cb.force-plural"));
            jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

