/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators.actions.special;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.generators.GenerateDialogs;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorAction;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorInputValidator;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public abstract class GenerateScaffoldAction
extends SimpleGeneratorAction {
    public GenerateScaffoldAction(@NotNull String generatorName) {
        if (generatorName == null) {
            GenerateScaffoldAction.$$$reportNull$$$0(0);
        }
        super(() -> RBundle.message((String)"new.generate.scaffold.description"), AllIcons.Nodes.MultipleTypeDefinitions, generatorName);
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getGenerateDialogTitle(@Nullable Module module) {
        if (RModuleUtil.getInstance().isInMultiProject(module)) {
            return RBundle.message((String)"new.generate.scaffold.action.prompt.title.ex", (Object[])new Object[]{module.getName()});
        }
        return RBundle.message((String)"new.generate.scaffold.action.prompt.title");
    }

    @Override
    protected String getErrorTitle() {
        return RBundle.message((String)"new.generate.scaffold.error.title");
    }

    @Override
    protected PsiElement[] invokeDialog(@NotNull Module module, @Nullable PsiDirectory directory) {
        if (module == null) {
            GenerateScaffoldAction.$$$reportNull$$$0(1);
        }
        SimpleGeneratorInputValidator validator = this.createValidator(module, directory);
        GenerateDialogs.showGenerateScaffoldDialog(module, this.getGenerateDialogTitle(module), validator, this.getGeneratorName());
        return validator.getCreatedElements();
    }

    @Override
    protected SimpleGeneratorInputValidator createValidator(@NotNull Module module, @Nullable PsiDirectory directory) {
        if (module == null) {
            GenerateScaffoldAction.$$$reportNull$$$0(2);
        }
        return new SimpleGeneratorInputValidator(this, module, directory){

            @Override
            public boolean checkInput(String dataToValidate) {
                if (StringUtil.isEmpty((String)dataToValidate)) {
                    this.showErrorDialog(RBundle.message((String)"new.generate.common.error.script.arguments.should.be.specified"));
                    return false;
                }
                return true;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/special/GenerateScaffoldAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createValidator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TestUnitScaffold
    extends GenerateScaffoldAction {
        public TestUnitScaffold() {
            super("test_unit:scaffold");
        }
    }

    public static class ErbScaffold
    extends GenerateScaffoldAction {
        public ErbScaffold() {
            super("erb:scaffold");
        }
    }

    public static class NiftyScaffold
    extends GenerateScaffoldAction {
        public NiftyScaffold() {
            super("nifty_scaffold");
        }
    }

    public static class RspecScaffold
    extends GenerateScaffoldAction {
        public RspecScaffold() {
            super("rspec_scaffold");
        }
    }

    public static class Scaffold
    extends GenerateScaffoldAction {
        public Scaffold() {
            super("scaffold");
        }
    }
}

