/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators.actions.special;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.rails.actions.generators.GenerateDialogs;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorAction;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorInputValidator;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.GenerateModelPanel;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;

public abstract class GenerateModelAction
extends SimpleGeneratorAction {
    Module myModule;

    public GenerateModelAction(@NotNull String generatorName) {
        if (generatorName == null) {
            GenerateModelAction.$$$reportNull$$$0(0);
        }
        super(() -> RBundle.message((String)"new.generate.model.description"), RailsIcons.RAILS_MODEL_ICON, generatorName);
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getGenerateDialogTitle(@Nullable Module module) {
        if (RModuleUtil.getInstance().isInMultiProject(module)) {
            return RBundle.message((String)"new.generate.model.action.prompt.title.ex", (Object[])new Object[]{module.getName()});
        }
        return RBundle.message((String)"new.generate.model.action.prompt.title");
    }

    @Override
    protected String getErrorTitle() {
        return RBundle.message((String)"new.generate.model.error.title");
    }

    @Override
    protected PsiElement[] invokeDialog(@NotNull Module module, @Nullable PsiDirectory directory) {
        if (module == null) {
            GenerateModelAction.$$$reportNull$$$0(1);
        }
        this.myModule = module;
        SimpleGeneratorInputValidator validator = this.createValidator(module, directory);
        GenerateDialogs.showGenerateDialog(module, this.getGenerateDialogTitle(module), this.createModelPanel(module), validator);
        return validator.getCreatedElements();
    }

    protected GenerateModelPanel createModelPanel(Module module) {
        return new GenerateModelPanel(module.getProject());
    }

    @Override
    protected SimpleGeneratorInputValidator createValidator(@NotNull Module module, @Nullable PsiDirectory directory) {
        if (module == null) {
            GenerateModelAction.$$$reportNull$$$0(2);
        }
        return new SimpleGeneratorInputValidator(this, module, directory){

            @Override
            public boolean checkInput(String dataToValidate) {
                if (StringUtil.isEmpty((String)dataToValidate)) {
                    this.showErrorDialog(RBundle.message((String)"new.generate.common.error.script.arguments.should.be.specified"));
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateModelAction.$$$reportNull$$$0(3);
        }
        super.actionPerformed(e);
        this.myModule.getProject().getMessageBus().connect(RubyPluginUtil.getUnloadAwareDisposable(this.myModule)).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    PsiFile psiFile;
                    RailsPaths paths;
                    VirtualFile file;
                    if (!(vFileEvent instanceof VFileCreateEvent) || (file = vFileEvent.getFile()) == null || !VfsUtilCore.isUnderFiles((VirtualFile)file, (paths = RailsPaths.getInstance(GenerateModelAction.this.myModule)).findFiles("db/migrate")) || (psiFile = PsiManager.getInstance((Project)GenerateModelAction.this.myModule.getProject()).findFile(file)) == null) continue;
                    EditorHelper.openInEditor((PsiElement)psiFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/ruby/rails/actions/generators/actions/special/GenerateModelAction$2", "after"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/special/GenerateModelAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createValidator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TestUnitModel
    extends GenerateModelAction {
        public TestUnitModel() {
            super("test_unit:model");
        }
    }

    public static class ActiveRecordModel
    extends GenerateModelAction {
        public ActiveRecordModel() {
            super("active_record:model");
        }
    }

    public static class RspecModel
    extends GenerateModelAction {
        public RspecModel() {
            super("rspec_model");
        }
    }

    public static class Model
    extends GenerateModelAction {
        public Model() {
            super("model");
        }
    }
}

