/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators.actions.special;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.generators.GenerateDialogs;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorAction;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.ControllerInputValidator;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public abstract class GenerateControllerAction
extends SimpleGeneratorAction {
    public GenerateControllerAction(@NotNull String generatorName) {
        if (generatorName == null) {
            GenerateControllerAction.$$$reportNull$$$0(0);
        }
        super(() -> RBundle.message((String)"new.generate.controller.description"), AllIcons.Nodes.Controller, generatorName);
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getGenerateDialogTitle(@Nullable Module module) {
        if (RModuleUtil.getInstance().isInMultiProject(module)) {
            return RBundle.message((String)"new.generate.controller.action.prompt.title.ex", (Object[])new Object[]{module.getName()});
        }
        return RBundle.message((String)"new.generate.controller.action.prompt.title");
    }

    @Override
    protected String getErrorTitle() {
        return RBundle.message((String)"new.generate.controller.error.title");
    }

    @Override
    protected ControllerInputValidator createValidator(@NotNull Module module, @Nullable PsiDirectory directory) {
        if (module == null) {
            GenerateControllerAction.$$$reportNull$$$0(1);
        }
        return new ControllerInputValidator(this, module, directory);
    }

    @Override
    public void checkArgsBeforeInvoke(@NotNull String generatorArgs, @Nullable PsiDirectory directory) throws IncorrectOperationException {
        if (generatorArgs == null) {
            GenerateControllerAction.$$$reportNull$$$0(2);
        }
        super.checkArgsBeforeInvoke(generatorArgs, directory);
        StringTokenizer tk = new StringTokenizer(generatorArgs);
        if (!tk.hasMoreElements()) {
            throw new IncorrectOperationException(RBundle.message((String)"new.generate.common.error.script.arguments.should.be.specified"));
        }
    }

    @Override
    protected PsiElement[] invokeDialog(@NotNull Module module, @Nullable PsiDirectory directory) {
        if (module == null) {
            GenerateControllerAction.$$$reportNull$$$0(3);
        }
        ControllerInputValidator validator = this.createValidator(module, directory);
        GenerateDialogs.showGenerateControllerDialog(module, this.getGenerateDialogTitle(module), validator);
        return validator.getCreatedElements();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorArgs";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/actions/special/GenerateControllerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArgsBeforeInvoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TestUnitController
    extends GenerateControllerAction {
        public TestUnitController() {
            super("test_unit:controller");
        }
    }

    public static class ErbController
    extends GenerateControllerAction {
        public ErbController() {
            super("erb:controller");
        }
    }

    public static class RspecController
    extends GenerateControllerAction {
        public RspecController() {
            super("rspec_controller");
        }
    }

    public static class Controller
    extends GenerateControllerAction {
        public Controller() {
            super("controller");
        }
    }
}

