/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorOptions;
import org.jetbrains.plugins.ruby.rails.actions.generators.lexer._Generators30Lexer;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.run.BundlerMissingGemsProcessAdapter;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunnerOptions;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyScriptRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.settings.RProjectUtil;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;

public final class GeneratorsUtil {
    @NonNls
    public static final String GENERATE_SCRIPT = "script/generate";
    public static final String NIFTY_SCAFFOLD_GENERATOR_NAME = "nifty_scaffold";
    public static final String RSPEC_SCAFFOLD_GENERATOR_NAME = "rspec_scaffold";
    public static final String GENERATORS_SILENT_UPDATE = "GENERATORS_SILENT_UPDATE";
    private static final Logger LOG = Logger.getInstance(GeneratorsUtil.class);
    private static final Pattern ourCreatedPattern = Pattern.compile("create(\\s+)(.+\\.[\\w*]+)");

    private GeneratorsUtil() {
    }

    public static String[] buildParamsForRailsGenerator(@Nullable String generateScriptPath) {
        if (GeneratorsUtil.isSpringGenerator(generateScriptPath)) {
            return new String[]{"rails", "generate"};
        }
        return new String[]{"generate"};
    }

    private static boolean isSpringGenerator(@Nullable String generateScriptPath) {
        return generateScriptPath != null && generateScriptPath.endsWith("spring");
    }

    public static boolean isZeusGenerator(String generateScriptPath) {
        return generateScriptPath.endsWith("zeus");
    }

    @NotNull
    public static List<String> parseScriptGenerateOutput(@NotNull String buff) throws IOException {
        if (buff == null) {
            GeneratorsUtil.$$$reportNull$$$0(0);
        }
        _Generators30Lexer outputLexer = new _Generators30Lexer(null);
        outputLexer.reset(buff, 0, buff.length(), 0);
        String token = outputLexer.advance();
        HashSet<String> tokens = new HashSet<String>();
        while (token != null) {
            tokens.add(token);
            token = outputLexer.advance();
        }
        List<String> list = List.copyOf(tokens);
        if (list == null) {
            GeneratorsUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public static VirtualFile getGenerateScript(@NotNull Module module, boolean canUsePreloadServer) {
        String railsAppHomePath;
        if (module == null) {
            GeneratorsUtil.$$$reportNull$$$0(2);
        }
        if ((railsAppHomePath = RailsFacetUtil.getRailsAppHomeDirPath(module)) == null) {
            return null;
        }
        RailsApp railsApp = RailsApp.fromModule(module);
        assert (railsApp != null) : "Must have rails application here";
        Object generateScriptPath = canUsePreloadServer && !railsApp.isEngine() && PreLoadUtil.PreLoadServer.Zeus.isRunning(module) ? ZeusUtil.getZeusExecutable(module, RModuleUtil.getInstance().findRubySdkForModule(module)) : (canUsePreloadServer && !railsApp.isEngine() && SpringUtil.isExplicitSpringEnabled() && SpringUtil.isSpringAvailable(module) ? SpringUtil.getSpringExecutable(module, RModuleUtil.getInstance().findRubySdkForModule(module)) : railsAppHomePath + "/bin/rails");
        if (generateScriptPath == null) {
            return null;
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByPath((String)generateScriptPath);
    }

    public static void initOptionsCheckBoxes(@NotNull JCheckBox pretendCheckBox, @NotNull JCheckBox forceCheckBox, @NotNull JCheckBox skipCheckBox, @NotNull JCheckBox backtraceCheckBox, @NotNull JCheckBox svnCheckBox, @NotNull JCheckBox gitCheckBox, @NotNull ComboBox environment, @NotNull GeneratorOptions options) {
        if (pretendCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(3);
        }
        if (forceCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(4);
        }
        if (skipCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(5);
        }
        if (backtraceCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(6);
        }
        if (svnCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(7);
        }
        if (gitCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(8);
        }
        if (environment == null) {
            GeneratorsUtil.$$$reportNull$$$0(9);
        }
        if (options == null) {
            GeneratorsUtil.$$$reportNull$$$0(10);
        }
        pretendCheckBox.setSelected(options.PRETEND);
        forceCheckBox.setSelected(options.FORCE);
        skipCheckBox.setSelected(options.SKIP);
        backtraceCheckBox.setSelected(options.BACK_TRACE);
        environment.setSelectedItem((Object)(StringUtil.isEmpty((String)options.ENVIRONMENT) ? "development" : options.ENVIRONMENT));
        svnCheckBox.setVisible(false);
        gitCheckBox.setVisible(false);
    }

    public static void saveSettings(@NotNull JCheckBox pretendCheckBox, @NotNull JCheckBox forceCheckBox, @NotNull JCheckBox skipCheckBox, @NotNull JCheckBox backtraceCheckBox, @NotNull JCheckBox svnCheckBox, @NotNull JCheckBox gitCheckBox, @NotNull ComboBox environment, @NotNull GeneratorOptions options, @NotNull Project project) {
        if (pretendCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(11);
        }
        if (forceCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(12);
        }
        if (skipCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(13);
        }
        if (backtraceCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(14);
        }
        if (svnCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(15);
        }
        if (gitCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(16);
        }
        if (environment == null) {
            GeneratorsUtil.$$$reportNull$$$0(17);
        }
        if (options == null) {
            GeneratorsUtil.$$$reportNull$$$0(18);
        }
        if (project == null) {
            GeneratorsUtil.$$$reportNull$$$0(19);
        }
        options.PRETEND = pretendCheckBox.isSelected();
        options.FORCE = forceCheckBox.isSelected();
        options.SKIP = skipCheckBox.isSelected();
        options.BACK_TRACE = backtraceCheckBox.isSelected();
        options.ENVIRONMENT = (String)environment.getSelectedItem();
        if (RProjectUtil.isVcsAddShowConfirmation(project)) {
            options.SVN = svnCheckBox.isSelected();
            options.GIT = gitCheckBox.isSelected();
        }
    }

    public static String calcGeneralOptionsString(@NotNull JCheckBox backtraceCheckBox, @NotNull JCheckBox forceCheckBox, @NotNull JCheckBox pretendCheckBox, @NotNull JCheckBox skipCheckBox, @NotNull JCheckBox svnCheckBox, @NotNull JCheckBox gitCheckBox) {
        if (backtraceCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(20);
        }
        if (forceCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(21);
        }
        if (pretendCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(22);
        }
        if (skipCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(23);
        }
        if (svnCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(24);
        }
        if (gitCheckBox == null) {
            GeneratorsUtil.$$$reportNull$$$0(25);
        }
        StringBuilder buff = new StringBuilder();
        if (backtraceCheckBox.isSelected()) {
            GeneratorsCmdOption.BACKTRACE_CMD_OPTION.addTo(buff);
        }
        if (forceCheckBox.isSelected()) {
            GeneratorsCmdOption.FORCE_CMD_OPTION.addTo(buff);
        }
        if (pretendCheckBox.isSelected()) {
            GeneratorsCmdOption.PRETEND_CMD_OPTION.addTo(buff);
        }
        if (skipCheckBox.isSelected()) {
            GeneratorsCmdOption.SKIP_CMD_OPTION.addTo(buff);
        }
        if (svnCheckBox.isSelected()) {
            GeneratorsCmdOption.SVN_CMD_OPTION.addTo(buff);
        }
        if (gitCheckBox.isSelected()) {
            GeneratorsCmdOption.GIT_CMD_OPTION.addTo(buff);
        }
        return buff.toString();
    }

    public static void invokeGenerator(final Module module, String processTitle, @NlsContexts.DialogTitle String errorTitle, String[] scriptParameters, @Nullable RunContentDescriptorFactory descFactory, final @Nullable ThrowableRunnable<? extends RuntimeException> nextAction, @NotNull Sdk sdk, final @Nullable List<String> createdFiles, final @NotNull Ref<Integer> filesToOpenCount, @NotNull Map<String, String> envsMap) {
        if (sdk == null) {
            GeneratorsUtil.$$$reportNull$$$0(26);
        }
        if (filesToOpenCount == null) {
            GeneratorsUtil.$$$reportNull$$$0(27);
        }
        if (envsMap == null) {
            GeneratorsUtil.$$$reportNull$$$0(28);
        }
        try {
            FileDocumentManager.getInstance().saveAllDocuments();
            final @NonNls String msgSuffix = "Rails generator: " + StringUtil.join((String[])scriptParameters, (int)1, (int)scriptParameters.length, (String)" ");
            final Ref localHistoryAction = new Ref();
            ProcessListener listener = new ProcessListener(){
                private final StringBuffer myOutput = new StringBuffer();

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    localHistoryAction.set((Object)LocalHistory.getInstance().startAction(msgSuffix));
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (createdFiles != null) {
                        String prefix = null;
                        Matcher matcher = ourCreatedPattern.matcher(this.myOutput.toString());
                        while (matcher.find()) {
                            if (prefix == null) {
                                prefix = matcher.group(1);
                            }
                            if (prefix.length() == matcher.group(1).length()) {
                                createdFiles.add(0, matcher.group(2));
                                filesToOpenCount.set((Object)((Integer)filesToOpenCount.get() + 1));
                                continue;
                            }
                            createdFiles.add(matcher.group(2));
                        }
                    }
                    ((LocalHistoryAction)localHistoryAction.get()).finish();
                    localHistoryAction.set(null);
                    String homeDirPath = RailsFacetUtil.getRailsAppHomeDirPath(module);
                    if (homeDirPath == null) {
                        LOG.warn("Cannot refresh since Rails Application home directory was not found. Module [" + module.getName() + "] has " + (RailsFacetUtil.hasRailsSupport(module) ? "" : "no") + " Rails support.", new Throwable().fillInStackTrace());
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(homeDirPath);
                        if (virtualFile == null) {
                            return;
                        }
                        if (createdFiles != null) {
                            for (String filepath : createdFiles) {
                                LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.join((String[])new String[]{homeDirPath, filepath}));
                            }
                        }
                        if (nextAction != null) {
                            WriteAction.run((ThrowableRunnable)nextAction);
                        }
                    });
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    this.myOutput.append(event.getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsUtil$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            @NlsSafe String title = module.getName() + ": " + processTitle;
            MergingCommandLineArgumentsProvider provider = new MergingCommandLineArgumentsProvider(scriptParameters, null, null, envsMap);
            ConsoleRunnerOptions consoleRunnerOptions = ConsoleRunnerOptions.builder(module, title).withCmdlinePreprocessor(BundlerUtil.getBundlerPreprocessor(sdk, module)).withProcessListeners(listener).withProcessHandlerCustomizer(handler -> BundlerMissingGemsProcessAdapter.Companion.attach((ProcessHandler)handler, module)).withFilters(new RStackTraceFilter(module)).withWorkingDirectory(RailsFacetUtil.getRailsAppHomeDirPath(module)).withRunContentDescriptorFactory(descFactory).build();
            RubyScriptRunner.runRubyScriptInConsole(provider, sdk, consoleRunnerOptions);
        }
        catch (Exception exp) {
            RunnerUtil.showErrorMessage(module.getProject(), errorTitle, exp);
        }
    }

    public static void openFileInEditor(Project project, String relativePath, String railsAppHomeDirPath) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            File file = new File(railsAppHomeDirPath, relativePath);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                ReadAction.nonBlocking(() -> {
                    int offset = GeneratorsUtil.getOffset(PsiManager.getInstance((Project)project).findFile(virtualFile));
                    AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, offset).navigate(true));
                }).expireWith(RubyPluginUtil.getUnloadAwareDisposable(project)).executeSynchronously();
            }
        });
    }

    private static int getOffset(PsiFile file) {
        RPsiElement statement;
        List statements;
        if (file instanceof RFile && !(statements = ((RFile)file).getStatements()).isEmpty() && (statement = (RPsiElement)statements.get(0)) instanceof RClass) {
            RClass rClass = (RClass)statement;
            List classStatements = rClass.getStatements();
            if (classStatements.isEmpty()) {
                PsiElement eol = GeneratorsUtil.navigateToEol(PsiTreeUtil.getChildOfType((PsiElement)rClass, RBodyStatement.class));
                if (eol != null) {
                    return eol.getTextOffset();
                }
            } else {
                PsiElement eol;
                RPsiElement methodCandidate = (RPsiElement)classStatements.get(0);
                if (methodCandidate instanceof RMethod && (eol = GeneratorsUtil.navigateToEol(PsiTreeUtil.getChildOfType((PsiElement)methodCandidate, RBodyStatement.class))) != null) {
                    return eol.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Nullable
    private static PsiElement navigateToEol(PsiElement element) {
        while (element != null && !RubySpaceUtil.isEol((PsiElement)element)) {
            element = element.getPrevSibling();
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buff";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pretendCheckBox";
                break;
            }
            case 4: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forceCheckBox";
                break;
            }
            case 5: 
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCheckBox";
                break;
            }
            case 6: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backtraceCheckBox";
                break;
            }
            case 7: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnCheckBox";
                break;
            }
            case 8: 
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitCheckBox";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToOpenCount";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseScriptGenerateOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseScriptGenerateOutput";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGenerateScript";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initOptionsCheckBoxes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calcGeneralOptionsString";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "invokeGenerator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum GeneratorsCmdOption {
        BACKTRACE_CMD_OPTION("-t"),
        FORCE_CMD_OPTION("-f"),
        PRETEND_CMD_OPTION("-p"),
        SKIP_CMD_OPTION("-s"),
        SVN_CMD_OPTION("-c"),
        GIT_CMD_OPTION("-g"),
        MODEL_SKIP_TIMESTAMPS("--skip-timestamps"),
        MODEL_SKIP_MIGRATION("--skip-migration"),
        MODEL_SKIP_FIXTURE("--skip-fixture"),
        SCAFFOLD_FORCE_PLURAL("--force-plural"),
        NSCAFFOLD_HAML("--haml"),
        NSCAFFOLD_INVERT("--invert"),
        NSCAFFOLD_SKIP_CONTROLLER("--skip-controller"),
        NSCAFFOLD_SKIP_MODEL("--skip-model");

        private final String myOption;

        private GeneratorsCmdOption(String option) {
            this.myOption = option;
        }

        public String getValue() {
            return this.myOption;
        }

        public void addTo(StringBuilder buff) {
            buff.append(" ");
            buff.append(this.getValue());
        }
    }
}

