/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorOptions;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;

public class GeneratorsOptionsPane
extends JPanel {
    private final JCheckBox myPretendCheckBox;
    private final JCheckBox myForceCheckBox;
    private final JCheckBox mySkipCheckBox;
    private final JCheckBox myBacktraceCheckBox;
    private final JCheckBox mySVNCheckBox;
    private final JCheckBox myGITCheckBox;
    private final ComboBox myEnvironment;

    public GeneratorsOptionsPane() {
        this.setLayout(new BorderLayout());
        this.myEnvironment = new ComboBox();
        LabeledComponent environment = new LabeledComponent();
        environment.setText(RBundle.message((String)"rake.action.execute.task.dialog.rails.env.label"));
        environment.setLabelLocation("West");
        environment.setComponent((JComponent)this.myEnvironment);
        JPanel args = new JPanel(new FlowLayout(0));
        this.myPretendCheckBox = new JCheckBox(RBundle.message((String)"dialog.generate.common.checkBox.pretend.text"));
        this.myPretendCheckBox.setToolTipText(RBundle.message((String)"dialog.generate.common.checkBox.pretend.tooltip"));
        args.add(this.myPretendCheckBox);
        this.myForceCheckBox = new JCheckBox(RBundle.message((String)"dialog.generate.common.checkBox.force.text"));
        this.myForceCheckBox.setToolTipText(RBundle.message((String)"dialog.generate.common.checkBox.force.tooltip"));
        args.add(this.myForceCheckBox);
        this.mySkipCheckBox = new JCheckBox(RBundle.message((String)"dialog.generate.common.checkBox.skip.text"));
        this.mySkipCheckBox.setToolTipText(RBundle.message((String)"dialog.generate.common.checkBox.skip.tooltip"));
        args.add(this.mySkipCheckBox);
        this.myBacktraceCheckBox = new JCheckBox(RBundle.message((String)"dialog.generate.common.checkBox.backtrace.text"));
        this.myBacktraceCheckBox.setToolTipText(RBundle.message((String)"dialog.generate.common.checkBox.backtrace.tooltip"));
        args.add(this.myBacktraceCheckBox);
        this.mySVNCheckBox = new JCheckBox(RBundle.message((String)"dialog.generate.common.checkBox.svn.text"));
        this.mySVNCheckBox.setToolTipText(RBundle.message((String)"dialog.generate.common.checkBox.svn.tooltip"));
        args.add(this.mySVNCheckBox);
        this.myGITCheckBox = new JCheckBox(RBundle.message((String)"dialog.generate.common.checkBox.git.text"));
        this.myGITCheckBox.setToolTipText(RBundle.message((String)"dialog.generate.common.checkBox.git.tooltip"));
        args.add(this.myGITCheckBox);
        this.add((Component)environment, "North");
        this.add((Component)args, "South");
    }

    public void initPanel(@NotNull GeneratorOptions options, @NotNull Module module) {
        if (options == null) {
            GeneratorsOptionsPane.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GeneratorsOptionsPane.$$$reportNull$$$0(1);
        }
        this.myEnvironment.setModel(new DefaultComboBoxModel<String>(RailsUtil.getAllEnvironments(module)));
        GeneratorsUtil.initOptionsCheckBoxes(this.myPretendCheckBox, this.myForceCheckBox, this.mySkipCheckBox, this.myBacktraceCheckBox, this.mySVNCheckBox, this.myGITCheckBox, this.myEnvironment, options);
    }

    @NotNull
    public String getGeneratorArgs() {
        String string = GeneratorsUtil.calcGeneralOptionsString(this.myBacktraceCheckBox, this.myForceCheckBox, this.myPretendCheckBox, this.mySkipCheckBox, this.mySVNCheckBox, this.myGITCheckBox);
        if (string == null) {
            GeneratorsOptionsPane.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void saveSettings(Project project, GeneratorOptions options) {
        GeneratorsUtil.saveSettings(this.myPretendCheckBox, this.myForceCheckBox, this.mySkipCheckBox, this.myBacktraceCheckBox, this.mySVNCheckBox, this.myGITCheckBox, this.myEnvironment, options, project);
    }

    @NotNull
    public String getEnvironment() {
        String env = (String)this.myEnvironment.getSelectedItem();
        String string = StringUtil.isEmpty((String)env) ? "development" : env;
        if (string == null) {
            GeneratorsOptionsPane.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorArgs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initPanel";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

