/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HideableTitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorOptions;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorPanel;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.GeneratorHelpPanel;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorInputValidator;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorPanel;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.ActionContainerInputValidator;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.ChannelInputValidator;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.ControllerInputValidator;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.GenerateControllerPanel;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.GenerateNiftyScaffoldPanel;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.GenerateScaffoldPanel;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.settings.RProjectUtil;

public final class GenerateDialogs {
    private GenerateDialogs() {
    }

    public static int showGenerateControllerDialog(Module module, @NlsContexts.DialogTitle String title, ControllerInputValidator validator) {
        int result;
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            result = 0;
        } else {
            GenerateActionContainerDialog dialog = new GenerateActionContainerDialog(module, title, validator);
            dialog.show();
            result = dialog.getExitCode();
        }
        return result;
    }

    public static void showGenerateChannelDialog(Module module, @NlsContexts.DialogTitle String title, ChannelInputValidator validator) {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode() && !application.isHeadlessEnvironment()) {
            GenerateActionContainerDialog dialog = new GenerateActionContainerDialog(module, title, validator);
            dialog.show();
        }
    }

    public static int showGenerateDialog(Module module, @NlsContexts.DialogTitle String title, @NotNull GeneratorPanel contentPanel, SimpleGeneratorInputValidator validator) {
        int result;
        Application application;
        if (contentPanel == null) {
            GenerateDialogs.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment()) {
            result = 0;
        } else {
            SimpleGenerateDialog dialog = new SimpleGenerateDialog(module, title, contentPanel, validator);
            dialog.show();
            result = dialog.getExitCode();
        }
        return result;
    }

    public static int showGenerateScaffoldDialog(Module module, @NlsContexts.DialogTitle String title, SimpleGeneratorInputValidator validator, String generatorName) {
        int result;
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            result = 0;
        } else {
            GenerateScaffoldDialog dialog = new GenerateScaffoldDialog(module, title, validator, generatorName);
            dialog.show();
            result = dialog.getExitCode();
        }
        return result;
    }

    public static int showGenerateSupportConfigDialog(Module module, @NlsContexts.DialogTitle String title, SimpleGeneratorInputValidator validator) {
        int result;
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            result = 0;
        } else {
            GenerateSupportConfigDialog dialog = new GenerateSupportConfigDialog(module, title, validator);
            dialog.show();
            result = dialog.getExitCode();
        }
        return result;
    }

    public static int showGenerateDialog(Module module, @NlsContexts.DialogTitle String title, SimpleGeneratorInputValidator validator) {
        int result;
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            result = 0;
        } else {
            SimpleGenerateDialog dialog = new SimpleGenerateDialog(module, title, validator);
            dialog.show();
            result = dialog.getExitCode();
        }
        return result;
    }

    private static void showGeneratorHelpDialog(Project project, @NlsContexts.DialogTitle String title, ProcessOutput output2, GenerateDialog parent) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        GeneratorHelpDialog dialog = new GeneratorHelpDialog(project, title, output2);
        dialog.pack();
        Container contentPane = dialog.getContentPane();
        Dimension size = contentPane.getSize();
        contentPane.setPreferredSize(new Dimension(size.width, Math.min(size.height, 400)));
        dialog.setInitialLocationCallback(() -> new Point(parent.getLocation().x + parent.getSize().width + 10, parent.getLocation().y));
        dialog.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentPanel", "org/jetbrains/plugins/ruby/rails/actions/generators/GenerateDialogs", "showGenerateDialog"));
    }

    protected static class GenerateActionContainerDialog
    extends SimpleGenerateDialog {
        public GenerateActionContainerDialog(Module module, @NlsContexts.DialogTitle String title, ActionContainerInputValidator validator) {
            super(module, title, validator);
        }

        @Override
        @NotNull
        protected GeneratorPanel createGeneratorContent() {
            ActionContainerInputValidator validator = (ActionContainerInputValidator)this.myValidator;
            String relativePath = validator.getRelativePath();
            return new GenerateControllerPanel(validator.getEntityName(), validator.getDefaultName(), relativePath, this.myModule);
        }
    }

    public static abstract class GenerateDialog
    extends DialogWrapper {
        protected final Module myModule;
        protected final SimpleGeneratorInputValidator myValidator;
        private final Ref<ProcessOutput> helpData;
        private GeneratorPanel myGenerateDialogContent;

        public GenerateDialog(@NotNull Module module, SimpleGeneratorInputValidator validator) {
            if (module == null) {
                GenerateDialog.$$$reportNull$$$0(0);
            }
            super(module.getProject(), true);
            this.helpData = new Ref();
            this.myModule = module;
            this.myValidator = validator;
        }

        protected final JComponent createCenterPanel() {
            GeneratorOptions options = RProjectUtil.getGeneratorsOptions(this.myModule.getProject());
            this.myGenerateDialogContent = this.createGeneratorContent();
            this.myGenerateDialogContent.initPanel(options, this.myModule);
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)this.myGenerateDialogContent.getContent(), "Center");
            JComponent optionsPanel = this.myGenerateDialogContent.getOptionsPanel();
            if (optionsPanel != null) {
                panel2.add((Component)new HideableTitledPanel(RBundle.message((String)"dialog.generate.scaffold.options.title"), optionsPanel, false), "South");
            }
            return panel2;
        }

        @NotNull
        protected GeneratorPanel createGeneratorContent() {
            return new SimpleGeneratorPanel();
        }

        protected void doOKAction() {
            String generatorArgs = this.getGeneratorArgs();
            String dataToValidate = this.getDataToValidate();
            this.myGenerateDialogContent.saveSettings(this.myModule.getProject());
            if (this.myValidator == null) {
                this.close(0);
            } else if (this.myValidator.checkInput(dataToValidate) && this.myValidator.canClose(generatorArgs)) {
                this.close(0);
                this.myValidator.invokeAction(generatorArgs, this.myGenerateDialogContent.getEnvironment(), dataToValidate);
            }
        }

        protected void doHelpAction() {
            if (this.helpData.get() == null) {
                this.readHelpData();
            }
            String title = RBundle.message((String)"dialog.generate.common.help.title", (Object[])new Object[]{this.myValidator.getGeneratorAction().getGeneratorName()});
            GenerateDialogs.showGeneratorHelpDialog(this.myModule.getProject(), title, (ProcessOutput)this.helpData.get(), this);
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myGenerateDialogContent.getPreferredFocusedComponent();
        }

        protected void initDialog(@NlsContexts.DialogTitle String title) {
            this.setTitle(title);
            this.init();
        }

        private String getGeneratorArgs() {
            return this.myGenerateDialogContent.getGeneratorArgs();
        }

        protected String getDataToValidate() {
            return this.myGenerateDialogContent.getDataToValidate();
        }

        private void readHelpData() {
            ProcessOutput value;
            Sdk sdk;
            String title = RBundle.message((String)"progress.dialog.generate.common.help.wait.title");
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setText(RBundle.message((String)"progress.indicator.title.please.wait"));
            }
            if ((sdk = RModuleUtil.getInstance().findRubySdkForModule(this.myModule)) == null) {
                String errMsg = RBundle.message((String)"progress.dialog.generate.common.help.cannot.fetch.help.info") + " " + RubySdkUtil.getRubySdkIsntSetOrValideErrorText();
                value = new ProcessOutput();
                value.appendStderr(errMsg);
            } else {
                String workingDir = RailsFacetUtil.getRailsAppHomeDirPath(this.myModule);
                assert (workingDir != null);
                String name = this.myValidator.getGeneratorAction().getGeneratorName();
                try {
                    VirtualFile generateScript = GeneratorsUtil.getGenerateScript(this.myModule, false);
                    String path = generateScript != null ? generateScript.getPath() : "script/generate";
                    ArrayList<String> params = new ArrayList<String>();
                    Collections.addAll(params, GeneratorsUtil.buildParamsForRailsGenerator(path));
                    params.add(name);
                    params.add("--help");
                    value = ((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)((RubyScriptExecutionContext)RubyScriptExecutionContext.create(path, sdk).withModule(this.myModule)).withWorkingDirPath(workingDir)).withExecutionMode((ExecutionMode)new ExecutionModes.ModalProgressMode(title, (JComponent)this.getRootPane()))).withCommandLinePreprocessor(BundlerUtil.getBundlerPreprocessor(sdk, this.myModule))).withArguments(params)).executeScript();
                    assert (value != null);
                }
                catch (ExecutionException e) {
                    return;
                }
            }
            this.helpData.set((Object)value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/ruby/rails/actions/generators/GenerateDialogs$GenerateDialog", "<init>"));
        }
    }

    public static class SimpleGenerateDialog
    extends GenerateDialog {
        private final GeneratorPanel myPanel;

        public SimpleGenerateDialog(@NotNull Module module, @NlsContexts.DialogTitle String title, SimpleGeneratorInputValidator validator) {
            if (module == null) {
                SimpleGenerateDialog.$$$reportNull$$$0(0);
            }
            this(module, title, null, validator);
        }

        public SimpleGenerateDialog(@NotNull Module module, @NlsContexts.DialogTitle String title, GeneratorPanel panel2, SimpleGeneratorInputValidator validator) {
            if (module == null) {
                SimpleGenerateDialog.$$$reportNull$$$0(1);
            }
            super(module, validator);
            this.myPanel = panel2;
            this.initDialog(title);
        }

        @Override
        @NotNull
        protected GeneratorPanel createGeneratorContent() {
            if (this.myPanel != null) {
                GeneratorPanel generatorPanel = this.myPanel;
                if (generatorPanel == null) {
                    SimpleGenerateDialog.$$$reportNull$$$0(2);
                }
                return generatorPanel;
            }
            GeneratorPanel generatorPanel = super.createGeneratorContent();
            if (generatorPanel == null) {
                SimpleGenerateDialog.$$$reportNull$$$0(3);
            }
            return generatorPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/GenerateDialogs$SimpleGenerateDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GenerateDialogs$SimpleGenerateDialog";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGeneratorContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    protected static class GenerateScaffoldDialog
    extends GenerateDialog {
        private final String myGeneratorName;

        public GenerateScaffoldDialog(Module module, @NlsContexts.DialogTitle String title, SimpleGeneratorInputValidator validator, String generatorName) {
            super(module, validator);
            this.myGeneratorName = generatorName;
            this.initDialog(title);
        }

        @Override
        @NotNull
        protected GeneratorPanel createGeneratorContent() {
            if ("nifty_scaffold".equals(this.myGeneratorName)) {
                return new GenerateNiftyScaffoldPanel(this.myModule);
            }
            return new GenerateScaffoldPanel(this.myGeneratorName, this.myModule);
        }
    }

    protected static class GenerateSupportConfigDialog
    extends SimpleGenerateDialog {
        private SimpleGeneratorPanel myPanel;

        public GenerateSupportConfigDialog(Module module, @NlsContexts.DialogTitle String title, SimpleGeneratorInputValidator validator) {
            super(module, title, validator);
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myPanel.getContent();
        }

        @Override
        @NotNull
        protected GeneratorPanel createGeneratorContent() {
            this.myPanel = new SimpleGeneratorPanel();
            this.myPanel.getGeneratorArgsTextField().setVisible(false);
            SimpleGeneratorPanel simpleGeneratorPanel = this.myPanel;
            if (simpleGeneratorPanel == null) {
                GenerateSupportConfigDialog.$$$reportNull$$$0(0);
            }
            return simpleGeneratorPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/rails/actions/generators/GenerateDialogs$GenerateSupportConfigDialog", "createGeneratorContent"));
        }
    }

    protected static class GeneratorHelpDialog
    extends DialogWrapper {
        protected final ProcessOutput myOutput;

        public GeneratorHelpDialog(Project project, @NlsContexts.DialogTitle String title, ProcessOutput output2) {
            super(project, false);
            this.setModal(false);
            this.myOutput = output2;
            this.initDialog(title);
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                GeneratorHelpDialog.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        protected JComponent createCenterPanel() {
            return new GeneratorHelpPanel(this.myOutput).getContent();
        }

        private void initDialog(@NlsContexts.DialogTitle String title) {
            this.setTitle(title);
            this.init();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/rails/actions/generators/GenerateDialogs$GeneratorHelpDialog", "createActions"));
        }
    }
}

