/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.routes.RoutesParser;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfigurationType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class RailsWebBrowserUrlProvider
extends WebBrowserUrlProvider {
    public static final UrlPath.PathSegmentRenderer URL_PATH_VARIABLE_SUBSTITUTOR = new UrlPath.PathSegmentRenderer(){

        @NotNull
        public String visitVariable(@NotNull UrlPath.PathSegment.Variable variable) {
            String name;
            if (variable == null) {
                1.$$$reportNull$$$0(0);
            }
            if ("format".equals(name = variable.getVariableName())) {
                return "html";
            }
            if (name == null || name.endsWith("id")) {
                return "1";
            }
            String string = ":" + name;
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/RailsWebBrowserUrlProvider$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/RailsWebBrowserUrlProvider$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visitVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitVariable";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file) throws WebBrowserUrlProvider.BrowserException {
        FQN fqn;
        Module module;
        RMethod method;
        if (request == null) {
            RailsWebBrowserUrlProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RailsWebBrowserUrlProvider.$$$reportNull$$$0(1);
        }
        if ((method = RubyPsiUtil.getContainingRMethod(request.getElement())) != null) {
            RailsController controller;
            RClass rClass = RubyPsiUtil.getContainingRClassByContainer((RContainer)method);
            RailsController railsController = controller = rClass != null ? RailsController.fromClass(rClass) : null;
            if (rClass == null || controller == null) {
                throw new WebBrowserUrlProvider.BrowserException(RBundle.message((String)"rails.web.preview.unknown.controller", (Object[])new Object[]{file.getPresentableUrl()}));
            }
            RailsAction action = RailsAction.fromMethod(method);
            if (action == null) {
                throw new WebBrowserUrlProvider.BrowserException(RBundle.message((String)"rails.web.preview.unknown.action", (Object[])new Object[]{method.getName(), controller.getName()}));
            }
            module = controller.getModule();
            fqn = action.getMethod().getFQNWithNesting();
        } else {
            RailsView view = RailsView.fromFile(request.getFile());
            if (view == null) {
                if (RailsLayout.fromFile(request.getFile()) != null) {
                    throw new WebBrowserUrlProvider.BrowserException(RBundle.message((String)"rails.web.preview.unsupported.layouts"));
                }
                throw new WebBrowserUrlProvider.BrowserException(RBundle.message((String)"rails.web.preview.unknown.controller", (Object[])new Object[]{file.getPresentableUrl()}));
            }
            module = view.getModule();
            fqn = (FQN)ObjectUtils.doIfNotNull((Object)view.getMethod(), RElementWithFQN::getFQNWithNesting);
        }
        if (module == null || fqn == null) {
            return null;
        }
        String railsServerUrl = RailsWebBrowserUrlProvider.getRunningRailsServerUrl(request.getProject());
        if (railsServerUrl == null) {
            return null;
        }
        return RoutesParser.getInstance(module).getUrlPathsFor(fqn).stream().filter(it -> !ContainerUtil.or((Iterable)it.getSegments(), segment -> segment instanceof UrlPath.PathSegment.Undefined)).map(it -> it.getPresentation(URL_PATH_VARIABLE_SUBSTITUTOR)).flatMap(it -> Stream.ofNullable(Urls.parseFromIdea((CharSequence)(railsServerUrl + it)))).findFirst().orElse(null);
    }

    private static String getRunningRailsServerUrl(Project project) {
        String developmentUrl = null;
        String anyUrl = null;
        RunManager runManager = RunManager.getInstance((Project)project);
        for (RunConfiguration configuration : runManager.getConfigurationsList((ConfigurationType)RailsServerRunConfigurationType.getInstance())) {
            RailsServerRunConfiguration serverConfiguration = (RailsServerRunConfiguration)configuration;
            String address = serverConfiguration.getIPAddr();
            String port = serverConfiguration.getPort();
            if (!StringUtil.isNotEmpty((String)address) || !StringUtil.isNotEmpty((String)port)) continue;
            if (RailsWebBrowserUrlProvider.hasOpenWindow(serverConfiguration)) {
                return RailsWebBrowserUrlProvider.constructUrl(address, port);
            }
            if ("development".equals(serverConfiguration.getRailsEnvironmentType())) {
                developmentUrl = RailsWebBrowserUrlProvider.constructUrl(address, port);
                continue;
            }
            anyUrl = RailsWebBrowserUrlProvider.constructUrl(address, port);
        }
        return developmentUrl != null ? developmentUrl : anyUrl;
    }

    private static String constructUrl(String address, String port) {
        return "http://" + address + ":" + port + "/";
    }

    private static boolean hasOpenWindow(RailsServerRunConfiguration configuration) {
        for (RunContentDescriptor descriptor : ExecutionManagerImpl.getAllDescriptors((Project)configuration.getProject())) {
            if (!configuration.getName().equals(descriptor.getDisplayName())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "request";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/rails/RailsWebBrowserUrlProvider";
        objectArray[2] = "getUrl";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

