/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.GemsRunner;
import org.jetbrains.plugins.ruby.gem.detector.RubyGemDetector;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.gem.gem.actions.QuickInstallGemDialog;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemComparator;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.RakeRunConfigurationSettingsFactory;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.ui.wizard.RailsWizardSettings;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfigurationType;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.statistic.RailsAppExtraArgsCountCollector;
import org.jetbrains.plugins.ruby.util.ProjectQueues;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public final class RailsUtil {
    public static final Key<String> GENERATE_RAILS_VERSION = new Key("org.jetbrains.plugins.ruby.rails.RailsProjectGenerator.railsVersion");
    public static final List<Pair<String, String>> RUBY_MAX_RAILS_VERSION = new ArrayList<Pair<String, String>>();
    private static final String EQUAL = "=";
    private static final String MORE_EQUAL = ">=";
    private static final String LESS_EQUAL = "<=";
    private static final String PESSIMISTIC = "~>";
    private static final String[] VERSION_OPERATORS = new String[]{"=", ">=", "<=", "~>"};
    private static final Logger LOG = Logger.getInstance(RailsUtil.class);
    private static final Map<String, String> TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE = new HashMap<String, String>();
    public static final String REMOVE_SERVER_PID_COMMAND = "rm -f tmp/pids/server.pid";

    private RailsUtil() {
    }

    public static void generateRailsApp(@NotNull Module module, @NotNull Sdk sdk, @NotNull String applicationHomePath, boolean overwrite, @Nullable String railsVersion, @NotNull RailsWizardSettings.RailsProjectTypes railsProjectType, @NotNull RailsWizardSettings.PreconfiguredDatabaseTypes preconfiguredDatabaseType, boolean useJavaScriptFramework, @Nullable RailsWizardSettings.RailsJavaScriptFramework javaScriptFramework, @NotNull String additionalRailsOptions, @Nullable RunContentDescriptorFactory descriptorFactory, @Nullable Runnable onDone) {
        if (module == null) {
            RailsUtil.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            RailsUtil.$$$reportNull$$$0(1);
        }
        if (applicationHomePath == null) {
            RailsUtil.$$$reportNull$$$0(2);
        }
        if (railsProjectType == null) {
            RailsUtil.$$$reportNull$$$0(3);
        }
        if (preconfiguredDatabaseType == null) {
            RailsUtil.$$$reportNull$$$0(4);
        }
        if (additionalRailsOptions == null) {
            RailsUtil.$$$reportNull$$$0(5);
        }
        Project project = module.getProject();
        String moduleName = module.getName();
        String progressTitle = RBundle.message((String)"module.rails.generate.app.progress.title", (Object[])new Object[]{moduleName});
        String errorTitle = RBundle.message((String)"execution.error.title.generate.rails.app", (Object[])new Object[]{moduleName});
        PathMappingSettings pathMappings = RunnerUtil.getRunnerDefaultMappings(sdk, module);
        LOG.debug("Generating rails application for ", new Object[]{sdk, "  in ", applicationHomePath, " with rails ", railsVersion});
        String rubyOpt = null;
        boolean generateMountableEngine = railsProjectType == RailsWizardSettings.RailsProjectTypes.MountableEngine;
        boolean generateRailsApi = railsProjectType == RailsWizardSettings.RailsProjectTypes.RailsAPI;
        ArrayList<Object> generatorArgsList = new ArrayList<Object>();
        if (railsVersion != null) {
            generatorArgsList.add("_" + railsVersion + "_");
        }
        if (generateMountableEngine) {
            generatorArgsList.add("plugin");
        }
        if (VersionComparatorUtil.compare((String)railsVersion, (String)"3.0.0.beta4") >= 0) {
            generatorArgsList.add("new");
        }
        generatorArgsList.add(pathMappings.convertToRemote(applicationHomePath));
        if (!RailsUtil.isRails5OrHigher(railsVersion)) {
            rubyOpt = "-r fileutils";
        }
        if (useJavaScriptFramework) {
            if (javaScriptFramework != null) {
                if (RailsUtil.isRails7OrHigher(railsVersion)) {
                    generatorArgsList.add("--javascript=" + javaScriptFramework.getCodeName());
                } else if (RailsUtil.isRails51OrHigher(railsVersion)) {
                    generatorArgsList.add("--webpack=" + javaScriptFramework.getCodeName());
                } else {
                    generatorArgsList.add("--javascript=" + javaScriptFramework.getCodeName());
                }
            }
        } else {
            generatorArgsList.add("--skip-javascript");
        }
        if (generateMountableEngine) {
            generatorArgsList.add("--mountable");
        }
        if (RailsUtil.isRails5OrHigher(railsVersion) && generateRailsApi) {
            generatorArgsList.add("--api");
        }
        generatorArgsList.add(overwrite ? "--force" : "--skip");
        generatorArgsList.add("--database=" + preconfiguredDatabaseType.getCodeName());
        if (!additionalRailsOptions.isBlank()) {
            List additionalRailsOptionsList = ContainerUtil.filter((Collection)StringUtil.split((String)additionalRailsOptions, (String)" "), x -> !x.isEmpty());
            if (railsVersion != null) {
                additionalRailsOptionsList.forEach(item -> RailsAppExtraArgsCountCollector.logExtraArgsRailsAppCreated(railsVersion, item));
            }
            generatorArgsList.addAll(additionalRailsOptionsList);
        }
        MergingCommandLineArgumentsProvider provider = new MergingCommandLineArgumentsProvider(ArrayUtilRt.toStringArray(generatorArgsList), null, null, null);
        Filter[] filters = new Filter[]{new RStackTraceFilter(module)};
        Runnable openSignificantFilesAndPerformOnDone = () -> {
            try {
                String controllersRelativePath = (String)ContainerUtil.getFirstItem(RailsPaths.getDefaultPaths().get("app/controllers")) + "/application_controller.rb";
                GeneratorsUtil.openFileInEditor(project, controllersRelativePath, applicationHomePath);
                GeneratorsUtil.openFileInEditor(project, (String)ContainerUtil.getFirstItem(RailsPaths.getDefaultPaths().get("config/database")), applicationHomePath);
                BundlerUtil.openGemFileInEditor(project, applicationHomePath);
            }
            finally {
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        try {
            GemsRunner.runGemScriptInConsoleAndRefreshModule(module, sdk, progressTitle, null, "rails", railsVersion, "rails", applicationHomePath, provider, descriptorFactory, filters, openSignificantFilesAndPerformOnDone, false, rubyOpt);
        }
        catch (Exception exp) {
            LOG.warn(exp.getMessage());
            RunnerUtil.showErrorMessage(project, errorTitle, exp);
        }
    }

    public static boolean containsRailsApp(@Nullable String railsAppHomePath) {
        if (railsAppHomePath == null || !new File(railsAppHomePath).exists()) {
            return false;
        }
        return RailsUtil.containsBinRails(railsAppHomePath) || RailsUtil.containsAllAppCoreFiles(railsAppHomePath);
    }

    private static boolean containsAllAppCoreFiles(@NotNull String rootPath) {
        if (rootPath == null) {
            RailsUtil.$$$reportNull$$$0(6);
        }
        for (String path : RailsPaths.getDefaultPaths().get("config/routes.rb")) {
            if (new File(rootPath, path).exists()) continue;
            return false;
        }
        return new File(rootPath, "app").exists();
    }

    private static boolean containsBinRails(@NotNull String railsAppHomePath) {
        File binRailsFile;
        if (railsAppHomePath == null) {
            RailsUtil.$$$reportNull$$$0(7);
        }
        return (binRailsFile = new File(railsAppHomePath, "bin/rails")).exists() && !binRailsFile.isDirectory();
    }

    public static boolean isYmlFixture(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            RailsUtil.$$$reportNull$$$0(8);
        }
        if (file != null && file.getFileType().getName().equals("YAML")) {
            RailsApp railsAppFromFile = RailsApp.fromFile(project, file);
            VirtualFile originalFile = file;
            if (railsAppFromFile == null) {
                VirtualFile newOriginalFile;
                while (originalFile instanceof LightVirtualFile && (newOriginalFile = ((LightVirtualFile)originalFile).getOriginalFile()) != null && !originalFile.equals(newOriginalFile) && (railsAppFromFile = RailsApp.fromFile(project, originalFile = newOriginalFile)) == null) {
                }
            }
            if (railsAppFromFile != null) {
                for (VirtualFile virtualFile : railsAppFromFile.getFixtureFileRoots()) {
                    if (!FileUtil.isAncestor((String)virtualFile.getPath(), (String)originalFile.getPath(), (boolean)true)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isAssetsOrViewFile(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            RailsUtil.$$$reportNull$$$0(9);
        }
        if (file != null) {
            RailsPaths paths;
            RailsApp railsAppFromFile = RailsApp.fromFile(project, file);
            VirtualFile originalFile = file;
            if (railsAppFromFile == null) {
                VirtualFile newOriginalFile;
                while (originalFile instanceof LightVirtualFile && (newOriginalFile = ((LightVirtualFile)originalFile).getOriginalFile()) != null && !originalFile.equals(newOriginalFile) && (railsAppFromFile = RailsApp.fromFile(project, originalFile = newOriginalFile)) == null) {
                }
            }
            if (railsAppFromFile != null && (VfsUtilCore.isUnderFiles((VirtualFile)originalFile, (paths = railsAppFromFile.getPaths()).findFiles("app/assets")) || VfsUtilCore.isUnderFiles((VirtualFile)originalFile, paths.findFiles("app/views")))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isRailsGemAttached(@NotNull Module module) {
        if (module == null) {
            RailsUtil.$$$reportNull$$$0(10);
        }
        return RubyProjectGemSearchService.Companion.findGem(module, "rails") != null;
    }

    public static void createRailsRunConfiguration(final Module module) {
        final Project project = module.getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> ProjectQueues.getInstance(project).queue(RBundle.message((String)"rails.facet.builder.run.configuration.server.creating"), new Task.Backgroundable(project, RBundle.message((String)"rails.facet.builder.run.configuration.server.creating.for", (Object[])new Object[]{module.getName()}), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(RBundle.message((String)"progress.backgnd.indicator.title.please.wait", (Object[])new Object[]{this.getTitle()}));
                RunManager runManagerEx = RunManager.getInstance((Project)project);
                ApplicationManager.getApplication().runReadAction(() -> {
                    RailsUtil.createAndAddRakeConfiguration("test", module, runManagerEx);
                    RailsUtil.createAndAddRakeConfiguration("spec", module, runManagerEx);
                    RunnerAndConfigurationSettings developmentSettings = RailsUtil.createAndAddServerConfiguration(module, runManagerEx);
                    runManagerEx.setSelectedConfiguration(developmentSettings);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/RailsUtil$1", "run"));
            }
        }));
    }

    private static RunnerAndConfigurationSettings createAndAddServerConfiguration(Module module, RunManager runManager) {
        RunnerAndConfigurationSettings settings = RailsServerRunConfigurationType.getInstance().getWEBrickFactory().createConfigurationSettings(module, "development");
        runManager.addConfiguration(settings);
        return settings;
    }

    private static RunnerAndConfigurationSettings createAndAddRakeConfiguration(String taskFullName, Module module, RunManager runManager) {
        RakeRunConfigurationSettingsFactory[] extensions;
        HashMap<String, String> env = new HashMap<String, String>();
        String customizedRailsEnvironment = RailsUtil.getCustomizedRailsEnvironmentFor(taskFullName);
        if (customizedRailsEnvironment != null) {
            env.put("RAILS_ENV", customizedRailsEnvironment);
        }
        if ((extensions = (RakeRunConfigurationSettingsFactory[])RakeRunConfigurationSettingsFactory.EP_NAME.getExtensions()).length > 0) {
            RunnerAndConfigurationSettings settings = extensions[0].createRakeRunConfigurationSettings(module, taskFullName, env);
            runManager.addConfiguration(settings);
            return settings;
        }
        throw new IllegalArgumentException("Can't find Rake Configuration");
    }

    public static Module @NotNull [] getAllModulesWithRailsSupport(@NotNull Project project) {
        Module[] allModules;
        if (project == null) {
            RailsUtil.$$$reportNull$$$0(11);
        }
        ArrayList<Module> runnableModules = new ArrayList<Module>();
        for (Module module : allModules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!RailsFacetUtil.hasRailsSupport(module)) continue;
            runnableModules.add(module);
        }
        Module[] moduleArray = runnableModules.toArray(Module.EMPTY_ARRAY);
        if (moduleArray == null) {
            RailsUtil.$$$reportNull$$$0(12);
        }
        return moduleArray;
    }

    @Nullable
    public static VirtualFile getTestsStdUnitRoot(Module module) {
        StandardRailsPaths settings = RailsFacetUtil.getRailsAppStaticPaths(module);
        if (settings == null) {
            return null;
        }
        String url = settings.getTestsStdUnitRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Nullable
    public static VirtualFile getTestMockEnvironmentRoot(@NotNull Module module) {
        StandardRailsPaths settings;
        if (module == null) {
            RailsUtil.$$$reportNull$$$0(13);
        }
        if ((settings = RailsFacetUtil.getRailsAppStaticPaths(module)) == null) {
            return null;
        }
        String url = settings.getTestMockEnviromentRootURL();
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Nullable
    public static VirtualFile getScriptsRoot(@NotNull Module module) {
        VirtualFile binDir;
        StandardRailsPaths settings;
        if (module == null) {
            RailsUtil.$$$reportNull$$$0(14);
        }
        if ((settings = RailsFacetUtil.getRailsAppStaticPaths(module)) == null) {
            return null;
        }
        if (RailsUtil.isRails40OrHigher(module) && (binDir = VirtualFileManager.getInstance().findFileByUrl(settings.getBinRootURL())) != null) {
            return binDir;
        }
        return VirtualFileManager.getInstance().findFileByUrl(settings.getScriptsRootURL());
    }

    public static boolean hasRailsSupportInSDKOrModule(@Nullable Sdk sdk, @Nullable Module module) {
        return RubySdkUtil.isRubySDK(sdk) && (module != null && RailsUtil.isRailsGemAttached(module) || RubyGemSearchUtil.findGem(module, sdk, "rails") != null);
    }

    public static String[] getAllEnvironments(Module module) {
        if (module != null) {
            for (VirtualFile root : RailsPaths.getInstance(module).findFiles("config/environments")) {
                ArrayList<String> result = new ArrayList<String>();
                for (VirtualFile child : root.getChildren()) {
                    if (!FileTypeRegistry.getInstance().isFileOfType(child, (FileType)RubyFileType.RUBY)) continue;
                    result.add(child.getNameWithoutExtension());
                }
                if (result.isEmpty()) continue;
                return ArrayUtilRt.toStringArray(result);
            }
        }
        return new String[]{"development", "production", "test"};
    }

    public static boolean isRails40OrHigher(String railsVersion) {
        return VersionComparatorUtil.compare((String)railsVersion, (String)"4.0.0.beta") >= 0;
    }

    public static boolean isRails51OrHigher(String railsVersion) {
        return VersionComparatorUtil.compare((String)railsVersion, (String)"5.1.0.beta") >= 0;
    }

    public static boolean isRails7OrHigher(String railsVersion) {
        return VersionComparatorUtil.compare((String)railsVersion, (String)"7.0.0.a") >= 0;
    }

    public static boolean isRails71OrHigher(String railsVersion) {
        return VersionComparatorUtil.compare((String)railsVersion, (String)"7.1.0.beta") >= 0;
    }

    public static boolean isRails52OrHigher(String railsVersion) {
        return VersionComparatorUtil.compare((String)railsVersion, (String)"5.2.0.a") >= 0;
    }

    public static boolean isRails40OrHigher(Module module) {
        GemInfo gem = module != null ? RubyProjectGemSearchService.Companion.findGem(module, "rails") : null;
        return gem != null && VersionComparatorUtil.compare((String)gem.getVersion(), (String)"4.0.0.beta") >= 0;
    }

    public static boolean isRails42OrHigher(Module module) {
        GemInfo gem = module != null ? RubyProjectGemSearchService.Companion.findGem(module, "rails") : null;
        return gem != null && VersionComparatorUtil.compare((String)gem.getVersion(), (String)"4.2.0.beta") >= 0;
    }

    public static boolean isRails5OrHigher(String railsVersion) {
        return VersionComparatorUtil.compare((String)railsVersion, (String)"5.0.0.alpha") >= 0;
    }

    public static boolean isRails6OrHigher(String railsVersion) {
        return VersionComparatorUtil.compare((String)railsVersion, (String)"6.0.0.alpha") >= 0;
    }

    public static boolean isRails8OrHigher(String railsVersion) {
        return VersionComparatorUtil.compare((String)railsVersion, (String)"8.0.0.alpha") >= 0;
    }

    public static boolean isRails5OrHigher(@Nullable Module module) {
        GemInfo gem = module != null ? RubyProjectGemSearchService.Companion.findGem(module, "rails") : null;
        return gem != null && RailsUtil.isRails5OrHigher(gem.getVersion());
    }

    public static boolean isRails6OrHigher(@NotNull Module module) {
        GemInfo gem;
        if (module == null) {
            RailsUtil.$$$reportNull$$$0(15);
        }
        return (gem = RubyProjectGemSearchService.Companion.findGem(module, "rails")) != null && RailsUtil.isRails6OrHigher(gem.getVersion());
    }

    @Nullable
    public static String getRailsScriptExecutablePath(@NotNull Module module, String scriptRelativePath) {
        String homeDirUrl;
        if (module == null) {
            RailsUtil.$$$reportNull$$$0(16);
        }
        if ((homeDirUrl = RailsFacetUtil.getRailsAppHomeDirUrl(module)) == null) {
            return null;
        }
        String path = RailsUtil.getPathIfFileExists(homeDirUrl, "/bin/" + scriptRelativePath);
        return path == null ? RailsUtil.getPathIfFileExists(homeDirUrl, "/script/" + scriptRelativePath) : path;
    }

    @Nullable
    public static String getPathIfFileExists(String rorAppHomeDirUrl, String fileRelativePath) {
        String url;
        VirtualFileManager manager = VirtualFileManager.getInstance();
        VirtualFile file = manager.findFileByUrl(url = rorAppHomeDirUrl + "/" + fileRelativePath);
        return VirtualFileUtil.fileExists(file) ? file.getPath() : null;
    }

    @Nullable
    @NlsSafe
    public static String getCustomizedRailsEnvironmentFor(String taskFullCmd) {
        return TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.get(taskFullCmd);
    }

    @NotNull
    public static List<RFile> getEnvironments(@Nullable Module module) {
        if (!RailsFacetUtil.hasRailsSupport(module)) {
            List<RFile> list = Collections.emptyList();
            if (list == null) {
                RailsUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        List list = ContainerUtil.mapNotNull(RailsPaths.getInstance(module).findFiles("config/environment"), it -> (RFile)ObjectUtils.tryCast((Object)psiManager.findFile(it), RFile.class));
        if (list == null) {
            RailsUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    public static String getRailsVersion(Module module) {
        return (String)ReadAction.compute(() -> {
            RailsApp app = RailsApp.fromModule(module);
            if (app != null && app.getApplicationFile() != null) {
                VirtualFile gemfile = BundlerUtil.getGemfile(module);
                if (gemfile == null) {
                    return null;
                }
                Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
                RubyGemDetector detector = new RubyGemDetector();
                for (GemDependency dep : detector.detect(module.getProject(), sdk, gemfile)) {
                    if (!"rails".equals(dep.getName())) continue;
                    return dep.getVersionString();
                }
                return null;
            }
            for (RFile env : RailsUtil.getEnvironments(module)) {
                for (PsiElement psiElement : env.getStatements()) {
                    RModifierStatement statement;
                    RPsiElement command;
                    RAssignmentExpression assign = null;
                    if (psiElement instanceof RAssignmentExpression) {
                        assign = (RAssignmentExpression)psiElement;
                    } else if (psiElement instanceof RModifierStatement && (command = (statement = (RModifierStatement)psiElement).getCommand()) instanceof RAssignmentExpression) {
                        assign = (RAssignmentExpression)command;
                    }
                    if (assign == null) continue;
                    RPsiElement value = assign.getValue();
                    RPsiElement object = assign.getObject();
                    if (value == null || !Comparing.strEqual((String)"RAILS_GEM_VERSION", (String)object.getText())) continue;
                    return TextUtil.removeQuoting((String)value.getText());
                }
            }
            return "< 3.0.0.beta";
        });
    }

    public static boolean isUnderVendor(PsiElement element) {
        return (Boolean)ReadAction.compute(() -> {
            Module module;
            VirtualFile vFile;
            if (!element.isValid()) {
                return false;
            }
            PsiFile file = element.getContainingFile();
            if (file != null && file.isValid() && (vFile = file.getVirtualFile()) != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && RailsUtil.isUnderVendor(vFile, module)) {
                return true;
            }
            return false;
        });
    }

    public static boolean isUnderVendor(@NotNull VirtualFile vFile, @NotNull Module module) {
        if (vFile == null) {
            RailsUtil.$$$reportNull$$$0(19);
        }
        if (module == null) {
            RailsUtil.$$$reportNull$$$0(20);
        }
        return VfsUtilCore.isUnderFiles((VirtualFile)vFile, RailsPaths.getInstance(module).findFiles("vendor"));
    }

    @NlsSafe
    @Nullable
    public static String installGemSupport(@NotNull Sdk sdk, @Nullable Module module, String gemName, @Nullable List<String> installedVersions, String maxVersion, @Nullable AllVersionsGemCache allVersionsCache) {
        QuickInstallGemDialog dialog;
        GemInfo gemInfo;
        List versions;
        if (sdk == null) {
            RailsUtil.$$$reportNull$$$0(21);
        }
        Project project = RModuleUtil.getInstance().getProject(module);
        HashMap<GemDependency, String> errors = new HashMap<GemDependency, String>();
        if (allVersionsCache == null || allVersionsCache.getGemInfo() == null || allVersionsCache.getGemVersions() == null) {
            Set<GemInfo> gemsInfos = RailsUtil.loadGemsList(module, gemName, sdk);
            if (gemsInfos == null) {
                return null;
            }
            versions = ContainerUtil.map(gemsInfos, info -> info.getVersion());
            gemInfo = gemsInfos.iterator().next();
        } else {
            gemInfo = allVersionsCache.getGemInfo();
            versions = allVersionsCache.getGemVersions();
        }
        if (allVersionsCache != null && (allVersionsCache.getGemInfo() == null || allVersionsCache.getGemVersions() == null)) {
            allVersionsCache.setGemInfo(gemInfo);
            allVersionsCache.setGemVersions(versions);
        }
        List filteredVersions = installedVersions != null ? ContainerUtil.filter(versions, t -> !installedVersions.contains(t)) : versions;
        if (maxVersion != null) {
            filteredVersions = ContainerUtil.filter((Collection)filteredVersions, t -> VersionComparatorUtil.compare((String)t, (String)maxVersion) <= 0);
        }
        if ((dialog = new QuickInstallGemDialog(project, gemInfo, filteredVersions)).showAndGet()) {
            GemDependency dependency = GemDependency.create(gemName, dialog.getVersion());
            if (dependency == null) {
                LOG.warn(StringUtil.join((String[])new String[]{"Failed to create a dependency from gem ", gemName, "with version ", dialog.getVersion()}));
            }
            GemInstallCommandOptions options = new GemInstallCommandOptions().withIgnoreDependencies(!dialog.installDependencies()).withNoDocument(!dialog.generateDocs());
            GemInstallUtil.installGemsInBackground(sdk, null, Collections.singleton(dependency), options, GemInstallProcessOptions.updateExistingSync(errors));
            if (errors.isEmpty()) {
                return dialog.getVersion();
            }
            GemUiUtil.showInstallErrors(project, errors);
            return null;
        }
        return null;
    }

    @Nullable
    public static Set<GemInfo> loadGemsList(final @Nullable Module module, final @NotNull String gemName, final @NotNull Sdk sdk) {
        if (gemName == null) {
            RailsUtil.$$$reportNull$$$0(22);
        }
        if (sdk == null) {
            RailsUtil.$$$reportNull$$$0(23);
        }
        final Ref cancelled = Ref.create((Object)false);
        Project project = module == null ? null : module.getProject();
        final TreeSet<GemInfo> gemsSet = new TreeSet<GemInfo>(Collections.reverseOrder(new GemComparator()));
        ProgressManager.getInstance().run((Task)new Task.Modal(project, RBundle.message((String)"gems.downloading.gems.list.title", (Object[])new Object[]{gemName}), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                gemsSet.addAll(GemRunner.query(module, sdk, null, () -> {
                    ProgressIndicator indicator1 = ProgressManager.getInstance().getProgressIndicator();
                    return indicator1 != null && indicator1.isCanceled();
                }, gemName));
            }

            public void onCancel() {
                cancelled.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/RailsUtil$2", "run"));
            }
        });
        if (((Boolean)cancelled.get()).booleanValue()) {
            return null;
        }
        if (gemsSet.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)RBundle.message((String)"gems.gem.not.found", (Object[])new Object[]{gemName}), (String)RBundle.message((String)"gems.gem.installing.failed"));
            return null;
        }
        return gemsSet;
    }

    public static String parseRailsVersion(@Nullable String expression) {
        if (expression == null) {
            return null;
        }
        for (String op : VERSION_OPERATORS) {
            if (!expression.startsWith(op)) continue;
            return expression.substring(op.length()).trim();
        }
        return expression;
    }

    public static boolean isUnderChannelClientDirectory(@NotNull PsiFile file) {
        RailsApp app;
        if (file == null) {
            RailsUtil.$$$reportNull$$$0(24);
        }
        if ((app = RailsApp.fromFile(file.getProject(), file.getVirtualFile())) == null || !app.isRails5App()) {
            return false;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (virtualFile == null) {
            return false;
        }
        return VfsUtilCore.isUnderFiles((VirtualFile)virtualFile, app.getPaths().findFiles("app/assets", "javascripts", "channels"));
    }

    static {
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("test", "test");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("features", "test");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("cucumber", "test");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:migrate", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:migrate:up", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:migrate:down", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:migrate:redo", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:migrate:reset", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:create", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:drop", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:reset", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:version", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:rollback", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:structure:dump", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:structure:load", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:schema:dump", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:schema:load", "development");
        TASK_TO_CUSTOMIZED_RAILS_ENV_TABLE.put("db:fixtures:load", "development");
        RUBY_MAX_RAILS_VERSION.add((Pair<String, String>)Pair.create((Object)"1.8.6", (Object)"2.3.99"));
        RUBY_MAX_RAILS_VERSION.add((Pair<String, String>)Pair.create((Object)"1.8.7", (Object)"3.2.99"));
        RUBY_MAX_RAILS_VERSION.add((Pair<String, String>)Pair.create((Object)"1.9.3", (Object)"4.2.99"));
        RUBY_MAX_RAILS_VERSION.add((Pair<String, String>)Pair.create((Object)"2.2.2", (Object)"5.2.99"));
        RUBY_MAX_RAILS_VERSION.add((Pair<String, String>)Pair.create((Object)"2.5.0", null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationHomePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsProjectType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preconfiguredDatabaseType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalRailsOptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsAppHomePath";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/RailsUtil";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/RailsUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModulesWithRailsSupport";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateRailsApp";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsAllAppCoreFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsBinRails";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isYmlFixture";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAssetsOrViewFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isRailsGemAttached";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllModulesWithRailsSupport";
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTestMockEnvironmentRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getScriptsRoot";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isRails6OrHigher";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRailsScriptExecutablePath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isUnderVendor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "installGemSupport";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadGemsList";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isUnderChannelClientDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 17, 18 -> new IllegalStateException(string);
        };
    }

    public static class AllVersionsGemCache {
        @Nullable
        private GemInfo myGemInfo;
        @Nullable
        private List<String> myGemVersions;

        @Nullable
        public GemInfo getGemInfo() {
            return this.myGemInfo;
        }

        public void setGemInfo(@NotNull GemInfo gemInfo) {
            if (gemInfo == null) {
                AllVersionsGemCache.$$$reportNull$$$0(0);
            }
            this.myGemInfo = gemInfo;
        }

        @Nullable
        public List<String> getGemVersions() {
            return this.myGemVersions;
        }

        public void setGemVersions(@NotNull List<String> gemVersions) {
            if (gemVersions == null) {
                AllVersionsGemCache.$$$reportNull$$$0(1);
            }
            this.myGemVersions = gemVersions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemVersions";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/RailsUtil$AllVersionsGemCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGemInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGemVersions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

