/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.model.cache.DumbAwareCache;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPathsChangedListener;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.ConstantStringInferenceResultImpl;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public abstract class InflectorService
implements Disposable {
    public static final Topic<InflectionChanged> INFLECTIONS_CHANGED = new Topic(InflectionChanged.class);
    @NonNls
    protected static final String UNCOUNTABLE = "uncountable";
    @NonNls
    protected static final String PLURAL = "plural";
    @NonNls
    protected static final String SINGULAR = "singular";
    @NonNls
    protected static final String IRREGULAR = "irregular";
    @NonNls
    protected static final String ACRONYM = "acronym";
    @NonNls
    private static final String INFLECTIONS = "inflections";
    @NonNls
    private static final String CLEAR = "clear";
    protected final Module myModule;
    protected final RailsApp myApp;
    protected final Cache<String, String> myClassifyCache;
    protected final Cache<String, String> myTableizeCache;
    protected final Cache<String, String> mySingularizeCache;
    protected final Cache<String, String> myPluralizeCache;
    protected final Cache<String, String> myCamelizeCache;
    protected final Cache<String, String> myUnderscoreCache;
    private PsiCallable myInflectionsParser = new InflectorCallable();

    public InflectorService(Module module) {
        this.myModule = module;
        this.myApp = RailsApp.fromModule(this.myModule);
        Project project = this.myModule.getProject();
        this.myClassifyCache = new DumbAwareCache<String, String>(project, Caffeine.newBuilder().maximumSize(1000L).build());
        this.myTableizeCache = new DumbAwareCache<String, String>(project, Caffeine.newBuilder().maximumSize(1000L).build());
        this.mySingularizeCache = new DumbAwareCache<String, String>(project, Caffeine.newBuilder().maximumSize(1000L).build());
        this.myPluralizeCache = new DumbAwareCache<String, String>(project, Caffeine.newBuilder().maximumSize(1000L).build());
        this.myCamelizeCache = new DumbAwareCache<String, String>(project, Caffeine.newBuilder().maximumSize(1000L).build());
        this.myUnderscoreCache = new DumbAwareCache<String, String>(project, Caffeine.newBuilder().maximumSize(1000L).build());
        PsiManager.getInstance((Project)module.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                InflectorService.this.queueClearCaches(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                InflectorService.this.queueClearCaches(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                InflectorService.this.queueClearCaches(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                InflectorService.this.queueClearCaches(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                InflectorService.this.queueClearCaches(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/InflectorService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(GemManager.GEMSET_CHANGED_TOPIC, (Object)new GemManager.GemSetListener(){

            @Override
            public void gemSetChanged(@Nullable Set<Module> modules) {
                InflectorService.this.clearCaches();
            }
        });
        project.getMessageBus().connect((Disposable)this).subscribe(GemManager.MODULE_GEMS_CHANGED_TOPIC, (Object)new GemManager.ModuleGemsListener(){

            @Override
            public void gemsChanged(@NotNull Module module) {
                if (module == null) {
                    3.$$$reportNull$$$0(0);
                }
                InflectorService.this.clearCaches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/ruby/rails/InflectorService$3", "gemsChanged"));
            }
        });
        project.getMessageBus().connect((Disposable)this).subscribe(RailsPathsChangedListener.TOPIC, __ -> this.clearCaches());
    }

    public static InflectorService getInstance(@NotNull Module module) {
        if (module == null) {
            InflectorService.$$$reportNull$$$0(0);
        }
        return (InflectorService)module.getService(InflectorService.class);
    }

    private void queueClearCaches(PsiTreeChangeEvent event) {
        PsiFile file = (PsiFile)ObjectUtils.coalesce((Object)event.getFile(), (Object)((PsiFile)ObjectUtils.tryCast((Object)event.getChild(), PsiFile.class)));
        if (file == null) {
            return;
        }
        RailsPaths paths = RailsPaths.getInstance(this.myModule);
        if (file.getName().equals("inflections.rb") || paths.getUrls("config/environment").contains(file.getVirtualFile().getUrl())) {
            this.clearCaches();
        }
    }

    public void clearCaches() {
        this.myPluralizeCache.invalidateAll();
        this.mySingularizeCache.invalidateAll();
        this.myClassifyCache.invalidateAll();
        this.myTableizeCache.invalidateAll();
        this.myCamelizeCache.invalidateAll();
        this.myUnderscoreCache.invalidateAll();
        Project project = this.myModule.getProject();
        if (!this.myModule.isDisposed() && !project.isDisposed()) {
            ((InflectionChanged)project.getMessageBus().syncPublisher(INFLECTIONS_CHANGED)).changed(this.myModule);
        }
    }

    public boolean isSingular(@Nullable String name) {
        if (name == null) {
            return false;
        }
        return name.equals(this.singularize(name));
    }

    @NotNull
    protected static List<PsiFile> getInflections(Module module, RailsApp app) {
        if (app == null) {
            List<PsiFile> list = Collections.emptyList();
            if (list == null) {
                InflectorService.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiManager manager = PsiManager.getInstance((Project)module.getProject());
        List list = ContainerUtil.mapNotNull(app.getPaths().findFiles("config/initializers", "inflections.rb"), arg_0 -> ((PsiManager)manager).findFile(arg_0));
        if (list == null) {
            InflectorService.$$$reportNull$$$0(2);
        }
        return list;
    }

    public abstract boolean isInflectorAvailable();

    @Nullable
    public abstract String classify(String var1);

    @Nullable
    public abstract String tableize(String var1);

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public abstract String singularize(@Nullable String var1);

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public abstract String pluralize(@Nullable String var1);

    @NotNull
    public abstract String camelize(@Nullable String var1);

    @NotNull
    public abstract String underscore(@Nullable String var1);

    protected void updateInflectionExceptions(@Nullable PsiFile file) {
        if (!(file instanceof RFile)) {
            return;
        }
        ProgressManager.checkCanceled();
        this.loadInflectionExceptions((RContainer)((RFile)file));
    }

    protected void loadInflectionExceptions(@NotNull RContainer container) {
        if (container == null) {
            InflectorService.$$$reportNull$$$0(3);
        }
        this.myInflectionsParser = this.myInflectionsParser != null ? this.myInflectionsParser : new InflectorCallable();
        RubyPsiInterpreter interpreter = new RubyPsiInterpreter(true);
        interpreter.registerCallable(this.myInflectionsParser, "Inflector.inflections", "ActiveSupport::Inflector.inflections", "Inflector", "ActiveSupport::Inflector");
        interpreter.interpret((PsiElement)container, null);
    }

    protected abstract void clearExceptions();

    protected abstract void uncountable(String var1);

    protected abstract void plural(RPsiElement var1, RPsiElement var2);

    protected abstract void singular(RPsiElement var1, RPsiElement var2);

    protected abstract void irregular(RPsiElement var1, RPsiElement var2);

    protected abstract void acronym(String var1);

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/InflectorService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/InflectorService";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInflections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadInflectionExceptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private class InflectorCallable
    implements PsiCallable {
        private InflectorCallable() {
        }

        @Override
        public void processCall(RCallArguments arguments) {
            RPsiElement val;
            List<RPsiElement> args;
            if (arguments.hasBlock() && Comparing.strEqual((String)InflectorService.INFLECTIONS, (String)arguments.getCommand())) {
                arguments.interpretBlock(this);
                return;
            }
            String command = arguments.getCommand();
            if (Comparing.strEqual((String)InflectorService.CLEAR, (String)command)) {
                InflectorService.this.clearExceptions();
            }
            RPsiElement key = !(args = arguments.getArguments()).isEmpty() ? args.get(0) : null;
            RPsiElement rPsiElement = val = args.size() > 1 ? args.get(1) : null;
            if (key == null) {
                return;
            }
            if (Comparing.strEqual((String)InflectorService.UNCOUNTABLE, (String)command)) {
                ArrayList strings = new ArrayList(2);
                for (RPsiElement element : args) {
                    TextUtil.flatten((RPsiElement)element, strings);
                }
                for (String uncountable : strings) {
                    if (StringUtil.isEmpty((String)uncountable)) continue;
                    InflectorService.this.uncountable(uncountable);
                }
                return;
            }
            if (Comparing.strEqual((String)InflectorService.ACRONYM, (String)command)) {
                InflectorService.this.acronym(ConstantStringInferenceResultImpl.getStringRepresentation((PsiElement)key).getOnlyString());
                return;
            }
            if (val == null) {
                return;
            }
            if (Comparing.strEqual((String)InflectorService.PLURAL, (String)command)) {
                InflectorService.this.plural(key, val);
            } else if (Comparing.strEqual((String)InflectorService.SINGULAR, (String)command)) {
                InflectorService.this.singular(key, val);
            } else if (Comparing.strEqual((String)InflectorService.IRREGULAR, (String)command)) {
                InflectorService.this.irregular(key, val);
            }
        }
    }

    public static interface InflectionChanged {
        public void changed(Module var1);
    }
}

